//
// C++ Implementation: gutenindex
//
// Description:
//
//
// Author: Lorn Potter <lorn.potter@gmail.com>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gutenindex.h"
#include "networkdialog.h"
#include "zip/unzip.h"

#include <QFile>
#include <QTextStream>
#include <QList>
#include <QString>
#include <QtXml>
#include <QMessageBox>
#include <QDir>
//http://www.gutenberg.org/dirs/GUTINDEX.zip
gutenIndex::gutenIndex()
        : QObject()
{
//    QTimer::singleShot(0, this, SLOT(parseIndex()));
    gutindexFilename = QDir::homePath() +"/.gutenbrowser/GUTINDEX.ALL"; 
}


gutenIndex::~gutenIndex()
{
}

bool gutenIndex::parseIndex()
{
    qWarning() << __PRETTY_FUNCTION__;
    QString year, file, indexLine, number;
    QStringList list, list2;
        
    QFile indexLib(gutindexFilename);
    //    libraryList->clear();
    

    if ( indexLib.open( QIODevice::ReadOnly)) {
          // file opened successfully
        QTextStream indexStream( &indexLib );
        QString indexLine;

        bool okToRead = false;
        while ( !indexStream.atEnd() ) {
            qApp->processEvents();
            QString file2="";
            indexLine = indexStream.readLine();
            if(indexLine.contains("Posting Dates "))

//    if(indexLine == "<==Start GUTINDEX.ALL listings==>")
                okToRead = true;
            if(indexLine == "<==End of GUTINDEX.ALL==>") {
                okToRead = false;
                indexLib.seek(indexLib.size());
            }

            if(okToRead) {
                QStringList token = indexLine.split(' ');
                int textNumber;
                QString bookIndexNumber = token.last();
                //   id = bookIndexNumber;

                if(bookIndexNumber.right(1) == "C")
                    bookIndexNumber.chop(1);

                if(indexLine.mid(0,72).contains("Magna")) //special case
                    bookIndexNumber = "10000";

                if(( textNumber = bookIndexNumber.toInt() ))
                    if(textNumber > 0) {
                        file = findPath(bookIndexNumber);
                        title = indexLine.mid(0,72);
                        //  file = findPath(file);

                        if(textNumber < 10001) {
//most of these titles had the "publish date' in the title
                            bool ok;
                            title.mid(5,1).toInt(&ok,10);
                            if(ok)
                                title = title.right(title.length() - 9);
                            title = title.left(title.indexOf("[",0));

                            QString title2 = title;

                              if(token[1].toInt() && token[1].toInt() > 1969) {
                                year = token[1];
                                  file2 = indexLine.mid(60,12);
                                  file2 = file2.replace("[","");
                                  file2 = file2.replace("]","");

                                      if(file2.indexOf("?", 0) != -1 ) {
                                          QString tmpfile = file2.replace(QRegExp("[?]"), "8");
                                          file2 = tmpfile;
                                    }
                                  file = findOldPath(year,file2);
                                  title = indexLine.mid( 9, 50);
                            }
                         //end old etexts
                        }

                        addAuthor();
                        if(title.indexOf(", by",0))
                           title = title.left(title.indexOf(", by",0));
                    }

                if( textNumber != 0)
                    if( title.indexOf( "reserved",0) == -1
                        && (!title.isEmpty())
                        && (file.indexOf( "]",0) == -1)
                        &&(title.indexOf( "Audio",0) == -1)) {
                          //  qWarning(QString(title+" "+author+" "+year+" "+file).toLocal8Bit());
                        list.clear();
                            // 0    title
                            // 1    author
                            // 2    file
                            // 3    id
                            list
                                << title.simplified()
                                << author.simplified()
                                << file.simplified()
                                << bookIndexNumber.simplified();

                            //   out << title << "  "<< author << "  "<< bookIndexNumber << "  "<< file << endl;

                        libraryList << list;

                    } //end okToTRead
                textNumber = 0;
            }
        }
    } else {
        qWarning("gutenIndex: gutindex.all not opened");
        return false;
    }
    indexLib.close();
    
/*    QFile data("libraryoutput.txt");
    data.open(QFile::WriteOnly | QFile::Truncate);
    QTextStream out(&data);*/
    
    return true;
}


bool gutenIndex::addAuthor()
{
     if( title.contains( ", by")) {
        int auth;
        auth = title.indexOf(", by", 0);
        author = title.right(title.length() - (auth + 4));
        if( int finder = author.indexOf("[",0 )) {
            author = author.left(finder);
        }
    }
    else if ( title.contains( "by, ") ) {
        int auth;
        auth = title.indexOf("by, ", 0);
        author = title.right(title.length() - (auth + 4) );
        if( int finder = author.indexOf("[", 0)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( " by") ) {
        int auth;
        auth = title.indexOf(" by", 0);
        author = title.right(title.length() - (auth + 3) );
        if( int finder = author.indexOf("[", 0)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( "by ") ) {
        int auth;
        auth = title.indexOf("by ", 0);
        author = title.right(title.length() - (auth + 3) );
        if( int finder = author.indexOf("[", 0)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( ",") ) {
        int auth;
        auth = title.indexOf(",", 0);
        author = title.right( title.length() - (auth + 1) );
        if ( author.contains( ",") ) {
            int auth;
            auth = author.indexOf(",", 0);
            author = author.right( author.length() - (auth + 1) );
        }
        if( int finder = author.indexOf("[", 0)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( "/") ) {
        int auth;
        auth = title.indexOf("/", 0);
        author = title.right(title.length() - (auth + 1) );
        if( int finder = author.indexOf("[", 0)) {
            author = author.left( finder);
        }
    }
    else if ( title.contains( "of") ) {
        int auth;
        auth = title.indexOf("of", 0);
        author = title.right(title.length() - (auth + 2) );
        if( int finder = author.indexOf("[", 0))
          {
              author = author.left( finder);
          }
    } else {
        author = "";
    }
    if ( author.contains("et. al")) {
        int auth;
        auth = author.indexOf("et. al", 0);
        author = author.left( auth );
    }
    if ( author.contains("#")) {
        int auth;
        auth = author.indexOf("#", 0);
        author = author.left( auth);
    }
    if ( author.contains("(")) {
        int auth;
        auth = author.indexOf("(", 0);
        author = author.left( auth);
    }
    if ( author.contains("et al")) {
        int auth;
        auth = author.indexOf("et al", 0);
        author = author.left( auth );
    }
    QRegExp r = QRegExp("[0-9]");
    if ( author.left(2).indexOf( r) != -1 ) {
        author = "";
    }
      // if( author.contains(" ", TRUE)) {
      // int suth = author.findRev(" ", -1, TRUE);
      // author = author.right( author.length() - suth);
      // }

      // title
      // author
    return true;
}

QList<QStringList> gutenIndex::getLibrary()
{
    return libraryList;
}

bool gutenIndex::parseRdf()
{
    //http://www.gutenberg.org/feeds/catalog.rdf.zip
    return false;
}


QString gutenIndex::findPath(QString &file)
{
    QString fileName;
    int stringlength = file.length();
    for(int i = 0; i < stringlength - 1;  i++ ) {
        fileName += "/"+ file[i];
    }

    fileName += "/" + file;//+"/"+file;
    //fileName += "/" + file+"-h/"+file+"-h";

    return fileName;
}

QString gutenIndex::findOldPath(const QString &year, const QString &file)
{
    QString newFile = file.left(file.indexOf(".xxx", 1)).left(file.left(file.indexOf(".xxx", 1)).indexOf("x", 1));

    QString newYear;
    newYear = year.right(2);
    int i_newYear = newYear.toInt(0, 10);
    if (i_newYear < 91 && i_newYear > 70)
        newYear = "90";

    return "/etext"  + newYear + "/"+newFile;

}


void gutenIndex::downloadNewIndex()
{
    NetworkDialog *net;
    net = new NetworkDialog();

    QSettings settings("llornkcor", "Gutenbrowser");
    QString currentServer = settings.value("network/server").toString();
    if(!currentServer.isEmpty()) {

        QFileInfo fi(gutindexFilename);
              
        qWarning() << "Filesize is" <<fi.size();
        net->setFileSize(fi.size());
        // "http://www.gutenberg.org/dirs/GUTINDEX.zip"
        net->setUrl(currentServer + "GUTINDEX.zip");
        net->setFile(gutindexFilename + ".zip");
        if( net->exec() == QDialog::Accepted)
            unzipIndex(gutindexFilename + ".zip");
    } else {
        QMessageBox::information(0,"Server Settings",
                                 "<p>Please select a Gutenberg server mirror to download your etext.</p>",0);

    }
}


/*!
    \fn gutenIndex::unzipIndex(const QString &file)
 */
bool gutenIndex::unzipIndex(const QString &file)
{
    UnZip::ErrorCode ec;
    UnZip uz;
      //    if (pwd != 0)
      //  uz.setPassword(*pwd);
    qWarning() << __PRETTY_FUNCTION__<< file;
    ec = uz.openArchive(file);
    if (ec != UnZip::Ok)  {
        qWarning() << "Unzip error code: " << ec;
        QString errorCode = tr("Error Code: %1").arg(QString::number(ec));
        QMessageBox::critical(0, tr("Critical"),
                              tr("<p>There was a problem opening gutindex.</P>")
                              +errorCode ,
                              QMessageBox::Cancel,
                              QMessageBox::NoButton);        
        return false;
    }
    
    ec = uz.extractAll( QFileInfo(gutindexFilename).absoluteDir());
    if (ec != UnZip::Ok) {
        return false;
    }
    return true;
}
