%{

#include <glib.h>

extern int  debug;
int         num = 0;
char        command[1024];
GList       *args;
extern char *yytext;

void add_argument(const char*);
int gpparser_execute_command(const char*,GList*);
extern void gpparser_reinit_parser(void);


%}

%token WORD INT_NUMBER COMMAND_SEPERATOR

%%

statements:
	statement
|	statement statements
;

statement:
	command arguments COMMAND_SEPERATOR
	{ gpparser_execute_command(command,args); gpparser_reinit_parser(); }
|	command arguments 
	{ gpparser_execute_command(command,args); gpparser_reinit_parser(); }
;

command:
	WORD
	{ if(debug)printf("parse: command\n"); strncpy(command,yytext,1024); }
|	'?'
	{ if(debug)printf("parse: command\n"); strncpy(command,"help",1024); }
|	{ command[0] = '\0'; }
;

arguments:
|	argument
|	argument ',' arguments
|	argument arguments
;

argument:
	WORD
	{ if(debug)printf("parse: word\n"); add_argument(yytext); }
|	INT_NUMBER
	{ if(debug)printf("parse: number\n"); add_argument(yytext); }
;

%%

int yyerror(char*s)
{
  printf("parser error: %s\n",s);
}

void init_parser(void)
{
  args = g_list_alloc();
}

void arg_reaper(gpointer data, gpointer nothing)
{
  g_free(data);
}

void cleanup_parser(void)
{
  g_list_foreach(args,arg_reaper,NULL);
  g_list_free(args);
}

void add_argument(const char*arg)
{
  char *s = g_strdup(arg);
  g_list_append(args,s);
}

