#ifndef MAILLIST_H
#define MAILLIST_H 1

#include <glib.h>
#include <objc/Object.h>
#include <objc/objc.h>
#include <libgnome/libgnome.h>

#define APPNAME "gmailman"

BOOL MLProcessMessage(id aMessage);

GList *MLGetListObjects(void);
GList *MLGetListTypes(void); /* Do not free the result of this */

@interface Persona : Object
{
  char *gecos, *emailaddr;
}
- initWithPersonaInfo:(char *)fullName
		     :(char *)emailAddress;
- initFromConfig:(char *) config_path;
- saveToConfig:(char *) config_path;
- (const char *)getFullName;
- (const char *)getEmailAddress;
@end

@interface MailMessage : Object
{
  GHashTable *headers;
  GString *body;
}
- initFromStream:(FILE *) astream;
- (const char *) getHeaderValue:(const char *) headerName;
- (const char *) getBody;
- writeToStream:(FILE *) astream;
@end

enum _ss { LIST_UNSUBSCRIBED, LIST_SUBSCRIBED };
typedef enum _ss   SubscriptionStatus;

@interface MailList : Object
{
  char *listaddr, *ctladdr, *name, *desc, *mltype;
  SubscriptionStatus status;
}
+ newFromStream:(FILE *) astream;
- initWithMaillistInfo:(const char *) inlistaddr
		      :(const char *) inctladdr
		      :(const char *) inname
		      :(const char *) indesc
		      :(const char *) inmltype
		      :(SubscriptionStatus) instatus;
- initFromStream:(FILE *) astream;
- initFromConfig:(char *) config_path;
- saveToConfig:(char *) config_path;
- (BOOL) subscribe:(id) persona;
- (BOOL) unsubscribe:(id) persona;
- (const char *) getName;
- (const char *) getListAddress;
- (const char *) getControlAddress;
- (const char *) getDescription;
- (SubscriptionStatus) getStatus;

/* Use only in child classes */
- (FILE *) sendMail:(id) fromPersona
		   :(const char *) toAddress
		   :(const char *) subjectLine;
/* Define in child classes */
- (BOOL) sendControlMessage:(id) persona
			   :(const char *) ctlmsg
			   :(const char *) data;
- (BOOL) handleMessage:(id) aMessage;
@end

#endif
