/* GNOME DB library
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gnome-db-moniker.h"
#include <bonobo/bonobo-moniker-util.h>
#include <libgnome/gnome-i18n.h>

struct _GnomeDbMonikerPrivate {
	GnomeDbMonikerResolveFunc resolve_func;
};

/*
 * Private functions
 */
static void
moniker_destroy_cb (GnomeDbMoniker *moniker, gpointer data)
{
	g_return_if_fail(GNOME_DB_IS_MONIKER(moniker));
	
	if (moniker->priv) {
		g_free((gpointer) moniker->priv);
	}
}

/*
 * GnomeDbMoniker object interface
 */
static void
gnome_db_moniker_class_init (GnomeDbMonikerClass *klass)
{
	BonoboMonikerClass* mclass = (BonoboMonikerClass *) klass;
}

static void
gnome_db_moniker_init (GnomeDbMoniker *moniker)
{
	g_return_if_fail(GNOME_DB_IS_MONIKER(moniker));
	
	moniker->priv = g_new0(GnomeDbMonikerPrivate, 1);
	gtk_signal_connect(GTK_OBJECT(moniker),
	                   "destroy",
	                   GTK_SIGNAL_FUNC(moniker_destroy_cb),
	                   NULL);
}

GtkType
gnome_db_moniker_get_type (void)
{
	static GtkType type = 0;
	
	if (!type) {
		GtkTypeInfo info = {
			"GnomeDbMoniker",
			sizeof(GnomeDbMoniker),
			sizeof(GnomeDbMonikerClass),
			(GtkClassInitFunc) gnome_db_moniker_class_init,
			(GtkObjectInitFunc) gnome_db_moniker_init,
			NULL,
			NULL,
			(GtkClassInitFunc) NULL
		};
		type = gtk_type_unique(bonobo_moniker_simple_get_type(), &info);
	}
	return type;
}

/**
 * gnome_db_moniker_new
 */
GnomeDbMoniker *
gnome_db_moniker_new (const gchar *prefix,
                      GnomeDbMonikerResolveFunc resolve_func)
{
	GnomeDbMoniker* moniker;

	g_return_val_if_fail(prefix != NULL, NULL);

	moniker = GNOME_DB_MONIKER(gtk_type_new(GNOME_DB_MONIKER_TYPE));

	return gnome_db_moniker_construct(moniker, prefix, resolve_func);
}

/**
 * gnome_db_moniker_construct
 */
GnomeDbMoniker *
gnome_db_moniker_construct (GnomeDbMoniker *moniker,
                            const gchar *prefix,
                            GnomeDbMonikerResolveFunc resolve_func)
{
}


