/*  Glimmer - glimmerout.c
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include <unistd.h>

void exit_func (GtkWidget * widget, gpointer data);

int
main (int argc, char *argv[])
{
    GtkWidget *window;
    GtkWidget *scrolled;
    GtkWidget *list;
    gchar *string;
    FILE *exec;
    gchar output[512] = "";
    char *args[2] = { NULL, NULL };
    int i;

    if (argc < 2)
        return (-1);

    gnome_init ("glimmer-output", "glimmer-output v 1.0", 1, argv);

    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window), argv[1]);
    gtk_widget_set_usize (window, 400, 400);
    gtk_container_set_border_width (GTK_CONTAINER (window), 5);
    scrolled = gtk_scrolled_window_new (0, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (window), scrolled);
    list = gtk_clist_new (1);
    gtk_clist_set_selection_mode (GTK_CLIST (list), GTK_SELECTION_SINGLE);
    gtk_clist_set_shadow_type (GTK_CLIST (list), GTK_SHADOW_ETCHED_IN);
    gtk_clist_set_row_height (GTK_CLIST (list), 16);
    gtk_container_add (GTK_CONTAINER (scrolled), list);
    gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                        GTK_SIGNAL_FUNC (exit_func), NULL);
    gtk_widget_show_all (window);

    for (i = 1; i < argc; i++) {
        strcat (output, argv[i]);
        strcat (output, " ");
    }

    string = output;
    if (!(exec = popen (string, "r"))) {
        perror ("Error opening process!");
        g_print ("\a");
        return (-1);
    }
    while (fgets (output, sizeof (output), exec)) {
        args[0] = output;
        gtk_clist_append (GTK_CLIST (list), args);
        while (gtk_events_pending ())
            gtk_main_iteration ();
    }
    args[0] = "Done.";
    gtk_clist_append (GTK_CLIST (list), args);
    gtk_main ();
    pclose (exec);
    return (0);
}

void
exit_func (GtkWidget * widget, gpointer data)
{
    gtk_main_quit ();
}
