// -*- C++ -*-

/* 
 * GChemPaint library
 * application.h 
 *
 * Copyright (C) 2004 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_APPLICATION_H
#define GCHEMPAINT_APPLICATION_H

#include "tool.h"
#include "dialog.h"
#include "bonobo/bonobo-ui-node.h"
#include <string>
#include <map>

class gcpApplication
{
public:
	gcpApplication();
	virtual ~gcpApplication();

	virtual void ActivateMenu(const string& menuname, bool activate);
	virtual void ToggleMenu(const string& menuname, bool active) = 0;
	virtual void ActivateTool(const string& toolname, bool activate);
	virtual void ActivateToolItem(const string& itemname, bool activate);
	virtual void ClearStatus();
	virtual void SetStatusText(const char* text);
	void AddUI(const char* filename);
	virtual GtkWindow* GetWindow() = 0;
	virtual void RemoveDocument(gcpDocument* pDoc) = 0;
	void SetMenu(const string& menuname, GtkWidget* menu) {Menus[menuname] = menu;}
	GtkWidget* GetMenu(const string& name) {return Menus[name];}
	gcpTool* GetActiveTool() {return m_pActiveTool;}
	gcpDocument* GetActiveDocument() {return m_pActiveDoc;}
	gcpTool* GetTool(const string& name) {return Tools[name];}
	void SetTool (const string& toolname, gcpTool* tool) {Tools[toolname] = tool;}
	GtkWidget* GetToolItem(const string& name) {return ToolItems[name];}
	void SetToolItem(const string& name, GtkWidget* w) {ToolItems[name] = w;}
	void SetDialog(const string& name, gcpDialog* dialog) {Dialogs[name] = dialog;}
	gcpDialog* GetDialog(const string& name) {return Dialogs[name];}
	void SetCurZ(int Z) {m_CurZ = Z;}
	int GetCurZ() {return m_CurZ;}
	void OnSaveAs();
	bool FileProcess(const gchar* filename, int filetype, bool bSave, GtkWindow *window, gcpDocument *pDoc = NULL);
	void SaveWithBabel(const gchar* filename, const gchar* ext, gcpDocument* pDoc, int Type);
	void OpenWithBabel(const gchar* filename, const gchar* ext, gcpDocument* pDoc, int Type);
	void SaveGcp(const gchar* filename, gcpDocument* pDoc);
	void OpenGcp(const gchar* filename, gcpDocument* pDoc);
	char* GetFontName() {return FontName;}
	void SetFontName(char* fontname);
	xmlDocPtr GetXmlDoc() {return XmlDoc;}
	void SetCallback(const string& name, GCallback cb) {Callbacks[name] = cb;}
	GCallback GetCallback(const string& name) {return Callbacks[name];}
	void OnHelp (char* tag = NULL);
	void OnBug ();
	void OnWeb ();
	void OnMail ();
	void OnShowElements ();
	void OnSaveAsImage ();
	bool HaveGhemical () {return m_Have_Ghemical;}
	char const* GetCurDir () {return CurDir;}
	void SetCurDir (char const* dir);
	int GetDocsNumber () {return m_Docs.size ();}

protected:
	virtual void AddDocument(gcpDocument* pDoc) = 0;
	void InitTools();

private:
	void MergeNodes(BonoboUINode* Dest, BonoboUINode* Source);

protected:
	int m_CurZ;
	gcpDocument* m_pActiveDoc;
	std::list<gcpDocument*> m_Docs;
	map <string, GtkWidget*> Menus;
	map <string, GtkWidget*> ToolItems;
	map <string, GtkWidget*> Toolbars;
	map <string, gcpTool*> Tools;
	map <string, gcpDialog*> Dialogs;
	map <string, GCallback> Callbacks;
	gcpTool* m_pActiveTool;
	static bool m_bInit, m_Have_Ghemical;
	static map<string, string> m_SupportedPixbufFormats;
	BonoboUINode* m_pNode;
	char *FontName;
	string HelpBrowser;
	string HelpFilename;
	string WebBrowser;
	string MailAgent;
	xmlDocPtr XmlDoc;
	char *CurDir;
};

extern list<gcpApplication*> Apps;

#endif //GCHEMPAINT_APPLICATION_H
