Strun popis pevodu textu do zvukov podoby ve Festivalu
==========================================================

Cel proces eov syntzy Festivalu je velmi podrobn popsn vdokumentu
Building Synthetic Voices, kter je kmn na www.festvox.org a lze jej
doporuit kadmu, kdo chce festivalov mechanismy pochopit do dostaten
hloubky.  Dal informace jsou pak kdispozici vmanulu Festivalu, ty jsou
vak vuritch smrech nepln a bez ve uvedenho dokumentu se pi
seriznj prci na novm festivalovm jazyce a/nebo hlasu nelze obejt.

Tento dokument je strunm popisem syntzy a dostupnch nstroj pro ty, kdo
potebuj zskat zkladn orientaci vprocesu festivalov syntzy a pitom
nemaj as anebo zjem se vnovat zdlouhavmu a podrobnmu studiu ve
uvedench dokument.  Nejedn se o*uivatelsk* vod do Festivalu, znalost
uivatelsk prce sFestivalem je pedpokldna.

Konkrtn postupy pouit pro etinu jsou popsny ve zdrojovm kdu
festival-czech (technick informace) a vsouboru README.Czech.cs (jazykov
informace).


* Zkladn principy Festivalu

Festival je systm modulrn a cel proces se skld zproveden libovoln
sekvence modul.  Kad modul m svj el a pro nkter sti zpracovn si
lze vybrat zvce alternativnch modul.  Lze t pout libovoln moduly
vlastn.

Moduly se obvykle pou ve schemovm programovacm jazyce Festivalu zvanm
SIOD.  Tento jazyk je popsn vmanulu Festivalu.


* Fze zpracovn

Zpracovn textu se standardn skld znsledujcch fz, definovanch
vsynthesis.scm:

(defUttType Text
  (Initialize utt)
  (Text utt)
  (Token_POS utt)
  (Token utt)
  (POS utt)
  (Phrasify utt)
  (Word utt)
  (Pauses utt)
  (Intonation utt)
  (PostLex utt)
  (Duration utt)
  (Int_Targets utt)
  (Wave_Synth utt)
  )

Ve se to okolo tzv. utterance, kter pedstavuje jakousi jednotku, vce i
mn anotovanou, kterou lze postupnm doplovnm anotac (*features*) dostat
a do stavu, kdy je schopna odesln na zvukov vstup.  Kad zve uvedench
fz je voln funkce na utterance `utt'.


* Prce sutterance

Potebujete-li provst syntzu uritho textu, vytvote si pslun utterance
napklad nsledujcm zpsobem:

  (Utterance Text "njak text")

Funkce vrt nezpracovan utterance, kter lze nechat pln zanalyzovat volnm
funkce `utt.synth'.  Pozor, ve festivalovm dkovm rozhran nelze zadvat
8-bitov znaky, vppad poteby je nutno syntzu provst pes soubor.

Utterance se skld ztzv. relac, jejich jmna lze zjistit pomoc

  (utt.relationnames utterance)

Obsah (seznam poloek, items) dan relace se vythne pomoc

  (utt.relation.items utterance 'relation-name)

Mnoh poloky se vyskytuj ve vce relacch.  Relace m obecn podobu stromu a
prostednictvm poloek mohou bt tyto stromy vzjemn provzny.  Relace
poloky lze zjistit pomoc

  (item.relations item)

Zkladnmi vlastnostmi poloky jsou jej jmno a rysy:

  (item.name item)

Rysy poloky lze zjistit pomoc

  (item.features item)

Lze si vyzkouet:

  (mapcar item.features (utt.relation.items utterance 'Word))

Pro vypsn relace je pehlednj vstup z

  (utt.relation.print utterance 'Word)

Lze t pout

  (utt.relation_tree utt 'SylStructure)

Funkce utt.relation_tree vrac kompletnj informaci odan relaci, obsahuje
cel strom dat obsaench vrelaci, zatmco utt.relation.print vypisuje pouze
prvky nejvy rovn.

Obas narme na pojem globlnho parametru.  Hodnotu globlnho parametru lze
zskat volnm

  (Param.get 'jmno-parametru)


* Strun popis fz zpracovn

** Initialize

Jen vytvo przdn utterance.

** Text

Provede rozdlen textu na tokeny.  Funkce `Text' je napsna vC++, vyuv
vak promnn `token.*' definovan vtoken.scm.

Definovan interpunkn znamnka jsou oddlena od vslednch token a jsou
dostupn jako jejich features.

** Token_POS

Provd, je-li teba, kontextov oznakovn tokenu pro rozlien rznho
vznamu shodnch token.  Tato fze slou pro uren sprvn vslovnosti slov
ve fzi bezprostedn nsledujc, pozdj fze POS m el jin.

** Token

Pevd tokeny na slova.  Pevod lze provst definic funkce token_to_words.
Pi konverzi tokenu je mono se podvat na okoln tokeny (nebo lpe vyuvat
kontextovch informac zskanch ve fzi Token_POS), take je mono provdt
isofistikovanj operace ne pouh mapovn jedinho tokenu na jedno nebo
vce slov.

** POS (POS == Part of Speech)

Provd tagovn konkrtnch slov dle jejich pozice vei.  Nepovinn st.
Parametrizovateln pomoc nkolika promnnch.  Tato fze, na rozdl od fze
Token_POS, uruje vznam jednotlivch slov ji nikoliv pro uren vslovnosti
slov, nbr pro uren jejich role ve vztahu knslednmu uren prozodie,
tj. pauz, dlek, pzvuku a intonace.

** Phrasify

Identifikace pauz (dn, normln, dlouh) mezi slovy.  Mezi vtinu slov se
nevkld dn pauza, vkld se za interpunkci, nkdy krtk (po rce), nkdy
dlouh (konec vty).  Tato funkce sama osob pauzy nevkld, to se dje a na
zklad j generovanch informac vPauses.

** Word

Provd pevod slov na fonmy a slabiky vimplicitnm festivalovm formtu.
Definovno vlexicon.scm, nen-li globlnm parametrem Word_Method eeno
jinak, vol se C++ funkce Classic_Word.

Cel process je pomrn podrobn popsn vdokumentaci, sekce Lexicons.

** Pauses

Vkld pauzy.  Pro tuto akci se pouv funkce definovan globlnm parametrem
Pause_Method.  Implicitn je funkce Classic_Pauses, definovan vpauses.scm.
Funkce dl vzsad to, e vlo poten pauzu a pak vlo pauzy dle
informac vytvoench ve fzi Phrasify.  Navc vyad zutterance slova
oznaen jako interpunkce.

Vkldn vodn pauzy lze odruit pedefinovnm funkce insert_initial_space,
nemlo by se to vak dt vjinch ne odvodnnch ppadech, jinak tm utrp
vsledn kvalita syntzy.

** Intonation

Generuje akcenty pro intonaci (prvn fze zpracovn intonace), ale nevytv
jet intonaci samotnou (druh fze zpracovn intonace), to dl a
Int_Targets.  Pouv se funkce definovan globlnm parametrem Int_Method.

** PostLex

Vtto fzi lze aplikovat jakkoliv dodaten transformace nad utterance,
zaazen vseznamu postlex_rules_hooks.

** Duration

Ur dlky trvn jednotlivch segment (fonm) syntetizovanho textu.

** Int_Targets

Ur parametry intonan kivky, obvykle po slabikch.

** Wave_Synth

Samotn sestaven zvuku na zklad ji vech dostupnch anotac.  Funkce, kter
se pro syntzu zavol, je definovna globlnm parametrem `Synth_Method'.
Kostra funkce Wave_Synth je napsna ve Scheme a nachz se vsynthesis.scm.


* Praktick poznmky.

Docstringy um vypsat funkce `doc'.

Readline um doplovat jmna funkc, co je asto uiten.


-- Milan Zamazal
