/*
 *
 * Copyright (C) 2000, 2001 Marcus Metzler 
 *            for convergence integrated media GmbH
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 * 

 * The author can be reached at marcus@convergence.de, 

 * the project's page is at http://linuxtv.org/dvb/
 */

#include <netinet/in.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdint.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include <ost/dmx.h>
#include <ost/frontend.h>
#include <ost/sec.h>
#include <ost/video.h>
#include <ost/audio.h>
#include <sys/poll.h>
#ifdef HAVE_LIBA52
#include <a52dec/a52.h>
#endif

#ifdef HAVE_LIBMAD
#include <mad.h>
#endif
#ifdef PTHREADS
#include <pthread.h>
#endif

#ifndef _DVB_FORMATS_H_
#define _DVB_FORMATS_H_


#define BUFFY 32768
#define NFD  2
#define PID_MASK_HI    0x1F
#define MAX_SECTION_SIZE 4096
#define NFD2   1
#define BUFFY2 1024*1024
#define IN_SIZE TS_SIZE*10

#define VIDEO_MODE_PAL		0
#define VIDEO_MODE_NTSC		1


#define PROG_STREAM_MAP  0xBC
#ifndef PRIVATE_STREAM1
#define PRIVATE_STREAM1  0xBD
#endif
#define PADDING_STREAM   0xBE
#ifndef PRIVATE_STREAM2
#define PRIVATE_STREAM2  0xBF
#endif
#define AUDIO_STREAM_S   0xC0
#define AUDIO_STREAM_E   0xDF
#define VIDEO_STREAM_S   0xE0
#define VIDEO_STREAM_E   0xEF
#define ECM_STREAM       0xF0
#define EMM_STREAM       0xF1
#define DSM_CC_STREAM    0xF2
#define ISO13522_STREAM  0xF3
#define PROG_STREAM_DIR  0xFF

#define BUFFYSIZE    10*MAX_PLENGTH
//#define MAX_PTS      8192
#define MAX_FRAME    8192
#define MAX_PACK_L   4096
#define PS_HEADER_L1    14
#define PS_HEADER_L2    (PS_HEADER_L1+18)
#define MAX_H_SIZE   (PES_H_MIN + PS_HEADER_L1 + 5)
#define PES_MIN         7
#define PES_H_MIN       9

//flags2
#define PTS_DTS_FLAGS    0xC0
#define ESCR_FLAG        0x20
#define ES_RATE_FLAG     0x10
#define DSM_TRICK_FLAG   0x08
#define ADD_CPY_FLAG     0x04
#define PES_CRC_FLAG     0x02
#define PES_EXT_FLAG     0x01

//pts_dts flags 
#define PTS_ONLY         0x80
#define PTS_DTS          0xC0

#define TS_SIZE        188
#define TRANS_ERROR    0x80
#define PAY_START      0x40
#define TRANS_PRIO     0x20
#define PID_MASK_HI    0x1F
//flags
#define TRANS_SCRMBL1  0x80
#define TRANS_SCRMBL2  0x40
#define ADAPT_FIELD    0x20
#define PAYLOAD        0x10
#define COUNT_MASK     0x0F

// adaptation flags
#define DISCON_IND     0x80
#define RAND_ACC_IND   0x40
#define ES_PRI_IND     0x20
#define PCR_FLAG       0x10
#define OPCR_FLAG      0x08
#define SPLICE_FLAG    0x04
#define TRANS_PRIV     0x02
#define ADAP_EXT_FLAG  0x01

// adaptation extension flags
#define LTW_FLAG       0x80
#define PIECE_RATE     0x40
#define SEAM_SPLICE    0x20


#define MAX_PLENGTH 0xFFFF
#define MMAX_PLENGTH (8*MAX_PLENGTH)

enum{ C_NOPES, C_MPEG, C_TS};

#ifdef __cplusplus
extern "C" {
#endif                          /* __cplusplus */
        
	typedef struct av_settings_s{
		int volume;
		int a52_track;
		int mpx_track;
		int aud_ext;
		
#ifdef HAVE_LIBA52
		sample_t *my_samples;
		int soft_ac3;
#endif
#ifdef HAVE_LIBMAD
		int soft_mpx;
#endif

		int needs_demux;
		int nopat;
	} av_settings;
	
	typedef struct p2pstruct {
		int found;
		uint8_t *buf;
		uint8_t *buf2;
		uint8_t cid;
		uint32_t plength;
		uint8_t plen[2];
		uint8_t flag1;
		uint8_t flag2;
		uint8_t hlength;
		uint8_t pts[5];
		int mpeg;
		uint8_t check;
		int which;
		int done;
		int repack;
		uint16_t bigend_repack;
		void (*func)(uint8_t *buf, int count, void *data);
		uint16_t pid;
		uint16_t pida;
		uint16_t pidv;
		uint8_t acounter;
		uint8_t vcounter;
		uint8_t count0;
		uint8_t count1;
		void * data;
		int fd;
		int fd1;
	} p2p;

        typedef struct ps_packet_{
                uint8_t scr[6];
                uint8_t mux_rate[3];
                uint8_t stuff_length;
                uint8_t *data;
                uint8_t sheader_llength[2];
                int sheader_length;
                uint8_t rate_bound[3];
                uint8_t audio_bound;
                uint8_t video_bound;
                uint8_t reserved;
                int npes;
                int mpeg;
        } ps_packet;

	typedef struct video_i{
                uint32_t horizontal_size;
                uint32_t vertical_size       ;
                uint32_t aspect_ratio        ;
                double framerate        ;
                uint32_t video_format;
                uint32_t bit_rate    ;
                uint32_t comp_bit_rate       ;
                uint32_t vbv_buffer_size;
                uint32_t CSPF                ;
                uint32_t off;
        } VideoInfo;            

        typedef struct audio_i{
                int layer;
                uint32_t bit_rate;
                uint32_t frequency;
                uint32_t mode;
                uint32_t mode_extension;
                uint32_t emphasis;
                uint32_t framesize;
                uint32_t off;
        } AudioInfo;

	typedef struct ipack_s {
		av_settings *av;
		int size;
		int size_orig;
		int found;
		int has_ai;
		int has_vi;
		VideoInfo vi;
		AudioInfo ai;
		int start;
		uint8_t *buf;
		uint8_t cid;
		uint32_t plength;
		uint8_t plen[2];
		uint8_t flag1;
		uint8_t flag2;
		uint8_t hlength;
		uint8_t pts[5];
                uint8_t last_pts[5];
		uint16_t pid;
		int fd;
		int fd1;
		int fd2;
		int ffd;
		int mpeg;
		uint8_t check;
		int which;
		int done;
		void *data;
		void (*func)(uint8_t *buf,  int size, void *priv);
		int count;
		int playing;
		int ps;
	} ipack;


	ssize_t poll_write(int fd, uint8_t *buf, int count);
	int pcm_play( int fd, uint8_t *samples, int sample_rate, 
		      uint8_t *pts, int len);

	void init_p2p(p2p *p, void (*func)(uint8_t *buf, int count, 
					   void *data),int repack);
	void get_pes (uint8_t *buf, int count, p2p *p, void (*func)(p2p *p));
	void pes_repack(p2p *p);
	void setup_pes2ts( p2p *p, uint16_t pida, uint16_t pidv, 
			   void (*ts_write)(uint8_t *buf, int count, 
					    void *data),void *data);
	void pes_to_ts( p2p *p,uint8_t *buf ,int count );
	void setup_ts2pes( ipack *pa, ipack *pv, uint16_t pida, uint16_t pidv, 
			   void (*pes_write)(uint8_t *buf, int count, 
					     void *data), void *data);

	void ts_to_pes( ipack *p, uint8_t *buf);
	uint16_t get_pid(uint8_t *pid);
	void free_p2p(p2p *p);
	uint16_t get_pid(uint8_t *pid);	


	int videoStop(int fd);
	int videoPlay(int fd);
	int videoClear(int fd);
	int videoFreeze(int fd);
	int videoContinue(int fd);
	int videoSelectSource(int fd, videoStreamSource_t source);
	int videoSetBlank(int fd, boolean state);
	int videoFastForward(int fd,int nframes);
	int videoSlowMotion(int fd,int nframes);
	int videoGetStatus(int fd);
	int videoStillPicture(int fd, struct videoDisplayStillPicture *sp);
	int videoSetStreamtype(int fd, char *format);
	unsigned int videoCapabilities(int fd);
	int audioSetStreamtype(int fd, char *format);
	unsigned int audioCapabilities(int fd);
	int audioStop(int fd);
	int audioPlay(int fd);
	int audioClear(int fd);
	int audioPause(int fd);
	int audioContinue(int fd);
	int audioSelectSource(int fd, audioStreamSource_t source);
	int audioSetMute(int fd, boolean state);
	int audioSetAVSync(int fd,boolean state);
	int audioSetBypassMode(int fd,boolean mode);
	int audioChannelSelect(int fd, audioChannelSelect_t select);
	int audioGetStatus(int fd);
	int audioSetID(int fd,int id);
	int audioSetExtID(int fd,int id);
	void play_file_audio(int filefd, int fd);
	void load_iframe(int filefd, int fd);
	int open_av(int *fdv,int *fda, int dev, int init);
	void set_pat_filt(int fd);
	void set_pmt_filt(int fd,uint16_t ppid);
	void set_av_filts(int vfd,int afd,uint16_t vpid,uint16_t apid);
	void stop_av_filts(int afd,int vfd);
	uint16_t get_pmt_pid(int fd);
	void get_av_pids(int fd, uint16_t *vpid, uint16_t *apid);
	void init_ipack(ipack *p, int size,
			void (*func)(uint8_t *buf,  int size, void *priv), 
			int ps);
	void send_ipack(ipack *p);
	void instant_repack (uint8_t *buf, int count, ipack *p);
	void reset_ipack(ipack *p);
	int64_t next_gop(int fd, int mb);
	int64_t prev_gop(int fd, int mb);
	int64_t next_gop_ts(int fd, int mb);
	int64_t prev_gop_ts(int fd, int mb);
	
	int new_get_av_pids(int fd, uint16_t *vpid, 
			    uint16_t *apids, int maxapids);

#ifdef HAVE_LIBA52
	void ps_loop (int fd, uint8_t *inbuf, int len, sample_t *my_samples, 
		      int a52_track);
	void init_a52_buf();
#endif

#ifdef HAVE_LIBMAD
	void init_mad();
	void mad_decode(int fd, uint8_t *buf, int buf_size);
	void close_mad();
#endif


	void find_avpids(int fd, uint16_t *vpid, uint16_t *apid);
	void find_bavpids(uint8_t *buf, int count, uint16_t *vpid, 
			  uint16_t *apid);
	void init_av(av_settings *av);


	void set_volume(int fda, int vol, av_settings *av);
	void mute(int fda, int on, av_settings *av);

	typedef struct switch_s{
		int fdv;
		int fda;
		int filefd;
		int ts;
		av_settings *av;
		uint64_t *stop;
	} switch_t;


	int av_switches(int cc, switch_t *sw, uint64_t *l);
	void write_out_demux(uint8_t *buf, int count, void *priv);
	ssize_t write_demux(int fd, uint8_t *buf, int count, av_settings *av,
			    ssize_t (*w)(int fd, uint8_t *buf, int count));
	void play_file_video_mpg(switch_t *sw);
	void play_file_dvr_ts(int fd_dvr, uint16_t apid, uint16_t vpid, 
			      int dev, switch_t *sw);
	void play_ts_video_n(switch_t *sw, uint16_t pida, uint16_t pidv);
	int check_file_ts(char *filename);
	int check_fd_ts(int fd);

#ifdef PTHREADS
	typedef
	struct dvr_info_s{
		int filefd;
		int dev;
		uint64_t stop;
		uint64_t length;
		int fda;
		int fdv;
		int fd_dvr;
		int type;
		uint16_t pida;
		uint16_t pidv;
	} dvr_info_t;

	void record_dvr(void *din);
	int c_dvr_thread_play(pthread_t *thread1,  dvr_info_t *dinfo);
	int c_dvr_thread_record(pthread_t *thread1,  dvr_info_t *dinfo);

#endif
#ifdef __cplusplus
}
#endif                          /* __cplusplus */


#endif /* _DVB_FORMATS_H_*/
