/* 
   audio.cc 

    Copyright (C) 2000 Marcus Metzler (mocm@metzlerbros.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "audio.hh"
#include "common.hh"
#include "interface.hh"

#include <DVB.hh>


static GtkWidget *audiomenu;
extern GtkAccelGroup *accel_group;
extern DVB dvb;

void set_audio(GtkWidget * w, gpointer data)
{
	int apid = (int)data;
        dvb.set_apid(apid);  
}

void CreateAudioMenu(GtkWidget * menu, char *szName)
{
	audiomenu = gtk_menu_item_new_with_label(szName);

	gtk_menu_bar_append(GTK_MENU_BAR(menu), audiomenu);
	gtk_widget_show(audiomenu);
	gtk_widget_set_sensitive(audiomenu, FALSE);

}



void set_audio_menu(Channel * chan)
{
	GtkWidget *menuitem;
	GtkWidget *menu;

	gtk_menu_item_remove_submenu(GTK_MENU_ITEM(audiomenu));
	menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(audiomenu), menu);


	if (chan && chan->apidnum > 1) {
		gtk_widget_set_sensitive(audiomenu, TRUE);

		for (int i = 0; i < chan->apidnum; i++) {
			char name[14];
			char aname[4];
			ostrstream str(name, 10);
			memcpy(aname, chan->apids_name +(i*4),4);
			aname[3] = 0;
			str << "Audio " << i ;
			if (aname[0]) str << " " << aname  ;
			str << ends;

			menuitem = CreateMenuItem(menu, name, "", name,
						  GTK_SIGNAL_FUNC
						  (set_audio), 
						  (void *) chan->apids[i],
						  accel_group);
		}
	} else {
		gtk_widget_set_sensitive(audiomenu, FALSE);
	}
}


#include <stream.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/errno.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/soundcard.h>

int mixer_device;
int devmask,recmask,recsrc,stereodevs,caps;

char *device_labels[] = SOUND_DEVICE_LABELS;
char *device_names[] = SOUND_DEVICE_NAMES;

int locked_channels, muted_channels;

lr_vol volume_list[SOUND_MIXER_NRDEVICES];
lr_vol m;

void sound_init ()
{
  
  mixer_device=open("/dev/mixer", O_RDWR, 0);
  
  if (mixer_device<0) {
    cerr << "unable to open mixer !" << endl;
  } else {
    /* get mixer information */
    if (	(
		 ioctl(mixer_device, SOUND_MIXER_READ_RECSRC, &recsrc) |
		 ioctl(mixer_device, SOUND_MIXER_READ_RECMASK, &recmask) |
		 ioctl(mixer_device, SOUND_MIXER_READ_STEREODEVS, &stereodevs)|
		 ioctl(mixer_device, SOUND_MIXER_READ_DEVMASK, &devmask) |
		 ioctl(mixer_device, SOUND_MIXER_READ_CAPS, &caps)
		 )<0) {
      cerr << "Can't initialize sound mixer !" << endl;
    } else {
      cerr << "Sound mixer initialized !" << endl;
      for (int i=0;i<SOUND_MIXER_NRDEVICES;i++) {
	if (devmask & (1<<i)) {
	  /* read current volume */
	  ioctl(mixer_device, MIXER_READ(i), &(volume_list[i]));
	}
	close(mixer_device);  
      }
    }
  } 
  

}
  
void set_master_vol(int l, int r=-1){
  
  if (devmask & 1) {
    mixer_device=open("/dev/mixer", O_RDWR, 0);
    volume_list[0].l=l;
    if (r<0) volume_list[0].r=l;
    else volume_list[0].r=r;
     
    ioctl(mixer_device, MIXER_WRITE(0), &(volume_list[0]));
    close(mixer_device);
  }
}

void get_master_vol(int &l, int lr=AU_LEFT){
  
  if (devmask & 1) {
    if (lr==AU_LEFT) l=volume_list[0].l;
    else l=volume_list[0].r;
  } else {
    if (lr==AU_LEFT) l=0;
    else l=0;    
  }
  
}




