/*-
 * Copyright (c) 2004 Free (Olivier Beyssac)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#ifndef _NETLIST_H
#define _NETLIST_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> /* in_addr_t */


#define ACL_M_QUERY  (1)
#define ACL_M_SUBMIT (2)
#define ACL_M_INSERT (4)
#define ACL_M_DECR   (8)
#define ACL_M_ALL    (ACL_M_QUERY | ACL_M_SUBMIT | ACL_M_INSERT | ACL_M_DECR)


typedef struct netlist *netlist;


/* Return a newly allocated netlist */
extern netlist netlist_init(void);


/* Free a netlist */
extern void netlist_free(netlist nl);


/* Load ACL from file. Return 1 on success, 0 if file was not found, -1
   for all other errors */ 
extern int netlist_acl_getfromfile(const netlist nl, const char *filename);


/* Load whitelist from file. Return 1 on success, 0 if file was not found, -1
   for all other errors */ 
extern int netlist_whitelist_getfromfile(const netlist nl,
					 const char *filename);


/* Return allowed actions for IP
   If list is an ACL: bitmask between none (0) and ACL_M_* above
   If list is a whitelist:  whitelisted (1)
 */
extern int netlist_getmode(const netlist nl, const in_addr_t ip);


#endif /* _NETLIST_H */
