/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */

#include "CardInformation.h"

CardInformation::CardInformation()
	: m_pCard(NULL)
	, m_cardReader("")
{
	Reset();
}

CardInformation::~CardInformation()
{
}

void CardInformation::Reset()
{
	m_CardInfo.Reset();
	m_PersonInfo.Reset();
	m_MiscInfo.Reset();
	m_pCard = NULL;
	m_cardReader = "";
}

bool CardInformation::LoadData(BEID_MemoryCard& Card, QString const& cardReader)
{
	bool bRetVal = false;

	Reset();

	switch(Card.getType())
	{
	case BEID_CARDTYPE_SIS:
		bRetVal = RetrieveData(dynamic_cast<BEID_SISCard&>(Card));
		m_cardReader = cardReader;
		break;
	default:
		break;
	}

	return bRetVal;
}

bool CardInformation::LoadData(BEID_EIDCard& Card, QString const& cardReader)
{
	bool bRetVal = false;

	Reset();

	switch(Card.getType())
	{
	case BEID_CARDTYPE_KIDS:
	case BEID_CARDTYPE_FOREIGNER:
	case BEID_CARDTYPE_EID:
		bRetVal |= RetrieveData(Card);
		m_cardReader = cardReader;
		bRetVal = true;
		break;
	default:
		break;

	}
	return bRetVal;
}



