/* ****************************************************************************

 * eID Middleware Project.
 * Copyright (C) 2008-2009 FedICT.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.

**************************************************************************** */
#pragma once

#ifndef __CARDBEIDDEF_H__
#define __CARDBEIDDEF_H__

namespace eIDMW
{

#define BEID_FILE_ID					"3F00DF014031"
#define BEID_FILE_ID_SIGN				"3F00DF014032"
#define BEID_FILE_ADDRESS				"3F00DF014033"
#define BEID_FILE_ADDRESS_SIGN			"3F00DF014034"
#define BEID_FILE_PHOTO					"3F00DF014035"
#define BEID_FILE_TOKENINFO				"3F00DF005032"
#define BEID_FILE_RRN					"3F00DF00503C"
#define BEID_FILE_RRNCA					"3F00DF00503D"

#define BEID_FILE_CERT_AUTHENTICATION	"3F00DF005038"
#define BEID_FILE_CERT_SIGNATURE		"3F00DF005039"
#define BEID_FILE_CERT_CA				"3F00DF00503A"
#define BEID_FILE_CERT_ROOT				"3F00DF00503B"

#define BEID_FILE_CERTS					"CERTS"					//pseudo file
#define BEID_FILE_CERTS_P15				"CERTS_P15"				//pseudo file
#define BEID_FILE_CERTS_COUNT			"CERTS_COUNT"			//pseudo file
#define BEID_FILE_PINS_P15				"PINS_P15"				//pseudo file
#define BEID_FILE_PINS_COUNT			"PINS_COUNT"			//pseudo file
#define BEID_FILE_CARDINFO				"CARDINFO"				//pseudo file
#define BEID_FILE_CHALLENGE				"CHALLENGE"				//pseudo file
#define BEID_FILE_CHALLENGE_RESPONSE	"CHALLENGE_RESPONSE"	//pseudo file

#define BEID_CARDTYPE_KIDS_CODE				6
#define BEID_CARDTYPE_FOREIGNER_CODE_MIN	11
#define BEID_CARDTYPE_FOREIGNER_CODE_MAX	18

#define BEID_FIELD_TAG_ID_Version				0x00
#define BEID_FIELD_TAG_ID_CardNr				0x01
#define BEID_FIELD_TAG_ID_ChipNr				0x02
#define BEID_FIELD_TAG_ID_ValidityBeginDate		0x03
#define BEID_FIELD_TAG_ID_ValidityEndDate		0x04
#define BEID_FIELD_TAG_ID_IssuingMunicipality	0x05
#define BEID_FIELD_TAG_ID_NationalNr			0x06
#define BEID_FIELD_TAG_ID_Surname				0x07
#define BEID_FIELD_TAG_ID_FirstName_1			0x08
#define BEID_FIELD_TAG_ID_FirstName_2			0x09
#define BEID_FIELD_TAG_ID_Nationality			0x0A
#define BEID_FIELD_TAG_ID_LocationOfBirth		0x0B
#define BEID_FIELD_TAG_ID_DateOfBirth			0x0C
#define BEID_FIELD_TAG_ID_Gender				0x0D
#define BEID_FIELD_TAG_ID_Nobility				0x0E
#define BEID_FIELD_TAG_ID_DocumentType			0x0F
#define BEID_FIELD_TAG_ID_SpecialStatus			0x10
#define BEID_FIELD_TAG_ID_PhotoHash				0x11
#define BEID_FIELD_TAG_ID_Duplicata				0x12
#define BEID_FIELD_TAG_ID_SpecialOrganization	0x13
#define BEID_FIELD_TAG_ID_MemberOfFamily		0x14

#define BEID_FIELD_TAG_ADDR_Version				0x00
#define BEID_FIELD_TAG_ADDR_Street				0x01
#define BEID_FIELD_TAG_ADDR_ZipCode             0x02
#define BEID_FIELD_TAG_ADDR_Municipality        0x03

#define BEID_FIELD_BYTE_TOKENINFO_GraphicalPersonalisation             37
#define BEID_FIELD_BYTE_TOKENINFO_ElectricalPersonalisation            38
#define BEID_FIELD_BYTE_TOKENINFO_ElectricalPersonalisationInterface   39

#define CARDTYPE_NAME_BEID_EID					"eid"
#define CARDTYPE_NAME_BEID_KIDS					"kids"
#define CARDTYPE_NAME_BEID_FOREIGNER			"foreigner"

#define BEID_TLV_TAG_VERSION						0x00
#define BEID_TLV_TAG_FILE_ID						0x01
#define BEID_TLV_TAG_FILE_IDSIGN					0x02
#define BEID_TLV_TAG_FILE_ADDR						0x03
#define BEID_TLV_TAG_FILE_ADDRSIGN					0x04
#define BEID_TLV_TAG_FILE_PHOTO						0x05
#define BEID_TLV_TAG_FILE_CARDINFO					0x06
#define BEID_TLV_TAG_FILE_TOKENINFO					0x07
#define BEID_TLV_TAG_FILE_RRN						0x08
#define BEID_TLV_TAG_FILE_CHALLENGE					0x09
#define BEID_TLV_TAG_FILE_CHALLENGE_RESPONSE		0x0A
#define BEID_TLV_TAG_CARDTYPE						0x0B
#define BEID_TLV_TAG_FILE_CERTS						0x0C
#define BEID_TLV_TAG_FILE_PINS						0x0D

#define BEID_CSV_TAG_VERSION						0
#define BEID_CSV_TAG_CARDTYPE						1
#define BEID_CSV_TAG_FILE_ID						26
#define BEID_CSV_TAG_FILE_IDSIGN					27
#define BEID_CSV_TAG_FILE_ADDR						28
#define BEID_CSV_TAG_FILE_ADDRSIGN					29
#define BEID_CSV_TAG_FILE_PHOTO						30
#define BEID_CSV_TAG_FILE_CARDINFO					47
#define BEID_CSV_TAG_FILE_TOKENINFO					48
#define BEID_CSV_TAG_FILE_CHALLENGE					49
#define BEID_CSV_TAG_FILE_CHALLENGE_RESPONSE		50
#define BEID_CSV_TAG_FILE_RRN						53
#define BEID_CSV_TAG_FILE_CERTS_COUNT				55
#define BEID_CSV_TAG_FILE_CERTS_FIRST				58
#define BEID_CSV_TAG_FILE_CERTS_P15_FIRST			59
#define BEID_CSV_TAG_FILE_CERTS_STEP				4
#define BEID_CSV_TAG_FILE_PINS_STEP					7

#define BEID_XML_PATH_FILE_ID					"/beid_card/biographic/files/file_id"
#define BEID_XML_PATH_FILE_IDSIGN				"/beid_card/biographic/files/file_id_sign"
#define BEID_XML_PATH_FILE_ADDR					"/beid_card/biographic/files/file_address"
#define BEID_XML_PATH_FILE_ADDRSIGN				"/beid_card/biographic/files/file_address_sign"
#define BEID_XML_PATH_FILE_PHOTO				"/beid_card/biometric/picture/data"
#define BEID_XML_PATH_FILE_CARDINFO				"/beid_card/scard/files/file_datainfo"
#define BEID_XML_PATH_FILE_TOKENINFO			"/beid_card/scard/files/file_tokeninfo"
#define BEID_XML_PATH_FILE_RRN					"/beid_card/cryptographic/rrn/certificate/data"
#define BEID_XML_PATH_FILE_CHALLENGE			"/beid_card/challenge_response/challenge"
#define BEID_XML_PATH_FILE_CHALLENGE_RESPONSE	"/beid_card/challenge_response/response"
#define BEID_XML_PATH_FILE_CERTS				"/beid_card/cryptographic/certificates/certificate/data"
#define BEID_XML_PATH_FILE_CERTS_P15			"/beid_card/cryptographic/certificates/certificate/p15_struct"
#define BEID_XML_PATH_FILE_PINS_P15				"/beid_card/cryptographic/pins/pin/p15_struct"

/* RRN OID */
static const char *const _beid_rrn_oid[] = 
{
	"2.16.56.1.1.1.3.1",  // From the old middleware code
	"2.16.56.1.1.1.4",    // Current OID
	"2.16.56.9.1.1.4",    // New OID (new root)
	NULL
};

#define BEID_DN_RRN      "RRNRRNBE"  // CN + O + C

/* Root Certificates */
static const unsigned char _beid_root_cert1[] = 
{
        0X30,0x82,0x03,0x94,0x30,0x82,0x02,0x7C,0xA0,0x03,0x02,0x01,0x02,0x02,0x10,0x58,
		0x0B,0x05,0x6C,0x53,0x24,0xDB,0xB2,0x50,0x57,0x18,0x5F,0xF9,0xE5,0xA6,0x50,0x30,
		0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x27,
		0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,
		0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0F,0x42,0x65,0x6C,0x67,0x69,0x75,0x6D,0x20,
		0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,0x30,0x1E,0x17,0x0D,0x30,0x33,0x30,0x31,0x32,
		0x36,0x32,0x33,0x30,0x30,0x30,0x30,0x5A,0x17,0x0D,0x31,0x34,0x30,0x31,0x32,0x36,
		0x32,0x33,0x30,0x30,0x30,0x30,0x5A,0x30,0x27,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,
		0x04,0x06,0x13,0x02,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,
        0x0F,0x42,0x65,0x6C,0x67,0x69,0x75,0x6D,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,
		0x30,0x82,0x01,0x22,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
		0x01,0x05,0x00,0x03,0x82,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,
		0x00,0xC8,0xA1,0x71,0xE9,0x1C,0x46,0x42,0x79,0x78,0x71,0x6F,0x9D,0xAE,0xA9,0xA8,
		0xAB,0x28,0xB7,0x4D,0xC7,0x20,0xEB,0x30,0x91,0x5A,0x75,0xF5,0xE2,0xD2,0xCF,0xC8,
		0x4C,0x14,0x98,0x42,0x58,0xAD,0xC7,0x11,0xC5,0x40,0x40,0x6A,0x5A,0xF9,0x74,0x12,
		0x27,0x87,0xE9,0x9C,0xE5,0x71,0x4E,0x22,0x2C,0xD1,0x12,0x18,0xAA,0x30,0x5E,0xA2,

		0x21,0xB9,0xD9,0xBB,0xFF,0xF6,0x74,0xEB,0x31,0x01,0xE7,0x3B,0x7E,0x58,0x0F,0x91,
		0x16,0x4D,0x76,0x89,0xA8,0x01,0x4F,0xAD,0x22,0x66,0x70,0xFA,0x4B,0x1D,0x95,0xC1,
        0x30,0x58,0xEA,0xBC,0xD9,0x65,0xD8,0x9A,0xB4,0x88,0xEB,0x49,0x46,0x52,0xDF,0xD2,
		0x53,0x15,0x76,0xCB,0x14,0x5D,0x19,0x49,0xB1,0x6F,0x6A,0xD3,0xD3,0xFD,0xBC,0xC2,
		0x2D,0xEC,0x45,0x3F,0x09,0x3F,0x58,0xBE,0xFC,0xD4,0xEF,0x00,0x8C,0x81,0x35,0x72,
		0xBF,0xF7,0x18,0xEA,0x96,0x62,0x7D,0x2B,0x28,0x7F,0x15,0x6C,0x63,0xD2,0xCA,0xCA,
		0x7D,0x05,0xAC,0xC8,0x6D,0x07,0x6D,0x32,0xBE,0x68,0xB8,0x05,0x40,0xAE,0x54,0x98,
		0x56,0x3E,0x66,0xF1,0x30,0xE8,0xEF,0xC4,0xAB,0x93,0x5E,0x07,0xDE,0x32,0x8F,0x12,
		0x74,0xAA,0x5B,0x34,0x23,0x54,0xC0,0xEA,0x6C,0xCE,0xFE,0x36,0x92,0xA8,0x09,0x17,
		0xEA,0xA1,0x2D,0xCF,0x6C,0xE3,0x84,0x1D,0xDE,0x87,0x2E,0x33,0x0B,0x3C,0x74,0xE2,
		0x21,0x50,0x38,0x95,0x2E,0x5C,0xE0,0xE5,0xC6,0x31,0xF9,0xDB,0x40,0xFA,0x6A,0xA1,
		0xA4,0x8A,0x93,0x9B,0xA7,0x21,0x06,0x87,0x1D,0x27,0xD3,0xC4,0xA1,0xC9,0x4C,0xB0,
		0x6F,0x02,0x03,0x01,0x00,0x01,0xA3,0x81,0xBB,0x30,0x81,0xB8,0x30,0x0E,0x06,0x03,
		0x55,0x1D,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0F,0x06,0x03,
		0x55,0x1D,0x13,0x01,0x01,0xFF,0x04,0x05,0x30,0x03,0x01,0x01,0xFF,0x30,0x42,0x06,
		0x03,0x55,0x1D,0x20,0x04,0x3B,0x30,0x39,0x30,0x37,0x06,0x05,0x60,0x38,0x01,0x01,

		0x01,0x30,0x2E,0x30,0x2C,0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,
		0x20,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x72,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,
		0x72,0x79,0x2E,0x65,0x69,0x64,0x2E,0x62,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,
		0x65,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x10,0xF0,0x0C,0x56,
		0x9B,0x61,0xEA,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,0x14,0x8E,0xDB,0xE6,
		0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8,0x42,0x01,0x01,0x04,0x04,0x03,
		0x02,0x00,0x07,0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,
		0x10,0xF0,0x0C,0x56,0x9B,0x61,0xEA,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,
		0x14,0x8E,0xDB,0xE6,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
		0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0xC8,0x6D,0x22,0x51,0x8A,0x61,0xF8,0x0F,
		0x96,0x6E,0xD5,0x20,0xB2,0x81,0xF8,0xC6,0xDC,0xA3,0x16,0x00,0xDA,0xCD,0x6A,0xE7,
		0x6B,0x2A,0xFA,0x59,0x48,0xA7,0x4C,0x49,0x37,0xD7,0x73,0xA1,0x6A,0x01,0x65,0x5E,
		0x32,0xBD,0xE7,0x97,0xD3,0xD0,0x2E,0x3C,0x73,0xD3,0x8C,0x7B,0x83,0xEF,0xD6,0x42,
		0xC1,0x3F,0xA8,0xA9,0x5D,0x0F,0x37,0xBA,0x76,0xD2,0x40,0xBD,0xCC,0x2D,0x3F,0xD3,
		0x44,0x41,0x49,0x9C,0xFD,0x5B,0x29,0xF4,0x02,0x23,0x22,0x5B,0x71,0x1B,0xBF,0x58,
		0xD9,0x28,0x4E,0x2D,0x45,0xF4,0xDA,0xE7,0xB5,0x63,0x45,0x44,0x11,0x0D,0x2A,0x7F,

		0x33,0x7F,0x36,0x49,0xB4,0xCE,0x6E,0xA9,0x02,0x31,0xAE,0x5C,0xFD,0xC8,0x89,0xBF,
		0x42,0x7B,0xD7,0xF1,0x60,0xF2,0xD7,0x87,0xF6,0x57,0x2E,0x7A,0x7E,0x6A,0x13,0x80,
		0x1D,0xDC,0xE3,0xD0,0x63,0x1E,0x3D,0x71,0x31,0xB1,0x60,0xD4,0x9E,0x08,0xCA,0xAB,
		0xF0,0x94,0xC7,0x48,0x75,0x54,0x81,0xF3,0x1B,0xAD,0x77,0x9C,0xE8,0xB2,0x8F,0xDB,
		0x83,0xAC,0x8F,0x34,0x6B,0xE8,0xBF,0xC3,0xD9,0xF5,0x43,0xC3,0x64,0x55,0xEB,0x1A,
		0xBD,0x36,0x86,0x36,0xBA,0x21,0x8C,0x97,0x1A,0x21,0xD4,0xEA,0x2D,0x3B,0xAC,0xBA,
		0xEC,0xA7,0x1D,0xAB,0xBE,0xB9,0x4A,0x9B,0x35,0x2F,0x1C,0x5C,0x1D,0x51,0xA7,0x1F,
		0x54,0xED,0x12,0x97,0xFF,0xF2,0x6E,0x87,0x7D,0x46,0xC9,0x74,0xD6,0xEF,0xEB,0x3D,
		0x7D,0xE6,0x59,0x6E,0x06,0x94,0x04,0xE4,0xA2,0x55,0x87,0x38,0x28,0x6A,0x22,0x5E,
		0xE2,0xBE,0x74,0x12,0xB0,0x04,0x43,0x2A
};

static const unsigned char _beid_root_cert2[] = 
{
        0x30,0x82,0x03,0x8e,0x30,0x82,0x02,0x76,0xa0,0x03,0x02,0x01,0x02,0x02,0x08,0x2a,
        0xff,0xbe,0x9f,0xa2,0xf0,0xe9,0x87,0x30,0x0d,0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,
        0x0d,0x01,0x01,0x05,0x05,0x00,0x30,0x28,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,
        0x06,0x13,0x02,0x42,0x45,0x31,0x19,0x30,0x17,0x06,0x03,0x55,0x04,0x03,0x13,0x10,
        0x42,0x65,0x6c,0x67,0x69,0x75,0x6d,0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x32,
        0x30,0x1e,0x17,0x0d,0x30,0x37,0x31,0x30,0x30,0x34,0x31,0x30,0x30,0x30,0x30,0x30,
        0x5a,0x17,0x0d,0x32,0x31,0x31,0x32,0x31,0x35,0x30,0x38,0x30,0x30,0x30,0x30,0x5a,
        0x30,0x28,0x31,0x0b,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31,
        0x19,0x30,0x17,0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x42,0x65,0x6c,0x67,0x69,0x75,
        0x6d,0x20,0x52,0x6f,0x6f,0x74,0x20,0x43,0x41,0x32,0x30,0x82,0x01,0x22,0x30,0x0d,
        0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01,
        0x0f,0x00,0x30,0x82,0x01,0x0a,0x02,0x82,0x01,0x01,0x00,0xc6,0x73,0x42,0x1e,0x92,
        0xff,0x75,0x0f,0x8b,0xbf,0x74,0x86,0xa7,0x3f,0xed,0xb2,0x18,0x2d,0x2d,0x97,0xf9,
        0xa9,0xfb,0x98,0x4a,0x23,0xdf,0xd5,0x8d,0xe0,0x8c,0xc6,0x32,0x1c,0x16,0x2d,0x07,
        0x42,0xd6,0x2d,0xb6,0x6e,0x2f,0xa7,0xf5,0xfc,0xc6,0x85,0x82,0x5d,0x95,0xde,0xb5,
        0x22,0x00,0xcc,0xa8,0x53,0x40,0x9f,0xaf,0x0a,0x35,0xa2,0x7a,0xc7,0xe1,0xca,0xf7,

        0x60,0x10,0x67,0x0e,0xa7,0x50,0x73,0x17,0x53,0x95,0x9f,0x22,0x9f,0x0c,0x5d,0x6f,
        0xb6,0x41,0xbc,0x8c,0xeb,0xda,0x1d,0x46,0xbd,0xa7,0x94,0xbf,0xf3,0x1a,0xcb,0xd4,
        0xfb,0x8d,0x0e,0x1e,0x33,0xc8,0x96,0xd7,0xec,0x8c,0x53,0xde,0x93,0x1e,0x34,0x1e,
        0x8a,0x50,0x71,0x26,0x58,0xb4,0x5d,0xc2,0x88,0x89,0xda,0x60,0xd2,0x89,0x21,0x3f,
        0xde,0xd7,0x01,0x18,0x36,0x6e,0xe1,0x2c,0x70,0x03,0x04,0x65,0xef,0x98,0x06,0x2b,
        0x5d,0x1e,0x62,0xdc,0x55,0x6b,0xfe,0x66,0x64,0x21,0x5f,0xf8,0x2f,0xe1,0xd7,0x9b,
        0x29,0xaf,0x6f,0xcd,0x9f,0xaa,0x0c,0x46,0xd1,0x88,0xc5,0x9d,0xa2,0x95,0x9f,0xac,
        0x3f,0x15,0xae,0xf2,0x61,0xdf,0xef,0xc3,0x6b,0x9a,0x22,0xd8,0x2c,0x71,0xfd,0x58,
        0x1d,0xec,0x00,0xa4,0x38,0x20,0x95,0x5a,0xc7,0xd5,0x37,0x63,0xba,0x4f,0x9b,0xaa,
        0xfe,0x56,0x46,0x2e,0x63,0xd9,0x0b,0x23,0xd5,0x8a,0xfa,0xb5,0x23,0xf0,0x89,0x1b,
        0xa1,0x14,0x0d,0x26,0xda,0x41,0xf0,0x38,0x8f,0x30,0xed,0x05,0x26,0x79,0xc1,0x4b,
        0x4e,0xa1,0xb8,0x7e,0x55,0x52,0x3a,0x69,0x46,0x84,0x75,0x02,0x03,0x01,0x00,0x01,
        0xa3,0x81,0xbb,0x30,0x81,0xb8,0x30,0x0e,0x06,0x03,0x55,0x1d,0x0f,0x01,0x01,0xff,
        0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x0f,0x06,0x03,0x55,0x1d,0x13,0x01,0x01,0xff,
        0x04,0x05,0x30,0x03,0x01,0x01,0xff,0x30,0x42,0x06,0x03,0x55,0x1d,0x20,0x04,0x3b,
        0x30,0x39,0x30,0x37,0x06,0x05,0x60,0x38,0x09,0x01,0x01,0x30,0x2e,0x30,0x2c,0x06,

        0x08,0x2b,0x06,0x01,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3a,
        0x2f,0x2f,0x72,0x65,0x70,0x6f,0x73,0x69,0x74,0x6f,0x72,0x79,0x2e,0x65,0x69,0x64,
        0x2e,0x62,0x65,0x6c,0x67,0x69,0x75,0x6d,0x2e,0x62,0x65,0x30,0x1d,0x06,0x03,0x55,
        0x1d,0x0e,0x04,0x16,0x04,0x14,0x85,0x8a,0xeb,0xf4,0xc5,0xbb,0xbe,0x0e,0x59,0x03,
        0x94,0xde,0xd6,0x80,0x01,0x15,0xe3,0x10,0x9c,0x39,0x30,0x11,0x06,0x09,0x60,0x86,
        0x48,0x01,0x86,0xf8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1f,0x06,
        0x03,0x55,0x1d,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x85,0x8a,0xeb,0xf4,0xc5,0xbb,
        0xbe,0x0e,0x59,0x03,0x94,0xde,0xd6,0x80,0x01,0x15,0xe3,0x10,0x9c,0x39,0x30,0x0d,
        0x06,0x09,0x2a,0x86,0x48,0x86,0xf7,0x0d,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,
        0x01,0x00,0x51,0xd8,0x85,0xdd,0xbb,0x57,0x6f,0xcc,0xa0,0x6c,0xb5,0xa3,0x20,0x9c,
        0x53,0x09,0xf3,0x4a,0x01,0x0c,0x74,0xbf,0x2b,0xb3,0x9a,0x9a,0xba,0x18,0xf2,0x0b,
        0x88,0xac,0x1c,0xb3,0x33,0xaf,0xce,0xe5,0x13,0x01,0x27,0x92,0x84,0x58,0x9a,0x10,
        0xb9,0xf7,0xcc,0x14,0x92,0x6b,0x74,0x16,0x8a,0x96,0xe8,0x51,0xef,0xbf,0xfa,0x4a,
        0x25,0xa7,0x89,0xb6,0x63,0x2b,0x5d,0x94,0x58,0xd1,0xcf,0x11,0x72,0xb6,0x1e,0xb9,
        0x39,0x41,0x16,0x4d,0x29,0xbc,0x35,0x53,0x0b,0xda,0xde,0x8e,0x0e,0xcd,0xa9,0x95,
        0x77,0x25,0xca,0x94,0x5a,0xe9,0xb2,0x69,0xae,0xd8,0xc0,0x13,0xbe,0x98,0xfc,0x96,

        0x9c,0x84,0x7f,0x55,0x13,0xe6,0x3c,0x87,0xe3,0xbc,0x20,0xa4,0xa4,0x36,0x68,0x6b,
        0x4d,0x60,0x66,0x1c,0xf9,0xbf,0xac,0x80,0x94,0x66,0x2e,0xb9,0x41,0x8a,0xd3,0x65,
        0xd3,0x84,0x80,0x02,0xef,0x50,0x1d,0x5e,0x46,0xdc,0xf7,0xc9,0xba,0xb5,0x34,0x7c,
        0x2a,0xf3,0xc6,0xd8,0x5f,0x5f,0x54,0x9d,0xdb,0x4d,0xcd,0x11,0xe7,0xfd,0x14,0x02,
        0x83,0x66,0x5e,0xc8,0xa6,0x00,0x12,0xa0,0x5f,0xbe,0xce,0x14,0xfe,0xbb,0x1f,0xa7,
        0x61,0xf7,0xab,0x4a,0xf1,0x06,0x14,0x9f,0xca,0x49,0x42,0xc2,0xa9,0xbc,0xed,0x85,
        0xb1,0xab,0x81,0x41,0xe6,0x0d,0xc5,0x42,0x69,0x53,0x87,0x39,0x9d,0x4c,0x1f,0x00,
        0x0e,0x3e,0x07,0x0d,0x75,0x57,0x44,0xa8,0x53,0xb4,0x36,0x76,0x64,0x99,0xdc,0x6e,
        0xeb,0x3d,0x46,0x6e,0x14,0x5d,0x5e,0x47,0x53,0x8d,0x78,0x4d,0xe0,0x27,0xbb,0x8e,
        0x85,0x76
};

static const unsigned char *const _beid_root_certs[] = 
{
	_beid_root_cert1,
	_beid_root_cert2,
	NULL
};

static const unsigned long _beid_root_certs_size[] = 
{
	sizeof(_beid_root_cert1),
	sizeof(_beid_root_cert2)
};

static const unsigned char _beid_govca_cert2003[] = 
{
		 0x30,0x82,0x03,0xCF,0x30,0x82,0x02,0xB7,0xA0,0x03,0x02,0x01,0x02,0x02,0x11
		,0x00,0x99,0x6F,0x14,0x78,0x8E,0xEA,0x69,0x6A,0x3D,0x2E,0x93,0x42,0x81,0x2B
		,0x66,0xF0,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05
		,0x05,0x00,0x30,0x27,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02
		,0x42,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0F,0x42,0x65
		,0x6C,0x67,0x69,0x75,0x6D,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,0x30,0x1E
		,0x17,0x0D,0x30,0x33,0x30,0x31,0x32,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x5A
		,0x17,0x0D,0x30,0x39,0x30,0x31,0x32,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x5A
		,0x30,0x25,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45
		,0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0D,0x47,0x6F,0x76,0x65
		,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x20,0x43,0x41,0x30,0x82,0x01,0x22,0x30,0x0D
		,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x82
		,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,0x00,0xAC,0xC9,0xA0
		,0xAF,0xE4,0xC7,0x85,0x92,0xB4,0xF8,0xDC,0x9D,0x6B,0x36,0x84,0xF5,0xE1,0x04
		,0x55,0x4E,0x82,0x72,0x10,0xC4,0x72,0xC3,0x6F,0x2E,0x2E,0xB3,0xA8,0x46,0xCD
		,0x3C,0x5F,0xE1,0x60,0x75,0xBD,0x72,0xA8,0x3A,0x81,0x78,0x93,0x0A,0xAA,0x36
		,0x24,0x4F,0x1F,0x04,0xC8,0x67,0xA6,0x8A,0xE1,0x47,0xAA,0x09,0x8B,0x1F,0x08
		,0x5D,0x13,0x94,0xCD,0x21,0xF4,0x7F,0x18,0x85,0xBE,0x9D,0x01,0x73,0xDF,0x4B
		,0x8D,0x60,0xA4,0x54,0x50,0xF6,0x97,0x4E,0x15,0x14,0x3D,0x7E,0x55,0x8F,0x35
		,0x68,0x88,0x26,0xF5,0xB2,0x7C,0x0A,0xBE,0x70,0xA3,0x24,0x1C,0x6E,0x9C,0x43
		,0x0A,0xF0,0xD9,0xC6,0x2A,0x18,0x06,0x61,0x43,0x1D,0x77,0xAB,0x16,0xCB,0x81
		,0xB3,0xA0,0x3F,0x65,0x9A,0xAF,0x7A,0x3F,0x20,0xD1,0x93,0x5E,0x34,0x98,0xEE
		,0x06,0xAA,0x16,0x7A,0x5A,0x88,0x44,0x2C,0xE1,0x2C,0xB5,0xFE,0x4C,0x03,0x0F
		,0x3E,0xAB,0xDD,0x67,0x90,0x43,0x68,0x3D,0x1B,0x9B,0xC1,0x72,0x43,0x4F,0x89
		,0x53,0x59,0xC3,0x91,0xA8,0x62,0x37,0xE3,0x9D,0x00,0xA0,0x5A,0xC1,0xA5,0xBC
		,0xB2,0x29,0xA2,0x56,0x5D,0xBB,0x88,0xEC,0x75,0x73,0x84,0x1D,0x3B,0x40,0xF7
		,0x0A,0x04,0xA5,0x95,0x96,0x29,0x05,0xD2,0x82,0x44,0x4D,0x86,0xFF,0xC9,0x8B
		,0xC4,0x5F,0x8B,0x60,0x84,0xEC,0x74,0x4F,0xDA,0x40,0x88,0x88,0xBE,0x06,0x4C
		,0x60,0xC4,0xC2,0xCA,0x2F,0xF8,0x8D,0xE5,0x99,0x50,0xCF,0xEF,0xD6,0x4A,0xA5
		,0x93,0x68,0xAC,0x0A,0xD3,0x84,0x2B,0x1F,0x64,0x4C,0xC4,0x89,0x13,0x02,0x03
		,0x01,0x00,0x01,0xA3,0x81,0xF7,0x30,0x81,0xF4,0x30,0x0E,0x06,0x03,0x55,0x1D
		,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,0x03,0x55
		,0x1D,0x13,0x01,0x01,0xFF,0x04,0x08,0x30,0x06,0x01,0x01,0xFF,0x02,0x01,0x00
		,0x30,0x43,0x06,0x03,0x55,0x1D,0x20,0x04,0x3C,0x30,0x3A,0x30,0x38,0x06,0x06
		,0x60,0x38,0x01,0x01,0x01,0x03,0x30,0x2E,0x30,0x2C,0x06,0x08,0x2B,0x06,0x01
		,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x72
		,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,0x72,0x79,0x2E,0x65,0x69,0x64,0x2E,0x62
		,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,0x65,0x30,0x1D,0x06,0x03,0x55,0x1D
		,0x0E,0x04,0x16,0x04,0x14,0xF5,0xDB,0x02,0x17,0x19,0x1E,0xB0,0x9E,0x49,0x39
		,0x43,0xF4,0x48,0x33,0x99,0xDF,0xA2,0xD1,0x8B,0xD6,0x30,0x36,0x06,0x03,0x55
		,0x1D,0x1F,0x04,0x2F,0x30,0x2D,0x30,0x2B,0xA0,0x29,0xA0,0x27,0x86,0x25,0x68
		,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x63,0x72,0x6C,0x2E,0x65,0x69,0x64,0x2E,0x62
		,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,0x65,0x2F,0x62,0x65,0x6C,0x67,0x69
		,0x75,0x6D,0x2E,0x63,0x72,0x6C,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86
		,0xF8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1F,0x06,0x03,0x55
		,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xF0,0x0C,0x56,0x9B,0x61,0xEA
		,0x57,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,0x14,0x8E,0xDB,0xE6,0x30,0x0D
		,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x82
		,0x01,0x01,0x00,0xA0,0x53,0x21,0xBF,0x12,0x4C,0xD8,0x7F,0x05,0x59,0xB6,0x43
		,0xC5,0xEB,0xC0,0x39,0xF2,0xC4,0x64,0x11,0xE5,0xC4,0x3A,0x38,0xCE,0x54,0x46
		,0xD5,0x6A,0xF1,0xB0,0x20,0x48,0x6E,0xE8,0x95,0x22,0xD0,0x02,0xA7,0xDF,0x99
		,0xF5,0x45,0x96,0x52,0x79,0x6A,0x59,0x10,0x2D,0x91,0xBB,0xC0,0x42,0xF6,0xA7
		,0x98,0x31,0x9E,0x80,0x4C,0xA5,0x46,0x7D,0x90,0x51,0x8B,0x17,0x5D,0x7B,0x42
		,0x45,0xA6,0x6C,0x81,0xA5,0x6C,0xBF,0x96,0x04,0xD6,0xAC,0x52,0x32,0x6B,0xD8
		,0x64,0x7C,0x7C,0xC4,0x6E,0x5B,0xD8,0x27,0xC2,0xCD,0x55,0xCE,0xCC,0xE6,0xF4
		,0x2B,0x94,0x7C,0x7A,0x51,0x89,0x80,0xEB,0x2A,0xD2,0x72,0xBB,0x6F,0x32,0x1E
		,0x1C,0x07,0x37,0xDB,0x87,0xE0,0xE0,0xAF,0x03,0xE9,0x23,0x39,0x12,0xAC,0x43
		,0x78,0xD3,0x77,0xD0,0xAD,0x84,0x61,0xC3,0x21,0xAA,0x78,0x5E,0x0F,0xAF,0x00
		,0x8E,0x8E,0x09,0xE5,0x50,0xF4,0x2D,0x29,0x26,0xBE,0x95,0x34,0x84,0xC4,0x72
		,0x35,0x1C,0xF0,0xFD,0xC4,0x0C,0xD6,0x88,0xF7,0x39,0x16,0x6E,0x30,0xA9,0x11
		,0x3F,0x10,0x15,0xB9,0x00,0xA9,0x6C,0xF4,0x50,0x2C,0x11,0x26,0x31,0x9F,0xAB
		,0x8E,0x6A,0x5A,0x31,0x1E,0xC9,0xA6,0x5A,0x5B,0x63,0x1B,0x93,0xD9,0xA4,0x15
		,0x7C,0x79,0x25,0x9C,0x37,0xB4,0x7A,0x71,0x7A,0xFB,0x5C,0x77,0x78,0xDF,0xB5
		,0xA7,0x74,0x13,0xD6,0x68,0x84,0xD3,0x22,0x39,0x00,0xA7,0x10,0x97,0xCF,0x40
		,0x1F,0x1D,0xD8,0x29,0x30,0xC8,0xEE,0x04,0x30,0xC7,0x0D,0xAF,0x87,0xC1,0x9B
		,0x94,0x44,0x1D,0xC9
};

static const unsigned char _beid_govca_cert2004[] = 
{
		 0x30,0x82,0x03,0xCE,0x30,0x82,0x02,0xB6,0xA0,0x03,0x02,0x01,0x02,0x02,0x10
		,0x49,0x42,0xC2,0xE5,0x55,0xDF,0x85,0xEA,0x1D,0x8A,0x89,0x0C,0x7F,0xF3,0x79
		,0x58,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05
		,0x00,0x30,0x27,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42
		,0x45,0x31,0x18,0x30,0x16,0x06,0x03,0x55,0x04,0x03,0x13,0x0F,0x42,0x65,0x6C
		,0x67,0x69,0x75,0x6D,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,0x30,0x1E,0x17
		,0x0D,0x30,0x33,0x31,0x32,0x31,0x35,0x31,0x33,0x30,0x30,0x30,0x30,0x5A,0x17
		,0x0D,0x31,0x30,0x30,0x38,0x31,0x35,0x31,0x32,0x30,0x30,0x30,0x30,0x5A,0x30
		,0x25,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45,0x31
		,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0D,0x47,0x6F,0x76,0x65,0x72
		,0x6E,0x6D,0x65,0x6E,0x74,0x20,0x43,0x41,0x30,0x82,0x01,0x22,0x30,0x0D,0x06
		,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x82,0x01
		,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,0x00,0xC0,0xD2,0x5E,0x9B
		,0xF9,0x94,0xEF,0x78,0x90,0xC4,0x35,0xB1,0x3E,0x2B,0xC1,0x7F,0x53,0x16,0xBE
		,0xB3,0x7D,0xAE,0xDF,0xBB,0x4D,0xDA,0xC6,0xF6,0x14,0xF1,0x99,0x49,0x08,0x0C
		,0x33,0x94,0xA8,0x3A,0xFF,0x70,0xB9,0xA8,0x4A,0x4C,0xEE,0x71,0xE4,0xF0,0xA5
		,0x4E,0x89,0xB4,0xDB,0x4F,0x9C,0xA3,0x41,0x87,0x9C,0xB8,0xE9,0x34,0x7E,0xBB
		,0xF0,0x4D,0x26,0x90,0xEC,0x77,0x6B,0x45,0xDE,0xC4,0x92,0x74,0x17,0x38,0x3B
		,0x18,0xE2,0xD9,0xDC,0x0A,0x4F,0x27,0x31,0xEA,0xC1,0x24,0x30,0xE0,0x88,0xED
		,0xAA,0x58,0xB6,0xCA,0x8C,0x91,0x8A,0x94,0xC6,0xFA,0x1A,0x91,0xA1,0x25,0x0E
		,0x23,0xAD,0x18,0x7F,0x79,0x4F,0xAA,0x54,0x58,0xF0,0x50,0xCA,0xF8,0xEC,0x24
		,0x85,0x26,0x56,0xE0,0x5B,0x1B,0x55,0x8B,0x6B,0xAB,0xCF,0x6A,0xBB,0xB8,0xCB
		,0xAF,0x85,0xFB,0x4F,0x14,0xDC,0x99,0x16,0x8C,0x45,0x0B,0xAE,0x1F,0xC6,0xDD
		,0xA4,0x79,0x85,0x1A,0xE9,0xE2,0x7B,0x8C,0xA6,0x0C,0xB5,0xD7,0xEB,0xB5,0x58
		,0x48,0xA9,0x35,0x3F,0xEC,0xB8,0x9C,0x25,0x93,0xE2,0x3F,0xAD,0xAB,0xFA,0xE8
		,0x61,0xD0,0x42,0xDA,0x0A,0x68,0x13,0x79,0x5E,0xD6,0x1D,0xE4,0x24,0xD5,0x68
		,0x0A,0xBA,0x52,0xA1,0xC6,0xE4,0x58,0x35,0x8B,0x0B,0xA2,0x7A,0x57,0x55,0x23
		,0xBE,0x0D,0xD4,0x1D,0x18,0x72,0xB2,0x21,0xD4,0x67,0xCC,0xAC,0xF1,0xA9,0x4B
		,0xE2,0x4C,0x26,0x1D,0xB7,0x43,0x16,0x05,0xC8,0x08,0xD9,0x90,0xA7,0xE9,0x6E
		,0x16,0x5E,0x3A,0x1D,0x41,0x6C,0xBC,0xCA,0x27,0x08,0xF0,0xE1,0x02,0x03,0x01
		,0x00,0x01,0xA3,0x81,0xF7,0x30,0x81,0xF4,0x30,0x0E,0x06,0x03,0x55,0x1D,0x0F
		,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,0x03,0x55,0x1D
		,0x13,0x01,0x01,0xFF,0x04,0x08,0x30,0x06,0x01,0x01,0xFF,0x02,0x01,0x00,0x30
		,0x43,0x06,0x03,0x55,0x1D,0x20,0x04,0x3C,0x30,0x3A,0x30,0x38,0x06,0x06,0x60
		,0x38,0x01,0x01,0x01,0x03,0x30,0x2E,0x30,0x2C,0x06,0x08,0x2B,0x06,0x01,0x05
		,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x72,0x65
		,0x70,0x6F,0x73,0x69,0x74,0x6F,0x72,0x79,0x2E,0x65,0x69,0x64,0x2E,0x62,0x65
		,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,0x65,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E
		,0x04,0x16,0x04,0x14,0x68,0xCB,0x1E,0x8C,0xD7,0x35,0xB8,0x28,0x40,0x57,0xE6
		,0x1A,0x9B,0x3E,0xC7,0x9A,0x37,0xCC,0x7D,0x67,0x30,0x36,0x06,0x03,0x55,0x1D
		,0x1F,0x04,0x2F,0x30,0x2D,0x30,0x2B,0xA0,0x29,0xA0,0x27,0x86,0x25,0x68,0x74
		,0x74,0x70,0x3A,0x2F,0x2F,0x63,0x72,0x6C,0x2E,0x65,0x69,0x64,0x2E,0x62,0x65
		,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,0x65,0x2F,0x62,0x65,0x6C,0x67,0x69,0x75
		,0x6D,0x2E,0x63,0x72,0x6C,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01,0x86,0xF8
		,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1F,0x06,0x03,0x55,0x1D
		,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x10,0xF0,0x0C,0x56,0x9B,0x61,0xEA,0x57
		,0x3A,0xB6,0x35,0x97,0x6D,0x9F,0xDD,0xB9,0x14,0x8E,0xDB,0xE6,0x30,0x0D,0x06
		,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01
		,0x01,0x00,0x2F,0xC9,0xE7,0xB4,0x37,0xED,0x29,0xD8,0x42,0x10,0x4B,0x25,0x9A
		,0x22,0x75,0x36,0x22,0x1C,0x12,0x9E,0xFF,0xA5,0xA5,0x15,0x34,0x19,0x9A,0x52
		,0xDC,0x55,0x02,0x5B,0x31,0xF3,0xD2,0xCB,0x39,0xDF,0x8F,0x09,0xDC,0x55,0x28
		,0x57,0x1E,0x77,0xFE,0xF4,0x24,0xDF,0x69,0x9E,0x99,0x26,0xC9,0x8A,0x7A,0x0E
		,0x77,0x90,0xEF,0xC5,0x7B,0xD9,0x58,0x18,0x9E,0xF1,0x18,0x8B,0x93,0xB3,0xFE
		,0x9B,0x79,0xE2,0xA2,0x72,0x5D,0xC7,0x42,0x59,0xCB,0xF5,0x54,0x10,0xC4,0x81
		,0x30,0x40,0xE6,0x34,0xBB,0x2A,0xFC,0x9A,0x1F,0x29,0xEE,0x24,0x7C,0x34,0xFC
		,0x44,0x2B,0x53,0x2B,0x87,0xA0,0x90,0xFA,0x65,0xC8,0x98,0x6D,0xDB,0xC4,0x09
		,0xFD,0x84,0x0C,0xA3,0xB1,0x87,0x58,0x74,0x23,0x48,0xC2,0xEC,0x0E,0x60,0x6E
		,0x16,0xCD,0x01,0x97,0xB8,0x5E,0x13,0x4C,0x9D,0x47,0xCC,0xF5,0x50,0x4E,0x76
		,0x7A,0xCA,0xA3,0x51,0xC6,0xBC,0xC0,0x8E,0x20,0x3B,0x4C,0x9F,0x25,0x0A,0x35
		,0x83,0x8F,0xCE,0xD8,0x95,0xB7,0x46,0x26,0x5A,0x06,0x48,0x33,0x10,0x80,0x8D
		,0x8B,0x5A,0x94,0x17,0xFE,0x16,0x15,0xA3,0xE4,0x4E,0xA6,0xCE,0xBA,0x34,0xFC
		,0xE0,0xB7,0x40,0x1C,0xBD,0xF9,0x38,0xC7,0xE8,0x6C,0x72,0x79,0x05,0xE8,0xF6
		,0x65,0x17,0x8A,0xA6,0x3E,0x9B,0x68,0xC8,0xE3,0x39,0x66,0x6E,0x63,0xF8,0x56
		,0x11,0xD9,0x34,0x04,0x9B,0x0D,0x1A,0x41,0xC6,0x28,0x95,0xA2,0xFC,0x31,0x09
		,0xC3,0xEE,0x6A,0xFE,0x46,0xF1,0x5B,0x25,0x4C,0xB8,0x85,0xF8,0x8C,0x05,0xB3
		,0x61,0x07,0xF6
};

static const unsigned char _beid_govca_cert2008[] = 
{
	 0x30,0x82,0x03,0xDF,0x30,0x82,0x02,0xC7,0xA0,0x03,0x02,0x01,0x02,0x02,0x10
	,0x6C,0x85,0x9F,0x47,0x73,0x14,0x38,0x15,0x01,0xA2,0x52,0x6D,0xE0,0x23,0xD2
	,0xC4,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05
	,0x00,0x30,0x28,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42
	,0x45,0x31,0x19,0x30,0x17,0x06,0x03,0x55,0x04,0x03,0x13,0x10,0x42,0x65,0x6C
	,0x67,0x69,0x75,0x6D,0x20,0x52,0x6F,0x6F,0x74,0x20,0x43,0x41,0x32,0x30,0x1E
	,0x17,0x0D,0x30,0x37,0x31,0x30,0x30,0x34,0x31,0x32,0x30,0x30,0x30,0x30,0x5A
	,0x17,0x0D,0x31,0x34,0x30,0x36,0x30,0x34,0x31,0x32,0x30,0x30,0x30,0x30,0x5A
	,0x30,0x34,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x06,0x13,0x02,0x42,0x45
	,0x31,0x16,0x30,0x14,0x06,0x03,0x55,0x04,0x03,0x13,0x0D,0x47,0x6F,0x76,0x65
	,0x72,0x6E,0x6D,0x65,0x6E,0x74,0x20,0x43,0x41,0x31,0x0D,0x30,0x0B,0x06,0x03
	,0x55,0x04,0x05,0x13,0x04,0x32,0x30,0x30,0x38,0x30,0x82,0x01,0x22,0x30,0x0D
	,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x82
	,0x01,0x0F,0x00,0x30,0x82,0x01,0x0A,0x02,0x82,0x01,0x01,0x00,0xD7,0xD1,0x79
	,0x00,0xCB,0xFE,0xB8,0x32,0xCA,0xBB,0x52,0xBA,0x68,0x68,0x8D,0x7A,0xD7,0xE1
	,0x09,0xAB,0x44,0x60,0x03,0x34,0xF6,0x8F,0x15,0x69,0x10,0xC6,0x93,0xF3,0x1B
	,0x01,0xBD,0x0E,0xAA,0xF9,0x81,0x7D,0xA7,0x6E,0x7B,0x43,0x0B,0x39,0x31,0xFB
	,0x9C,0x42,0xAA,0x61,0x60,0x7E,0x01,0xFB,0x46,0x8A,0x59,0x22,0x99,0x57,0xE6
	,0x8F,0x85,0xE4,0x79,0xDE,0x8B,0x85,0x86,0x67,0xC7,0x68,0xBE,0xBF,0x9A,0x4D
	,0x9E,0xDE,0x38,0x32,0x8E,0xF6,0x3F,0xAB,0x7D,0xA2,0x9A,0xFF,0x21,0x31,0x8B
	,0x44,0x8E,0x28,0x20,0x9B,0x6F,0x92,0xB2,0xB4,0xE7,0x7A,0x59,0x94,0x53,0x21
	,0xA5,0x7A,0xC9,0xAB,0x2A,0xBC,0x16,0x02,0xFF,0xA4,0x3B,0xBC,0x81,0xA6,0xB1
	,0x20,0x73,0x43,0x99,0x83,0x82,0xA7,0xFB,0xCC,0x79,0x1A,0x42,0x72,0xF6,0x97
	,0xBA,0x89,0x11,0x61,0x9E,0x22,0xBC,0xF1,0xEA,0x64,0x24,0x6B,0xFF,0x96,0xF8
	,0xF8,0xA5,0x7B,0x15,0xEE,0x5A,0xA1,0x32,0x7C,0xA4,0x9D,0x4B,0x8B,0xE7,0x42
	,0x2D,0x89,0x61,0x97,0x50,0x88,0x81,0x0A,0x40,0xA7,0xB9,0xB6,0x13,0x7A,0x53
	,0xE2,0xA5,0xA9,0x10,0x39,0x38,0x5D,0x17,0x56,0x38,0x97,0x18,0x83,0xAA,0x3F
	,0x91,0x60,0x01,0xC8,0x0B,0x4A,0x27,0xEE,0x3F,0x08,0x24,0x65,0x85,0x87,0xCB
	,0x4D,0x70,0xE4,0x44,0xDD,0xCA,0xB3,0x00,0xB9,0x61,0x80,0x46,0x00,0x9D,0x4F
	,0xF2,0x44,0xFC,0xA8,0xFC,0x8C,0xF8,0xA5,0x6F,0x0E,0x39,0x77,0xCF,0xAE,0x1C
	,0x6A,0xA6,0xA1,0x48,0xF8,0xEF,0x07,0x96,0x75,0x14,0x50,0x68,0x2B,0x02,0x03
	,0x01,0x00,0x01,0xA3,0x81,0xF8,0x30,0x81,0xF5,0x30,0x0E,0x06,0x03,0x55,0x1D
	,0x0F,0x01,0x01,0xFF,0x04,0x04,0x03,0x02,0x01,0x06,0x30,0x12,0x06,0x03,0x55
	,0x1D,0x13,0x01,0x01,0xFF,0x04,0x08,0x30,0x06,0x01,0x01,0xFF,0x02,0x01,0x00
	,0x30,0x43,0x06,0x03,0x55,0x1D,0x20,0x04,0x3C,0x30,0x3A,0x30,0x38,0x06,0x06
	,0x60,0x38,0x09,0x01,0x01,0x03,0x30,0x2E,0x30,0x2C,0x06,0x08,0x2B,0x06,0x01
	,0x05,0x05,0x07,0x02,0x01,0x16,0x20,0x68,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x72
	,0x65,0x70,0x6F,0x73,0x69,0x74,0x6F,0x72,0x79,0x2E,0x70,0x6B,0x69,0x2E,0x62
	,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,0x65,0x30,0x1D,0x06,0x03,0x55,0x1D
	,0x0E,0x04,0x16,0x04,0x14,0x95,0xF5,0xD7,0xEB,0xD3,0x97,0xEC,0x28,0x16,0x38
	,0x0D,0xD5,0x90,0xF9,0x1A,0xAB,0x83,0xDB,0x8D,0x22,0x30,0x37,0x06,0x03,0x55
	,0x1D,0x1F,0x04,0x30,0x30,0x2E,0x30,0x2C,0xA0,0x2A,0xA0,0x28,0x86,0x26,0x68
	,0x74,0x74,0x70,0x3A,0x2F,0x2F,0x63,0x72,0x6C,0x2E,0x70,0x6B,0x69,0x2E,0x62
	,0x65,0x6C,0x67,0x69,0x75,0x6D,0x2E,0x62,0x65,0x2F,0x62,0x65,0x6C,0x67,0x69
	,0x75,0x6D,0x32,0x2E,0x63,0x72,0x6C,0x30,0x11,0x06,0x09,0x60,0x86,0x48,0x01
	,0x86,0xF8,0x42,0x01,0x01,0x04,0x04,0x03,0x02,0x00,0x07,0x30,0x1F,0x06,0x03
	,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x85,0x8A,0xEB,0xF4,0xC5,0xBB
	,0xBE,0x0E,0x59,0x03,0x94,0xDE,0xD6,0x80,0x01,0x15,0xE3,0x10,0x9C,0x39,0x30
	,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03
	,0x82,0x01,0x01,0x00,0x66,0x15,0x56,0xD8,0x79,0x55,0x22,0x1E,0x07,0x07,0x56
	,0x70,0x3F,0x89,0xBD,0xAC,0xBC,0x23,0x7C,0xCE,0xE8,0x19,0x2A,0xBB,0x80,0x63
	,0xC3,0x96,0x25,0xD5,0x85,0xAF,0x3E,0x6B,0xB5,0xC5,0x80,0xC8,0xEB,0x0C,0xC1
	,0x6E,0x1A,0x6D,0xE9,0xE6,0xBD,0xB5,0x6A,0x0B,0x6C,0xA6,0x4E,0x6C,0x1F,0x1A
	,0x78,0x6A,0x46,0x5A,0x0B,0x62,0x78,0xBB,0x35,0x67,0x72,0x20,0x40,0x05,0xE3
	,0x26,0xA7,0xA1,0x2B,0x34,0x20,0xEC,0x01,0x96,0x58,0x98,0x74,0x4E,0x51,0x5B
	,0x23,0x91,0xAE,0x4F,0x05,0xDD,0xF1,0x6E,0x2A,0x3F,0x6B,0xCC,0x9D,0x6C,0x7E
	,0x50,0x77,0xFE,0xD0,0x88,0x5E,0x2E,0x5A,0xE0,0x24,0x17,0xBF,0xE0,0x17,0x62
	,0x6E,0x57,0xF9,0xE4,0x02,0x70,0x59,0xBF,0x4E,0x9F,0x02,0xA5,0xA1,0x46,0x17
	,0x89,0xF1,0x72,0xC3,0x29,0xAA,0x7B,0x8B,0x4E,0xBC,0x20,0x2B,0xC7,0x33,0x4A
	,0x67,0x76,0x18,0xD8,0x7A,0x84,0x17,0x56,0x21,0xD2,0xB4,0x87,0x45,0x32,0x9A
	,0xF4,0x4A,0x13,0x21,0xBD,0xB3,0x92,0xCA,0x53,0x68,0xF6,0xDA,0x1D,0x68,0x4F
	,0xCB,0xA3,0x4E,0x57,0x26,0x65,0x1C,0x7B,0x2E,0x62,0xF3,0x6E,0xED,0x21,0x91
	,0x5D,0x7B,0xA6,0x66,0x7F,0xF9,0x4A,0xF6,0xDA,0x7F,0x18,0xC0,0x9F,0xE4,0x27
	,0x5C,0x7F,0x7C,0xF0,0x98,0xA2,0x2E,0xD5,0xD0,0x06,0xAF,0xE8,0x44,0x30,0x55
	,0x03,0xE9,0x01,0x36,0x8C,0x41,0x40,0x86,0x1B,0x9D,0xCD,0x48,0x94,0x84,0x9D
	,0x45,0x24,0x4C,0xD9,0x02,0xAA,0x83,0x64,0xEB,0xA0,0x89,0x6B,0x2F,0x47,0xEC
	,0xB9,0x77,0x2B,0x60,0x76
};

static const unsigned char *const _beid_rrnca_certs[] = 
{
	_beid_govca_cert2003,
	_beid_govca_cert2004,
	NULL
};

static const unsigned long _beid_rrnca_certs_size[] = 
{
	sizeof(_beid_govca_cert2003),
	sizeof(_beid_govca_cert2004)
};

static const unsigned char *const _beid_issuer_certs[] = 
{
	_beid_govca_cert2008,
	NULL
};

static const unsigned long _beid_issuer_certs_size[] = 
{
	sizeof(_beid_govca_cert2008)
};

static const char *const _beid_files_to_warn[] = 
{
	BEID_FILE_ID,			
	BEID_FILE_ADDRESS,		
	BEID_FILE_PHOTO,		
	NULL
};

}

#endif //__CARDBEIDDEF_H__
