/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.ClassPathElement;
import com.rc.retroweaver.DirectoryElement;
import com.rc.retroweaver.JarElement;
import com.rc.retroweaver.RetroWeaver;
import com.rc.retroweaver.RetroWeaverException;
import com.rc.retroweaver.runtime.Collections;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroWeaverClassLoader
extends ClassLoader {
    private RetroWeaver retroWeaver;
    private List<ClassPathElement> classPathElements;

    protected void setWeaver(RetroWeaver retroWeaver) {
        this.retroWeaver = retroWeaver;
    }

    protected void setClassPath(List<String> classPath) {
        this.classPathElements = new LinkedList<ClassPathElement>();
        for (String pathEntry : classPath) {
            File f = new File(pathEntry);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                this.addDirectoryClassPathElement(pathEntry);
                continue;
            }
            this.addJarClassPathElement(pathEntry);
        }
    }

    protected void setClassPath(String classPath) {
        LinkedList<String> l = new LinkedList<String>();
        if (classPath != null) {
            StringTokenizer t = new StringTokenizer(classPath, File.pathSeparator);
            while (t.hasMoreTokens()) {
                l.add(t.nextToken());
            }
        }
        this.setClassPath(l);
    }

    protected void addDirectoryClassPathElement(String dirName) {
        DirectoryElement e = new DirectoryElement(dirName);
        this.classPathElements.add(e);
    }

    protected void addJarClassPathElement(String jarName) {
        try {
            JarElement e = new JarElement(jarName);
            this.classPathElements.add(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String resourceName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
        for (ClassPathElement e : this.classPathElements) {
            boolean weaved;
            if (!e.hasResource(resourceName)) continue;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream is = e.getResourceStream(resourceName);
            try {
                weaved = this.retroWeaver.weave(is, name, bos);
            }
            catch (IOException ioe) {
                throw new RetroWeaverException(new StringBuffer().append("Problem weaving class ").append(name).append(": ").append(ioe.getMessage()).toString());
            }
            byte[] b = weaved ? bos.toByteArray() : e.getResourceData(resourceName);
            Class<?> clazz = this.defineClass(name.replace('/', '.'), b, 0, b.length);
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    protected byte[] getClassData(String name) throws ClassNotFoundException {
        String resourceName = new StringBuffer().append(name.replace('.', '/')).append(".class").toString();
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(resourceName)) continue;
            byte[] b = e.getResourceData(resourceName);
            return b;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(name)) continue;
            return e.getResourceURL(name);
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> l = new ArrayList<URL>();
        for (ClassPathElement e : this.classPathElements) {
            if (!e.hasResource(name)) continue;
            l.add(e.getResourceURL(name));
        }
        return Collections.enumeration(l);
    }
}

