/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui.listeners;

import dguitar.gui.DGuitar;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ADropTargetListener
implements DropTargetListener {
    private DGuitar parent;

    public ADropTargetListener(DGuitar dguitar) {
        if (dguitar == null) {
            throw new NullPointerException("dguitar is null");
        }
        this.parent = dguitar;
    }

    public void drop(DropTargetDropEvent dtde) {
        Transferable transfer = dtde.getTransferable();
        dtde.acceptDrop(3);
        this.importData(this.parent, transfer);
    }

    public void importData(DGuitar dguitar, Transferable t) {
        if (this.canImport(t.getTransferDataFlavors())) {
            try {
                DataFlavor[] flavors = t.getTransferDataFlavors();
                int i = 0;
                while (i < flavors.length) {
                    if (DataFlavor.javaFileListFlavor.equals(flavors[i])) {
                        if (t.getTransferData(DataFlavor.javaFileListFlavor) instanceof List) {
                            List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                            dguitar.displayMultipleFiles(fileList);
                        }
                    } else if (DataFlavor.stringFlavor.equals(flavors[i]) && t.getTransferData(DataFlavor.stringFlavor) instanceof String) {
                        String path = (String)t.getTransferData(DataFlavor.stringFlavor);
                        List fileList = this.convertStringsToFileList(path);
                        dguitar.displayMultipleFiles(fileList);
                    }
                    ++i;
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List convertStringsToFileList(String filestr) {
        ArrayList<File> files = new ArrayList<File>();
        String[] tokenizedFiles = filestr.split("\n");
        int i = 0;
        while (i < tokenizedFiles.length) {
            String path = tokenizedFiles[i];
            if (path.startsWith("file://")) {
                if (path.endsWith("\r")) {
                    path = path.substring(7);
                    path = path.replaceAll("\r", "");
                    path = path.replaceAll("%20", " ");
                } else {
                    path = path.substring(7);
                }
            }
            files.add(new File(path));
            ++i;
        }
        return files;
    }

    public boolean canImport(DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (DataFlavor.javaFileListFlavor.equals(flavors[i])) {
                return true;
            }
            if (DataFlavor.stringFlavor.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }
}

