/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Constants;

public class VerticalAligner {
    private static boolean bFixGTKBug;

    static {
        COConfigurationManager.addParameterListener("SWT_bGTKTableBug", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                VerticalAligner.readConfig();
            }
        });
        VerticalAligner.readConfig();
    }

    protected static void readConfig() {
        bFixGTKBug = COConfigurationManager.getBooleanParameter("SWT_bGTKTableBug") && Constants.isLinux && SWT.getPlatform().equals("gtk");
    }

    public static int getTableAdjustVerticalBy(Table t) {
        return VerticalAligner.COgetTableAdjustVerticalBy(t);
    }

    public static int getTableAdjustHorizontallyBy(Table t) {
        return VerticalAligner.COgetTableAdjustHorizontallyBy(t);
    }

    public static int COgetTableAdjustVerticalBy(Table t) {
        if (!bFixGTKBug || t == null || t.isDisposed()) {
            return 0;
        }
        return -t.getHeaderHeight();
    }

    public static int COgetTableAdjustHorizontallyBy(Table t) {
        if (!bFixGTKBug || t == null || t.isDisposed()) {
            return 0;
        }
        ScrollBar sb = t.getHorizontalBar();
        if (sb == null) {
            return 0;
        }
        return sb.getSelection();
    }
}

