/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostException;

public class ManagerUtils {
    public static void run(DownloadManager dm) {
        if (dm != null) {
            Program.launch((String)dm.getTorrentSaveDirAndFile());
        }
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().hostTorrent(torrent);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().publishTorrent(torrent);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setState(0);
        }
    }

    public static void queue(DownloadManager dm, Composite panel) {
        if (dm != null && dm.getState() == 70) {
            dm.setState(75);
        }
    }

    public static void stop(DownloadManager dm, Composite panel) {
        ManagerUtils.stop(dm, panel, 70);
    }

    public static void stop(DownloadManager dm, Composite panel, int stateAfterStopped) {
        if (dm != null && dm.getState() != 70 && dm.getState() != stateAfterStopped) {
            if (dm.getState() == 60 && dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", true)) {
                MessageBox mb = new MessageBox(panel.getShell(), 200);
                mb.setText(MessageText.getString("seedmore.title"));
                mb.setMessage(String.valueOf(MessageText.getString("seedmore.shareratio")) + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
                int action = mb.open();
                if (action == 64) {
                    dm.stopIt(stateAfterStopped, false, false);
                }
            } else {
                dm.stopIt(stateAfterStopped, false, false);
            }
        }
    }
}

