/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.pieces;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.SWTManagerImpl;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class BlocksItem
extends CoreTableColumn
implements TableCellAddedListener {
    public BlocksItem() {
        super("blocks", "Pieces");
        this.initializeAsGraphic(-2, 200);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener {
        CacheFileManagerStats cacheStats;

        public Cell(TableCell cell) {
            cell.setFillCell(true);
            cell.addRefreshListener(this);
            cell.addDisposeListener(this);
            try {
                this.cacheStats = CacheFileManagerFactory.getSingleton().getStats();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void dispose(TableCell cell) {
            Image img = ((TableCellCore)cell).getGraphicSWT();
            if (img != null && !img.isDisposed()) {
                img.dispose();
            }
            cell.setGraphic(null);
        }

        public void refresh(TableCell cell) {
            PEPiece piece = (PEPiece)cell.getDataSource();
            if (piece == null) {
                cell.setSortValue(0L);
                return;
            }
            cell.setSortValue(piece.getCompleted());
            long lNumBlocks = piece.getNbBlocs();
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight();
            int x1 = newWidth - 2;
            int y1 = newHeight - 3;
            if (x1 < 10 || y1 < 3) {
                return;
            }
            Image image = new Image((Device)SWTManagerImpl.getSingleton().getDisplay(), newWidth, newHeight);
            Color blue = Colors.blues[9];
            Color green = Colors.blues[2];
            Color downloaded = Colors.red;
            Color cache = Colors.grey;
            GC gcImage = new GC((Drawable)image);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, x1 + 1, y1 + 1);
            int blocksPerPixel = 0;
            int iPixelsPerBlock = 0;
            while (iPixelsPerBlock <= 0) {
                iPixelsPerBlock = (int)((long)(x1 + 1) / (lNumBlocks / (long)(++blocksPerPixel)));
            }
            TOTorrent torrent = piece.getManager().getDownloadManager().getTorrent();
            boolean[] written = piece.getWritten();
            boolean piece_done = piece.isComplete();
            int i = 0;
            while ((long)i < lNumBlocks) {
                long bytes;
                int nextWidth = iPixelsPerBlock;
                if ((long)i == lNumBlocks - 1L) {
                    nextWidth = (int)((long)x1 - (long)iPixelsPerBlock * (lNumBlocks / (long)blocksPerPixel - 1L));
                }
                Color color = Colors.white;
                if (written == null) {
                    if (piece_done) {
                        color = blue;
                    }
                } else if (written[i]) {
                    color = blue;
                } else if (piece.getDownloaded()[i]) {
                    color = downloaded;
                } else if (piece.getRequested()[i]) {
                    color = green;
                }
                gcImage.setBackground(color);
                gcImage.fillRectangle(i * iPixelsPerBlock / blocksPerPixel + 1, 1, nextWidth, y1);
                int pieceNumber = piece.getPieceNumber();
                int length = piece.getBlockSize(i);
                int offset = 16384 * i;
                long l = bytes = this.cacheStats == null ? 0L : this.cacheStats.getBytesInCache(torrent, pieceNumber, offset, length);
                if (bytes == (long)length) {
                    gcImage.setBackground(cache);
                    gcImage.fillRectangle(i * iPixelsPerBlock + 1, 1, nextWidth, 3);
                }
                i += blocksPerPixel;
            }
            gcImage.dispose();
            Image oldImage = ((TableCellCore)cell).getGraphicSWT();
            ((TableCellCore)cell).setGraphic(image);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
            gcImage.dispose();
        }
    }
}

