/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ConnectedTimeItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public ConnectedTimeItem() {
        super("connected_time", 2, -1, 70, "Peers");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long value;
        PEPeerTransport peer = (PEPeerTransport)cell.getDataSource();
        long l = value = peer == null ? 0L : peer.getTimeSinceConnectionEstablished();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(TimeFormatter.format(value / 1000L));
    }
}

