/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class HealthItem
extends CoreTableColumn
implements TableCellAddedListener {
    static TRHost tracker_host = MainWindow.getWindow().getAzureusCore().getTrackerHost();

    public HealthItem(String sTableID) {
        super("health", sTableID);
        this.initializeAsGraphic(-2, 20);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener {
        public Cell(TableCell cell) {
            cell.addRefreshListener(this);
            cell.setMarginWidth(0);
            cell.setMarginHeight(0);
        }

        public void refresh(TableCell cell) {
            String sHelpID;
            String image_name;
            int health;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            int n = health = dm == null ? 0 : dm.getHealthStatus();
            if (!cell.setSortValue(health) && cell.isValid()) {
                return;
            }
            TRHostTorrent ht = tracker_host.getHostTorrent(dm.getTorrent());
            if (health == 5) {
                image_name = "st_ko";
                sHelpID = "health.explain.red";
            } else if (health == 4) {
                image_name = "st_ok";
                sHelpID = "health.explain.green";
            } else if (health == 2) {
                image_name = "st_no_tracker";
                sHelpID = "health.explain.blue";
            } else if (health == 3) {
                image_name = "st_no_remote";
                sHelpID = "health.explain.yellow";
            } else {
                image_name = "st_stopped";
                sHelpID = "health.explain.grey";
            }
            if (ht != null) {
                image_name = String.valueOf(image_name) + "_shared";
            }
            if (((TableCellCore)cell).setGraphic(ImageRepository.getImage(image_name))) {
                String sToolTip = MessageText.getString(sHelpID);
                if (ht != null) {
                    sToolTip = String.valueOf(sToolTip) + "\n" + MessageText.getString("health.explain.share");
                }
                cell.setToolTip(sToolTip);
            }
        }
    }
}

