/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.utils.SortableTable;

public class TableSorter
implements ParameterListener {
    private static int reOrderDelay = COConfigurationManager.getIntParameter("ReOrder Delay");
    private TableColumnCore lastSortedTableColumn;
    private boolean bLastAscending;
    private int loopFactor = 0;
    private SortableTable sortableTable;
    private String configTableName;

    public TableSorter(SortableTable sortableTable, String configTableName, String defaultField, boolean isDefaultAscending) {
        String sSortColumn = COConfigurationManager.getStringParameter(String.valueOf(configTableName) + ".sortColumn", defaultField);
        this.lastSortedTableColumn = sortableTable.getTableColumnCore(sSortColumn);
        this.bLastAscending = COConfigurationManager.getBooleanParameter(String.valueOf(configTableName) + ".sortAsc", isDefaultAscending);
        this.sortableTable = sortableTable;
        this.configTableName = configTableName;
        COConfigurationManager.addParameterListener("ReOrder Delay", this);
    }

    public void reOrder(boolean force) {
        if (!(force || reOrderDelay != 0 && this.loopFactor++ >= reOrderDelay)) {
            return;
        }
        this.loopFactor = 0;
        this.sortColumn();
    }

    public void parameterChanged(String parameterName) {
        reOrderDelay = COConfigurationManager.getIntParameter("ReOrder Delay");
    }

    public String getLastField() {
        if (this.lastSortedTableColumn == null) {
            return "";
        }
        return this.lastSortedTableColumn.getName();
    }

    public boolean isAscending() {
        return this.bLastAscending;
    }

    public void sortColumn(boolean bForce) {
        this.sortColumn(this.lastSortedTableColumn, this.bLastAscending, bForce);
    }

    public void sortColumn() {
        this.sortColumn(this.lastSortedTableColumn, this.bLastAscending, false);
    }

    public void sortColumnReverse(TableColumnCore tableColumn) {
        this.sortColumn(tableColumn, this.lastSortedTableColumn == tableColumn ? !this.bLastAscending : COConfigurationManager.getBooleanParameter("config.style.table.sortDefaultAscending"), false);
    }

    private void sortColumn(TableColumnCore tableColumn, boolean bAscending) {
        this.sortColumn(tableColumn, bAscending, false);
    }

    private void sortColumn(TableColumnCore tableColumn, boolean bAscending, boolean bForce) {
        Object row;
        if (tableColumn == null) {
            return;
        }
        String sColumnName = tableColumn.getName();
        if (this.lastSortedTableColumn != tableColumn) {
            COConfigurationManager.setParameter(String.valueOf(this.configTableName) + ".sortColumn", sColumnName);
            this.lastSortedTableColumn = tableColumn;
        }
        if (this.bLastAscending != bAscending) {
            COConfigurationManager.setParameter(String.valueOf(this.configTableName) + ".sortAsc", bAscending);
            this.bLastAscending = bAscending;
        }
        List columnCellList = this.sortableTable.getColumnCoreCells(sColumnName);
        Object[] cells = columnCellList.toArray(new TableCellCore[0]);
        TableCellCore[] cellsOriginal = (TableCellCore[])cells.clone();
        TableItem[] tableItems = new TableItem[cells.length];
        boolean[] selected = new boolean[cells.length];
        int i = 0;
        while (i < cells.length) {
            row = (BufferedTableRow)((Object)cells[i].getTableRowCore());
            tableItems[i] = ((BufferedTableRow)row).getItem();
            selected[i] = ((BufferedTableRow)row).getSelected();
            ++i;
        }
        if (bForce) {
            i = 0;
            while (i < cells.length) {
                cells[i].refresh();
                ++i;
            }
        }
        if (this.bLastAscending) {
            Arrays.sort(cells);
        } else {
            Arrays.sort(cells, Collections.reverseOrder());
        }
        i = 0;
        while (i < cells.length) {
            if (cells[i] != cellsOriginal[i]) {
                row = cells[i].getTableRowCore();
                boolean bWasSelected = selected[row.getIndex()];
                ((BufferedTableRow)row).setTableItem(tableItems[i], false);
                ((BufferedTableRow)row).setSelected(bWasSelected);
                tableItems[i].setData("TableRow", row);
                row.setValid(false);
                row.refresh(true);
            }
            ++i;
        }
    }
}

