/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;

public class ConfigSectionLogging
implements ConfigSectionSWT {
    private static final int[] logFileSizes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 75, 100, 200, 300, 500};

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "logging";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(final Composite parent) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        int[] components = nArray;
        Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
        Composite gLogging = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        gLogging.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        gLogging.setLayout((Layout)layout);
        BooleanParameter enableLogging = new BooleanParameter(gLogging, "Logging Enable", "ConfigView.section.logging.enable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableLogging.setLayoutData(gridData);
        Composite cArea = new Composite(gLogging, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        cArea.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        cArea.setLayoutData((Object)gridData);
        Label lStatsPath = new Label(cArea, 0);
        Messages.setLanguageText((Widget)lStatsPath, "ConfigView.section.logging.logdir");
        gridData = new GridData();
        gridData.widthHint = 150;
        final StringParameter pathParameter = new StringParameter(cArea, "Logging Dir");
        pathParameter.setLayoutData(gridData);
        Button browse = new Button(cArea, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.logging.choosedefaultsavepath"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        Label lMaxLog = new Label(cArea, 0);
        Messages.setLanguageText((Widget)lMaxLog, "ConfigView.section.logging.maxsize");
        String[] lmLabels = new String[logFileSizes.length];
        int[] lmValues = new int[logFileSizes.length];
        int i = 0;
        while (i < logFileSizes.length) {
            int num = logFileSizes[i];
            lmLabels[i] = " " + num + " MB";
            lmValues[i] = num;
            ++i;
        }
        IntListParameter paramMaxSize = new IntListParameter(cArea, "Logging Max Size", lmLabels, lmValues);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        paramMaxSize.setLayoutData(gridData);
        Composite cLogTypes = new Composite(gLogging, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        cLogTypes.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        cLogTypes.setLayoutData((Object)gridData);
        int i2 = 0;
        while (i2 < components.length) {
            Group gLogType = new Group(cLogTypes, 0);
            layout = new GridLayout();
            layout.numColumns = 1;
            gLogType.setLayout((Layout)layout);
            gLogType.setLayoutData((Object)new GridData(256));
            Messages.setLanguageText((Widget)gLogType, "ConfigView.section.logging.log" + components[i2] + "component");
            int j = 0;
            while (j <= 3) {
                new BooleanParameter((Composite)gLogType, "bLog" + components[i2] + "-" + j, "ConfigView.section.logging.log" + j + "type");
                ++j;
            }
            ++i2;
        }
        Control[] controls = new Control[]{cArea, cLogTypes};
        enableLogging.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(controls));
        return gLogging;
    }
}

