/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCore;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IpFilterEditor;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;

public class ConfigSectionIPFilter
implements ConfigSectionSWT {
    AzureusCore azureus_core;
    IpFilter filter;
    Table table;
    boolean noChange;
    FilterComparator comparator;
    IpRange[] ipRanges;
    Label percentage_blocked;

    public ConfigSectionIPFilter(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        this.comparator = new FilterComparator();
    }

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "ipfilter";
    }

    public void configSectionSave() {
        try {
            if (this.filter != null) {
                this.filter.save();
            }
        }
        catch (Exception e) {
            LGLogger.logUnrepeatableAlert("Save of filter file fails", e);
        }
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        this.filter = this.azureus_core.getIpFilterManager().getIPFilter();
        Composite gFilter = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        gFilter.setLayout((Layout)layout);
        GridData gridData = new GridData(272);
        gFilter.setLayoutData((Object)gridData);
        this.percentage_blocked = new Label(gFilter, 0);
        gridData = new GridData(768);
        this.percentage_blocked.setLayoutData((Object)gridData);
        this.setPercentageBlocked();
        BooleanParameter enabled = new BooleanParameter(gFilter, "Ip Filter Enabled", true);
        Messages.setLanguageText((Widget)enabled.getControl(), "ConfigView.section.ipfilter.enable");
        BooleanParameter deny = new BooleanParameter(gFilter, "Ip Filter Allow", false);
        Messages.setLanguageText((Widget)deny.getControl(), "ConfigView.section.ipfilter.allow");
        deny.addChangeListener(new ParameterChangeListener(){

            public void parameterChanged(Parameter p, boolean caused_internally) {
                ConfigSectionIPFilter.this.setPercentageBlocked();
            }
        });
        BooleanParameter enable_bad_data_banning = new BooleanParameter(gFilter, "Ip Filter Enable Banning", true);
        Messages.setLanguageText((Widget)enable_bad_data_banning.getControl(), "ConfigView.section.ipfilter.enablebanning");
        this.table = new Table(gFilter, 268503044);
        String[] headers = new String[]{"ConfigView.section.ipfilter.description", "ConfigView.section.ipfilter.start", "ConfigView.section.ipfilter.end"};
        int[] sizes = new int[]{200, 110, 110};
        int[] aligns = new int[]{16384, 0x1000000, 0x1000000};
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(this.table, aligns[i]);
            tc.setText(headers[i]);
            tc.setWidth(sizes[i]);
            Messages.setLanguageText((Widget)tc, headers[i]);
            ++i;
        }
        TableColumn[] columns = this.table.getColumns();
        columns[0].setData((Object)new Integer(0));
        columns[1].setData((Object)new Integer(1));
        columns[2].setData((Object)new Integer(2));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn tc = (TableColumn)e.widget;
                int field = (Integer)tc.getData();
                ConfigSectionIPFilter.this.comparator.setField(field);
                ConfigSectionIPFilter.this.ipRanges = ConfigSectionIPFilter.this.getSortedRanges(ConfigSectionIPFilter.this.filter.getRanges());
                ConfigSectionIPFilter.this.table.setItemCount(ConfigSectionIPFilter.this.ipRanges.length);
                ConfigSectionIPFilter.this.table.clearAll();
                ConfigSectionIPFilter.this.table.redraw();
            }
        };
        columns[0].addListener(13, listener);
        columns[1].addListener(13, listener);
        columns[2].addListener(13, listener);
        this.table.setHeaderVisible(true);
        gridData = new GridData(768);
        gridData.heightHint = 400;
        this.table.setLayoutData((Object)gridData);
        Composite cArea = new Composite(gFilter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData());
        Button add = new Button(cArea, 8);
        gridData = new GridData(2);
        gridData.widthHint = 100;
        add.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)add, "ConfigView.section.ipfilter.add");
        add.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ConfigSectionIPFilter.this.addRange();
            }
        });
        Button remove = new Button(cArea, 8);
        gridData = new GridData(2);
        gridData.widthHint = 100;
        remove.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)remove, "ConfigView.section.ipfilter.remove");
        remove.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                TableItem[] selection = ConfigSectionIPFilter.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ConfigSectionIPFilter.this.removeRange((IpRange)selection[0].getData());
                ConfigSectionIPFilter.this.ipRanges = ConfigSectionIPFilter.this.getSortedRanges(ConfigSectionIPFilter.this.filter.getRanges());
                ConfigSectionIPFilter.this.table.setItemCount(ConfigSectionIPFilter.this.ipRanges.length);
                ConfigSectionIPFilter.this.table.clearAll();
                ConfigSectionIPFilter.this.table.redraw();
            }
        });
        Button edit = new Button(cArea, 8);
        gridData = new GridData(2);
        gridData.widthHint = 100;
        edit.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)edit, "ConfigView.section.ipfilter.edit");
        edit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                TableItem[] selection = ConfigSectionIPFilter.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ConfigSectionIPFilter.this.editRange((IpRange)selection[0].getData());
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TableItem[] selection = ConfigSectionIPFilter.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ConfigSectionIPFilter.this.editRange((IpRange)selection[0].getData());
            }
        });
        Control[] controls = new Control[]{add, remove, edit};
        ChangeSelectionActionPerformer enabler = new ChangeSelectionActionPerformer(controls);
        enabled.setAdditionalActionPerformer(enabler);
        this.ipRanges = this.getSortedRanges(this.filter.getRanges());
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = ConfigSectionIPFilter.this.table.indexOf(item);
                IpRange range = ConfigSectionIPFilter.this.ipRanges[index];
                item.setText(0, range.getDescription());
                item.setText(1, range.getStartIp());
                item.setText(2, range.getEndIp());
                item.setData((Object)range);
            }
        });
        this.table.setItemCount(this.ipRanges.length);
        this.table.clearAll();
        this.table.redraw();
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ConfigSectionIPFilter.this.resizeTable();
            }
        });
        gFilter.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ConfigSectionIPFilter.this.resizeTable();
            }
        });
        return gFilter;
    }

    private void resizeTable() {
        int iNewWidth = this.table.getClientArea().width - this.table.getColumn(1).getWidth() - this.table.getColumn(2).getWidth() - 20;
        if (iNewWidth > 50) {
            this.table.getColumn(0).setWidth(iNewWidth);
        }
    }

    public void removeRange(IpRange range) {
        this.filter.removeRange(range);
    }

    public void editRange(IpRange range) {
        new IpFilterEditor(this.azureus_core, this.table.getDisplay(), this.table, range);
        this.noChange = false;
    }

    public void addRange() {
        new IpFilterEditor(this.azureus_core, this.table.getDisplay(), this.table, null);
    }

    public void refresh() {
        if (this.table == null || this.table.isDisposed() || this.noChange) {
            return;
        }
        this.noChange = true;
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && !items[i].isDisposed()) {
                String tmp = items[i].getText(0);
                IpRange range = (IpRange)items[i].getData();
                String desc = range.getDescription();
                if (desc != null && !desc.equals(tmp)) {
                    items[i].setText(0, desc);
                }
                tmp = items[i].getText(1);
                if (range.getStartIp() != null && !range.getStartIp().equals(tmp)) {
                    items[i].setText(1, range.getStartIp());
                }
                tmp = items[i].getText(2);
                if (range.getEndIp() != null && !range.getEndIp().equals(tmp)) {
                    items[i].setText(2, range.getEndIp());
                }
            }
            ++i;
        }
    }

    protected IpRange[] getSortedRanges(IpRange[] ranges) {
        Arrays.sort(ranges, this.comparator);
        return ranges;
    }

    protected void setPercentageBlocked() {
        long nbIPsBlocked = this.filter.getTotalAddressesInRange();
        if (COConfigurationManager.getBooleanParameter("Ip Filter Allow")) {
            nbIPsBlocked = 0x100000000L - nbIPsBlocked;
        }
        int percentIPsBlocked = (int)(nbIPsBlocked * 1000L / 0x100000000L);
        String nbIps = "" + nbIPsBlocked;
        String percentIps = DisplayFormatters.formatPercentFromThousands(percentIPsBlocked);
        Messages.setLanguageText((Widget)this.percentage_blocked, "ConfigView.section.ipfilter.totalIPs", new String[]{nbIps, percentIps});
    }

    class FilterComparator
    implements Comparator {
        boolean ascending = true;
        static final int FIELD_NAME = 0;
        static final int FIELD_START_IP = 1;
        static final int FIELD_END_IP = 2;
        int field = 1;

        FilterComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            IpRange range0 = (IpRange)arg0;
            IpRange range1 = (IpRange)arg1;
            if (this.field == 0) {
                return (this.ascending ? 1 : -1) * range0.compareDescription(range1);
            }
            if (this.field == 1) {
                return (this.ascending ? 1 : -1) * range0.compareStartIpTo(range1);
            }
            if (this.field == 2) {
                return (this.ascending ? 1 : -1) * range0.compareEndIpTo(range1);
            }
            return 0;
        }

        public void setField(int newField) {
            if (this.field == newField) {
                this.ascending = !this.ascending;
            }
            this.field = newField;
        }
    }
}

