/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.files.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FirstPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ModeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PieceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ProgressGraphItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RemainingPiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.SizeItem;

public class FilesView
extends TableView {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new SizeItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem()};
    private DownloadManager manager;
    public static boolean show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path", false);
    private MenuItem path_item;

    public FilesView(DownloadManager manager) {
        super("Files", "FilesView", basicItems, "firstpiece", 65538);
        this.bSkipFirstColumn = true;
        this.ptIconSize = new Point(16, 16);
        this.manager = manager;
    }

    public void initialize(Composite composite) {
        super.initialize(composite);
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)FilesView.this.getFirstSelectedDataSource();
                if (fileInfo2 != null && fileInfo2.getAccessMode() == 1) {
                    Program.launch((String)(String.valueOf(fileInfo2.getPath()) + fileInfo2.getName()));
                }
            }
        });
    }

    public void fillMenu(Menu menu) {
        final MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemOpen, "FilesView.menu.open");
        itemOpen.setImage(ImageRepository.getImage("run"));
        final MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu((Decorations)this.getComposite().getShell(), 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        Messages.setLanguageText((Widget)itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        Messages.setLanguageText((Widget)itemLow, "FilesView.menu.setpriority.normal");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        Messages.setLanguageText((Widget)itemSkipped, "FilesView.menu.setpriority.skipped");
        menu.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Object[] infos = FilesView.this.getSelectedDataSources();
                if (infos.length == 0) {
                    itemOpen.setEnabled(false);
                    itemPriority.setEnabled(false);
                    return;
                }
                itemOpen.setEnabled(false);
                itemPriority.setEnabled(true);
                boolean open = true;
                int i = 0;
                while (i < infos.length) {
                    DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)infos[i];
                    if (fileInfo2.getAccessMode() != 1) {
                        open = false;
                    }
                    ++i;
                }
                itemOpen.setEnabled(open);
            }
        });
        itemOpen.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                if (fileInfo2.getAccessMode() == 1) {
                    Program.launch((String)(String.valueOf(fileInfo2.getPath()) + fileInfo2.getName()));
                }
            }
        });
        itemHigh.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                fileInfo2.setPriority(true);
                fileInfo2.setSkipped(false);
            }
        });
        itemLow.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                fileInfo2.setPriority(false);
                fileInfo2.setSkipped(false);
            }
        });
        itemSkipped.addListener(13, (Listener)new TableView.SelectedTableRowsListener(this){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                fileInfo2.setSkipped(true);
            }
        });
        new MenuItem(menu, 2);
        super.fillMenu(menu);
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.removeInvalidFileItems();
        DiskManager diskManager = this.manager.getDiskManager();
        if (diskManager == null) {
            return;
        }
        DiskManagerFileInfo[] files = diskManager.getFiles();
        if (files != null && this.getTable().getItemCount() != files.length) {
            int i = 0;
            while (i < files.length) {
                if (files[i] != null) {
                    this.addDataSource(files[i]);
                }
                ++i;
            }
        }
        super.refresh();
    }

    private void removeInvalidFileItems() {
        DiskManager diskManager = this.manager.getDiskManager();
        final DiskManagerFileInfo[] files = diskManager != null ? diskManager.getFiles() : null;
        this.runForAllRows(new TableView.GroupTableRowRunner(this){

            public void run(TableRowCore row) {
                DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)row.getDataSource(true);
                if (fileInfo2 != null && !FilesView.this.containsFileInfo(files, fileInfo2)) {
                    FilesView.this.removeDataSource(fileInfo2);
                }
            }
        });
    }

    private boolean containsFileInfo(DiskManagerFileInfo[] files, DiskManagerFileInfo file) {
        if (files == null || file == null) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i] == file) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("path")) {
            this.path_item = new MenuItem(menuThisColumn, 32);
            menuThisColumn.addListener(22, new Listener(){

                public void handleEvent(Event e) {
                    FilesView.this.path_item.setSelection(show_full_path);
                }
            });
            Messages.setLanguageText((Widget)this.path_item, "FilesView.fullpath");
            this.path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    show_full_path = FilesView.this.path_item.getSelection();
                    FilesView.this.forceFullRefresh();
                    COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                }
            });
        }
    }

    private void forceFullRefresh() {
        super.tableInvalidate();
        super.refresh();
    }
}

