/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWInstallModePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWListPanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class IPWListPanel
extends AbstractWizardPanel {
    Table pluginList;

    public IPWListPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("installPluginsWizard.list.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        final Label lblStatus = new Label(panel, 0);
        GridData data = new GridData(768);
        lblStatus.setLayoutData((Object)data);
        Messages.setLanguageText((Widget)lblStatus, "installPluginsWizard.list.loading");
        this.pluginList = new Table(panel, 68132);
        this.pluginList.setHeaderVisible(true);
        data = new GridData(768);
        data.heightHint = 120;
        this.pluginList.setLayoutData((Object)data);
        TableColumn tcName = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcName, "installPluginsWizard.list.name");
        tcName.setWidth(200);
        TableColumn tcVersion = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcVersion, "installPluginsWizard.list.version");
        tcVersion.setWidth(150);
        Label lblDescription = new Label(panel, 0);
        Messages.setLanguageText((Widget)lblDescription, "installPluginsWizard.list.description");
        final StyledText txtDescription = new StyledText(panel, 2824);
        txtDescription.setWordWrap(true);
        txtDescription.setEditable(false);
        data = new GridData(768);
        data.heightHint = 100;
        txtDescription.setLayoutData((Object)data);
        AEThread listLoader = new AEThread("Plugin List Loader"){

            public void runSupport() {
                StandardPlugin[] plugins;
                try {
                    plugins = IPWListPanel.this.wizard.getAzureusCore().getPluginManager().getPluginInstaller().getStandardPlugins();
                    Arrays.sort(plugins, new Comparator(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public int compare(Object o1, Object o2) {
                            return ((StandardPlugin)o1).getName().compareTo(((StandardPlugin)o2).getName());
                        }
                    });
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(this, txtDescription, e){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ StyledText val$txtDescription;
                        private final /* synthetic */ Exception val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$txtDescription = styledText;
                            this.val$e = exception;
                        }

                        public void runSupport() {
                            this.val$txtDescription.setText(Debug.getNestedExceptionMessage(this.val$e));
                        }
                    });
                    return;
                }
                IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(this, lblStatus, plugins){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Label val$lblStatus;
                    private final /* synthetic */ StandardPlugin[] val$plugins;
                    {
                        this.this$1 = var1_1;
                        this.val$lblStatus = label;
                        this.val$plugins = standardPluginArray;
                    }

                    public void runSupport() {
                        Messages.setLanguageText((Widget)this.val$lblStatus, "installPluginsWizard.list.loaded");
                        List selected_plugins = ((InstallPluginWizard)IPWListPanel.access$0(1.access$0(this.this$1))).getPluginList();
                        int i = 0;
                        while (i < this.val$plugins.length) {
                            StandardPlugin plugin = this.val$plugins[i];
                            if (plugin.getAlreadyInstalledPlugin() == null) {
                                if (1.access$0(this.this$1).pluginList == null || 1.access$0(this.this$1).pluginList.isDisposed()) {
                                    return;
                                }
                                TableItem item = new TableItem(1.access$0(this.this$1).pluginList, 0);
                                item.setData((Object)plugin);
                                item.setText(0, plugin.getName());
                                boolean selected = false;
                                int j = 0;
                                while (j < selected_plugins.size()) {
                                    if (((StandardPlugin)selected_plugins.get(j)).getId() == plugin.getId()) {
                                        selected = true;
                                    }
                                    ++j;
                                }
                                item.setChecked(selected);
                                item.setText(1, plugin.getVersion());
                            }
                            ++i;
                        }
                    }
                });
            }

            static /* synthetic */ IPWListPanel access$0(1 var0) {
                return var0.IPWListPanel.this;
            }
        };
        listLoader.setDaemon(true);
        listLoader.start();
        this.pluginList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (IPWListPanel.this.pluginList.getSelectionCount() > 0) {
                    txtDescription.setText(MessageText.getString("installPluginsWizard.details.loading"));
                    TableItem itemSelected = IPWListPanel.this.pluginList.getSelection()[0];
                    StandardPlugin plugin = (StandardPlugin)itemSelected.getData();
                    AEThread detailsLoader = new AEThread(this, "Detail Loader", plugin, itemSelected, txtDescription){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ StandardPlugin val$plugin;
                        private final /* synthetic */ TableItem val$itemSelected;
                        private final /* synthetic */ StyledText val$txtDescription;
                        {
                            this.this$1 = var1_1;
                            this.val$plugin = standardPlugin;
                            this.val$itemSelected = tableItem;
                            this.val$txtDescription = styledText;
                            super($anonymous0);
                        }

                        public void runSupport() {
                            String description = HTMLUtils.convertListToString(HTMLUtils.convertHTMLToText(this.val$plugin.getDescription(), ""));
                            IPWListPanel.access$0(5.access$0(this.this$1)).getDisplay().asyncExec((Runnable)new AERunnable(this, this.val$itemSelected, this.val$txtDescription, description){
                                final /* synthetic */ 6 this$2;
                                private final /* synthetic */ TableItem val$itemSelected;
                                private final /* synthetic */ StyledText val$txtDescription;
                                private final /* synthetic */ String val$description;
                                {
                                    this.this$2 = var1_1;
                                    this.val$itemSelected = tableItem;
                                    this.val$txtDescription = styledText;
                                    this.val$description = string;
                                }

                                public void runSupport() {
                                    if (5.access$0(6.access$0(this.this$2)).pluginList == null || 5.access$0(6.access$0(this.this$2)).pluginList.isDisposed() || 5.access$0(6.access$0(this.this$2)).pluginList.getSelectionCount() == 0) {
                                        return;
                                    }
                                    if (5.access$0(6.access$0(this.this$2)).pluginList.getSelection()[0] != this.val$itemSelected) {
                                        return;
                                    }
                                    if (this.val$txtDescription == null || this.val$txtDescription.isDisposed()) {
                                        return;
                                    }
                                    this.val$txtDescription.setText(this.val$description);
                                }
                            });
                        }

                        static /* synthetic */ 5 access$0(6 var0) {
                            return var0.this$1;
                        }
                    };
                    detailsLoader.setDaemon(true);
                    detailsLoader.start();
                }
                IPWListPanel.this.updateList();
            }

            static /* synthetic */ IPWListPanel access$0(5 var0) {
                return var0.IPWListPanel.this;
            }
        });
    }

    public boolean isNextEnabled() {
        return ((InstallPluginWizard)this.wizard).getPluginList().size() > 0;
    }

    public boolean isFinishEnabled() {
        return false;
    }

    public IWizardPanel getNextPanel() {
        return new IPWInstallModePanel(this.wizard, this);
    }

    public void updateList() {
        ArrayList<Object> list = new ArrayList<Object>();
        TableItem[] items = this.pluginList.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                list.add(items[i].getData());
            }
            ++i;
        }
        ((InstallPluginWizard)this.wizard).setPluginList(list);
        ((InstallPluginWizard)this.wizard).setNextEnabled(this.isNextEnabled());
    }
}

