/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.maketorrent.DirectoryPanel;
import org.gudy.azureus2.ui.swt.maketorrent.ModePanel;
import org.gudy.azureus2.ui.swt.maketorrent.SingleFilePanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class NewTorrentWizard
extends Wizard {
    static String default_open_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.open", "");
    static String default_save_dir = COConfigurationManager.getStringParameter("CreateTorrent.default.save", "");
    boolean create_from_dir;
    String singlePath = "";
    String directoryPath = "";
    String savePath = "";
    String comment = "";
    boolean localTracker = true;
    String trackerURL = "http://";
    boolean computed_piece_size = true;
    long manual_piece_size;
    boolean useMultiTracker = false;
    boolean addOtherHashes = true;
    String multiTrackerConfig = "";
    List trackers = new ArrayList();
    boolean autoOpen = false;
    TOTorrentCreator creator = null;

    static {
        if (default_save_dir.length() == 0) {
            default_save_dir = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory", "");
        }
    }

    public NewTorrentWizard(AzureusCore azureus_core, Display display) {
        super(azureus_core, display, "wizard.title");
        this.cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (NewTorrentWizard.this.creator != null) {
                    NewTorrentWizard.this.creator.cancel();
                }
            }
        });
        this.trackers.add(new ArrayList());
        this.trackerURL = Utils.getLinkFromClipboard(display);
        ModePanel panel = new ModePanel(this, null);
        this.setFirstPanel(panel);
        this.createDropTarget((Control)this.getWizardWindow());
    }

    protected String getDefaultOpenDir() {
        return default_open_dir;
    }

    protected void setDefaultOpenDir(String d) {
        default_open_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.open", default_open_dir);
    }

    protected String getDefaultSaveDir() {
        return default_save_dir;
    }

    protected void setDefaultSaveDir(String d) {
        default_save_dir = d;
        COConfigurationManager.setParameter("CreateTorrent.default.save", default_save_dir);
    }

    void setComment(String s) {
        this.comment = s;
    }

    String getComment() {
        return this.comment;
    }

    private void createDropTarget(Control control) {
        DropTarget dropTarget = new DropTarget(control, 23);
        dropTarget.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                if (URLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    event.detail = NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel ? 4 : 0;
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String[]) {
                    String[] sourceNames = (String[])event.data;
                    if (sourceNames == null || sourceNames.length != 1) {
                        event.detail = 0;
                    }
                    if (event.detail == 0) {
                        return;
                    }
                    File droppedFile = new File(sourceNames[0]);
                    if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) {
                        if (droppedFile.isFile()) {
                            NewTorrentWizard.this.singlePath = droppedFile.getAbsolutePath();
                            ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).activateMode(true);
                        } else if (droppedFile.isDirectory()) {
                            NewTorrentWizard.this.directoryPath = droppedFile.getAbsolutePath();
                            ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).activateMode(false);
                        }
                    } else if (NewTorrentWizard.this.getCurrentPanel() instanceof DirectoryPanel) {
                        if (droppedFile.isDirectory()) {
                            ((DirectoryPanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                        }
                    } else if (NewTorrentWizard.this.getCurrentPanel() instanceof SingleFilePanel && droppedFile.isFile()) {
                        ((SingleFilePanel)NewTorrentWizard.this.getCurrentPanel()).setFilename(droppedFile.getAbsolutePath());
                    }
                } else if (NewTorrentWizard.this.getCurrentPanel() instanceof ModePanel) {
                    NewTorrentWizard.this.trackerURL = ((URLTransfer.URLType)event.data).linkURL;
                    ((ModePanel)NewTorrentWizard.this.getCurrentPanel()).updateTrackerURL();
                }
            }
        });
    }

    protected void setPieceSizeComputed() {
        this.computed_piece_size = true;
    }

    public boolean getPieceSizeComputed() {
        return this.computed_piece_size;
    }

    protected void setPieceSizeManual(long _value) {
        this.computed_piece_size = false;
        this.manual_piece_size = _value;
    }

    protected long getPieceSizeManual() {
        return this.manual_piece_size;
    }

    protected boolean getAddHashes() {
        return this.addOtherHashes;
    }
}

