/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class StringParameter
extends Parameter {
    String name;
    Text inputField;

    public StringParameter(Composite composite, String name) {
        this(composite, name, COConfigurationManager.getStringParameter(name));
    }

    public StringParameter(Composite composite, final String name, String defaultValue) {
        this.name = name;
        this.inputField = new Text(composite, 2048);
        String value = COConfigurationManager.getStringParameter(name, defaultValue);
        this.inputField.setText(value);
        this.inputField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                COConfigurationManager.setParameter(name, StringParameter.this.inputField.getText());
            }
        });
    }

    public void setLayoutData(Object layoutData) {
        this.inputField.setLayoutData(layoutData);
    }

    public void setValue(String value) {
        if (this.inputField == null || this.inputField.isDisposed()) {
            return;
        }
        this.inputField.setText(value);
        COConfigurationManager.setParameter(this.name, value);
    }

    public String getValue() {
        return this.inputField.getText();
    }

    public Control getControl() {
        return this.inputField;
    }
}

