/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.images;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Utils {
    public static Image renderTransparency(Display display, Image background, Image foreground) {
        Rectangle r2;
        if (display == null || display.isDisposed() || background == null || background.isDisposed() || foreground == null || foreground.isDisposed()) {
            return null;
        }
        Rectangle r1 = background.getBounds();
        if (!r1.equals((Object)(r2 = foreground.getBounds()))) {
            return null;
        }
        Image image = new Image((Device)display, r1);
        ImageData backData = background.getImageData();
        ImageData foreData = foreground.getImageData();
        ImageData imgData = image.getImageData();
        int y = 0;
        while (y < foreData.height) {
            int x = 0;
            while (x < foreData.width) {
                int cBack = backData.getPixel(x, y);
                int cFore = foreData.getPixel(x, y);
                int aFore = foreData.getAlpha(x, y);
                int rBack = cBack & 0xFF;
                int gBack = cBack >> 8 & 0xFF;
                int bBack = cBack >> 16 & 0xFF;
                int rFore = cFore & 0xFF;
                int gFore = cFore >> 8 & 0xFF;
                int bFore = cFore >> 16 & 0xFF;
                int r = (rBack * aFore + (255 - aFore) * rFore) / 255;
                int g = (gBack * aFore + (255 - aFore) * gFore) / 255;
                int b = (bBack * aFore + (255 - aFore) * bFore) / 255;
                int color = (r &= 0xFF) + (g &= 0xFF) << 8 + (b &= 0xFF) << 16;
                imgData.setPixel(x, y, color);
                ++x;
            }
            ++y;
        }
        return image;
    }
}

