/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.ui.swt.components.graphics.Graphic;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BackGroundGraphic
implements Graphic {
    protected Canvas drawCanvas;
    protected Image bufferBackground;
    protected Color lightGrey;
    protected Color lightGrey2;
    protected AEMonitor this_mon = new AEMonitor("BackGroundGraphic");

    public void initialize(Canvas canvas) {
        this.drawCanvas = canvas;
        this.lightGrey = new Color((Device)canvas.getDisplay(), 250, 250, 250);
        this.lightGrey2 = new Color((Device)canvas.getDisplay(), 233, 233, 233);
    }

    public void refresh() {
    }

    protected void drawBackGround(boolean sizeChanged) {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        if (sizeChanged || this.bufferBackground == null) {
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.height < 30 || bounds.width < 100) {
                return;
            }
            if (this.bufferBackground != null && !this.bufferBackground.isDisposed()) {
                this.bufferBackground.dispose();
            }
            if (bounds.width > 2000 || bounds.height > 2000) {
                return;
            }
            this.bufferBackground = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            Color[] colors = new Color[]{Colors.white, this.lightGrey, this.lightGrey2, this.lightGrey};
            GC gcBuffer = new GC((Drawable)this.bufferBackground);
            int i = 0;
            while (i < bounds.height - 2) {
                gcBuffer.setForeground(colors[i % 4]);
                gcBuffer.drawLine(1, i + 1, bounds.width - 1, i + 1);
                ++i;
            }
            gcBuffer.setForeground(Colors.black);
            gcBuffer.drawLine(bounds.width - 70, 0, bounds.width - 70, bounds.height - 1);
            gcBuffer.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            gcBuffer.dispose();
        }
    }

    public void dispose() {
        if (this.bufferBackground != null && !this.bufferBackground.isDisposed()) {
            this.bufferBackground.dispose();
        }
        if (this.lightGrey != null && !this.lightGrey.isDisposed()) {
            this.lightGrey.dispose();
        }
        if (this.lightGrey2 != null && !this.lightGrey2.isDisposed()) {
            this.lightGrey2.dispose();
        }
    }
}

