/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.ipfilter;

import java.io.File;
import org.gudy.azureus2.plugins.ipfilter.IPBlocked;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPFilterException;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.ipfilter.RPIPRange;

public class RPIPFilter
extends RPObject
implements IPFilter {
    protected transient IPFilter delegate;
    public long last_update_time;
    public int number_of_ranges;
    public int number_of_blocked_ips;

    public static IPFilter create(IPFilter _delegate) {
        RPIPFilter res = (RPIPFilter)RPObject._lookupLocal(_delegate);
        if (res == null) {
            res = new RPIPFilter(_delegate);
        }
        return res;
    }

    protected RPIPFilter(IPFilter _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (IPFilter)_delegate;
        this.last_update_time = this.delegate.getLastUpdateTime();
        this.number_of_ranges = this.delegate.getNumberOfRanges();
        this.number_of_blocked_ips = this.delegate.getNumberOfBlockedIPs();
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("createAndAddRange[String,String,String,boolean]")) {
            IPRange range = this.delegate.createAndAddRange((String)params[0], (String)params[1], (String)params[2], (Boolean)params[3]);
            if (range == null) {
                return new RPReply(null);
            }
            RPIPRange rp_range = RPIPRange.create(range);
            return new RPReply(rp_range);
        }
        if (method.equals("getRanges")) {
            IPRange[] ranges = this.delegate.getRanges();
            RPIPRange[] rp_ranges = new RPIPRange[ranges.length];
            int i = 0;
            while (i < ranges.length) {
                rp_ranges[i] = RPIPRange.create(ranges[i]);
                ++i;
            }
            return new RPReply(rp_ranges);
        }
        if (method.equals("save")) {
            try {
                this.delegate.save();
                return null;
            }
            catch (IPFilterException e) {
                return new RPReply(e);
            }
        }
        if (method.equals("getInRangeAddressesAreAllowed")) {
            return new RPReply(new Boolean(this.delegate.getInRangeAddressesAreAllowed()));
        }
        if (method.equals("setInRangeAddressesAreAllowed[boolean]")) {
            this.delegate.setInRangeAddressesAreAllowed((Boolean)params[0]);
            return null;
        }
        if (method.equals("isEnabled")) {
            return new RPReply(new Boolean(this.delegate.isEnabled()));
        }
        if (method.equals("setEnabled[boolean]")) {
            this.delegate.setEnabled((Boolean)params[0]);
            return null;
        }
        if (method.equals("isInRange[String]")) {
            return new RPReply(new Boolean(this.delegate.isInRange((String)params[0])));
        }
        throw new RPException("Unknown method: " + method);
    }

    public File getFile() {
        this.notSupported();
        return null;
    }

    public IPRange createRange(boolean this_session_only) {
        this.notSupported();
        return null;
    }

    public void addRange(IPRange range) {
        this.notSupported();
    }

    public IPRange createAndAddRange(String description, String start_ip, String end_ip, boolean this_session_only) {
        RPIPRange resp = (RPIPRange)this._dispatcher.dispatch(new RPRequest(this, "createAndAddRange[String,String,String,boolean]", new Object[]{description, start_ip, end_ip, new Boolean(this_session_only)})).getResponse();
        resp._setRemote(this._dispatcher);
        return resp;
    }

    public void removeRange(IPRange range) {
        this.notSupported();
    }

    public void reload() throws IPFilterException {
        this.notSupported();
    }

    public IPRange[] getRanges() {
        IPRange[] resp = (RPIPRange[])this._dispatcher.dispatch(new RPRequest(this, "getRanges", null)).getResponse();
        int i = 0;
        while (i < resp.length) {
            ((RPObject)((Object)resp[i]))._setRemote(this._dispatcher);
            ++i;
        }
        return resp;
    }

    public boolean isInRange(String IPAddress) {
        Boolean res = (Boolean)this._dispatcher.dispatch(new RPRequest(this, "isInRange[String]", new Object[]{IPAddress})).getResponse();
        return res;
    }

    public IPBlocked[] getBlockedIPs() {
        this.notSupported();
        return null;
    }

    public void block(String IPAddress) {
        this.notSupported();
    }

    public boolean getInRangeAddressesAreAllowed() {
        Boolean res = (Boolean)this._dispatcher.dispatch(new RPRequest(this, "getInRangeAddressesAreAllowed", null)).getResponse();
        return res;
    }

    public void setInRangeAddressesAreAllowed(boolean value) {
        this._dispatcher.dispatch(new RPRequest(this, "setInRangeAddressesAreAllowed[boolean]", new Object[]{new Boolean(value)})).getResponse();
    }

    public boolean isEnabled() {
        Boolean res = (Boolean)this._dispatcher.dispatch(new RPRequest(this, "isEnabled", null)).getResponse();
        return res;
    }

    public void setEnabled(boolean value) {
        this._dispatcher.dispatch(new RPRequest(this, "setEnabled[boolean]", new Object[]{new Boolean(value)})).getResponse();
    }

    public void save() throws IPFilterException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "save", null)).getResponse();
        }
        catch (RPException e) {
            if (e.getCause() instanceof IPFilterException) {
                throw (IPFilterException)e.getCause();
            }
            throw e;
        }
    }

    public void markAsUpToDate() {
        this.notSupported();
    }

    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    public int getNumberOfRanges() {
        return this.number_of_ranges;
    }

    public int getNumberOfBlockedIPs() {
        return this.number_of_blocked_ips;
    }
}

