/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderTorrentImpl
extends ResourceDownloaderBaseImpl
implements ResourceDownloaderListener {
    public static final int MAX_FOLLOWS = 1;
    protected ResourceDownloaderBaseImpl delegate;
    protected boolean persistent;
    protected File download_dir;
    protected long size = -2L;
    protected TOTorrent torrent;
    protected DownloadManager download_manager;
    protected Download download;
    protected boolean cancelled;
    protected ResourceDownloader current_downloader;
    protected Object result;
    protected AESemaphore done_sem = new AESemaphore("RDTorrent");

    public ResourceDownloaderTorrentImpl(ResourceDownloaderBaseImpl _parent, ResourceDownloader _delegate, boolean _persistent, File _download_dir) {
        super(_parent);
        this.persistent = _persistent;
        this.download_dir = _download_dir;
        this.delegate = (ResourceDownloaderBaseImpl)_delegate;
        this.delegate.setParent(this);
        this.download_manager = PluginInitializer.getDefaultInterface().getDownloadManager();
    }

    public String getName() {
        return String.valueOf(this.delegate.getName()) + ": torrent";
    }

    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                this.size = this.getSizeSupport();
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
        }
        return this.size;
    }

    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            if (this.torrent == null) {
                ResourceDownloader x = this.delegate.getClone(this);
                this.addReportListener(x);
                this.torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(x.download());
                if (!this.torrent.isSimpleTorrent()) {
                    throw new ResourceDownloaderException("Only simple torrents supported");
                }
            }
            return this.torrent.getSize();
        }
        catch (TOTorrentException e) {
            throw new ResourceDownloaderException("Torrent deserialisation failed", e);
        }
    }

    protected void setSizeAndTorrent(long _size, TOTorrent _torrent) {
        this.size = _size;
        this.torrent = _torrent;
    }

    public ResourceDownloader getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderTorrentImpl c = new ResourceDownloaderTorrentImpl(parent, this.delegate.getClone(this), this.persistent, this.download_dir);
        c.setSizeAndTorrent(this.size, this.torrent);
        return c;
    }

    public InputStream download() throws ResourceDownloaderException {
        this.asyncDownload();
        this.done_sem.reserve();
        if (this.result instanceof InputStream) {
            return (InputStream)this.result;
        }
        throw (ResourceDownloaderException)this.result;
    }

    public void asyncDownload() {
        try {
            this.this_mon.enter();
            if (this.cancelled) {
                this.done_sem.release();
                this.informFailed((ResourceDownloaderException)this.result);
            } else if (this.torrent == null) {
                this.current_downloader = this.delegate.getClone(this);
                this.informActivity(String.valueOf(this.getLogIndent()) + "Downloading: " + this.getName());
                this.current_downloader.addListener(this);
                this.current_downloader.asyncDownload();
            } else {
                this.downloadTorrent();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void downloadTorrent() {
        try {
            this.informActivity(String.valueOf(this.getLogIndent()) + "Downloading: " + new String(this.torrent.getName(), "UTF8"));
            final File torrent_file = File.createTempFile("AZU", null);
            if (this.download_dir != null && !this.download_dir.exists()) {
                this.download_dir.mkdirs();
            }
            final File data_dir = this.download_dir == null ? torrent_file.getParentFile() : this.download_dir;
            this.torrent.serialiseToBEncodedFile(torrent_file);
            this.download = this.persistent ? this.download_manager.addDownload(new TorrentImpl(this.torrent), torrent_file, data_dir) : this.download_manager.addNonPersistentDownload(new TorrentImpl(this.torrent), torrent_file, data_dir);
            this.download.setPosition(1);
            this.download.setForceStart(true);
            this.download_manager.addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                }

                public void downloadRemoved(Download _download) {
                    if (ResourceDownloaderTorrentImpl.this.download == _download) {
                        ResourceDownloaderTorrentImpl.this.downloadRemoved(torrent_file, data_dir);
                    }
                }
            });
            this.download.addListener(new DownloadListener(){

                public void stateChanged(Download download, int old_state, int new_state) {
                    if (new_state == 5) {
                        download.removeListener(this);
                        ResourceDownloaderTorrentImpl.this.downloadSucceeded(torrent_file, data_dir);
                    }
                }

                public void positionChanged(Download download, int oldPosition, int newPosition) {
                }
            });
            AEThread t = new AEThread("RDTorrent percentage checker"){

                public void runSupport() {
                    int last_percentage = 0;
                    while (ResourceDownloaderTorrentImpl.this.result == null) {
                        int this_percentage = ResourceDownloaderTorrentImpl.this.download.getStats().getCompleted() / 10;
                        long total = ResourceDownloaderTorrentImpl.this.torrent.getSize();
                        if (this_percentage != last_percentage) {
                            ResourceDownloaderTorrentImpl.this.reportPercentComplete(ResourceDownloaderTorrentImpl.this, this_percentage);
                            last_percentage = this_percentage;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            if (this.download.getState() == 5) {
                this.downloadSucceeded(torrent_file, data_dir);
            }
        }
        catch (Throwable e) {
            this.failed(this, new ResourceDownloaderException("Torrent download failed", e));
        }
    }

    protected void downloadSucceeded(File torrent_file, File data_dir) {
        this.reportActivity("Torrent download complete");
        File target_file = new File(data_dir, new String(this.torrent.getFiles()[0].getPathComponents()[0]));
        if (!target_file.exists() && COConfigurationManager.getBooleanParameter("Move Completed When Done", false)) {
            File moved_target_file = new File(COConfigurationManager.getStringParameter("Completed Files Directory", ""), new String(this.torrent.getFiles()[0].getPathComponents()[0]));
            try {
                if (this.download_dir != null && moved_target_file.exists()) {
                    FileUtil.copyFile(moved_target_file, target_file);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            target_file = moved_target_file;
        }
        try {
            if (!target_file.exists()) {
                throw new Exception("File '" + target_file.toString() + "' not found");
            }
            FileInputStream data = new FileInputStream(target_file);
            this.informComplete(data);
            this.result = data;
            this.done_sem.release();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.failed(this, new ResourceDownloaderException("Failed to read downloaded torrent data: " + e.getMessage(), e));
        }
    }

    protected void downloadRemoved(File torrent_file, File data_dir) {
        this.reportActivity("Torrent removed");
        if (!(this.result instanceof InputStream)) {
            this.failed(this, new ResourceDownloaderException("Download did not complete"));
        }
    }

    public void cancel() {
        this.setCancelled();
        try {
            this.this_mon.enter();
            this.result = new ResourceDownloaderException("Download cancelled");
            this.cancelled = true;
            this.informFailed((ResourceDownloaderException)this.result);
            this.done_sem.release();
            if (this.current_downloader != null) {
                this.current_downloader.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        try {
            this.torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(data);
            if (this.torrent.isSimpleTorrent()) {
                this.downloadTorrent();
            } else {
                this.failed(this, new ResourceDownloaderException("Only simple torrents supported"));
            }
        }
        catch (TOTorrentException e) {
            this.failed(downloader, new ResourceDownloaderException("Torrent deserialisation failed", e));
        }
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.result = e;
        this.done_sem.release();
        this.informFailed(e);
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
        if (downloader == this) {
            this.informPercentDone(percentage);
        }
    }
}

