/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareResourceDirContentsImpl
extends ShareResourceImpl
implements ShareResourceDirContents {
    protected File root;
    protected boolean recursive;
    protected ShareResource[] children;

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive) throws ShareException {
        super(_manager, 3);
        this.root = _dir;
        this.recursive = _recursive;
        if (!this.root.exists()) {
            throw new ShareException("Dir '".concat(this.root.getName()).concat("' not found"));
        }
        if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        this.checkConsistency();
    }

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, Map _map) throws ShareException {
        super(_manager, 3, _map);
        this.root = _dir;
        this.recursive = _recursive;
        if (!this.root.exists()) {
            throw new ShareException("Dir '".concat(this.root.getName()).concat("' not found"));
        }
        if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
    }

    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        int i = 0;
        while (i < this.children.length) {
            this.children[i].canBeDeleted();
            ++i;
        }
        return true;
    }

    protected void checkConsistency() throws ShareException {
        List kids = this.checkConsistency(this.root);
        this.children = new ShareResource[kids.size()];
        kids.toArray(this.children);
    }

    protected List checkConsistency(File dir) throws ShareException {
        ArrayList<ShareResource> kids = new ArrayList<ShareResource>();
        File[] files = dir.listFiles();
        if (files == null) {
            this.manager.delete(this);
        } else {
            ArrayList<ShareResourceFile> new_resources = new ArrayList<ShareResourceFile>();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                String file_name = file.getName();
                if (!file_name.equals(".") && !file_name.equals("..")) {
                    ShareResource res;
                    if (file.isDirectory()) {
                        if (this.recursive) {
                            List child = this.checkConsistency(file);
                            kids.add(new shareNode(file, child));
                        } else {
                            try {
                                res = this.manager.getDir(file);
                                if (res == null) {
                                    res = this.manager.addDir(file);
                                    new_resources.add((ShareResourceFile)res);
                                }
                                kids.add(res);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    } else {
                        try {
                            res = this.manager.getFile(file);
                            if (res == null) {
                                res = this.manager.addFile(file);
                                new_resources.add((ShareResourceFile)res);
                            }
                            kids.add(res);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < kids.size()) {
                Object o = kids.get(i);
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                } else {
                    ((shareNode)o).setParent(this);
                }
                ++i;
            }
            i = 0;
            while (i < new_resources.size()) {
                ((ShareResourceImpl)new_resources.get(i)).inheritAttributes(this);
                ++i;
            }
        }
        return kids;
    }

    protected void deleteInternal() {
        int i = 0;
        while (i < this.children.length) {
            try {
                if (this.children[i] instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)this.children[i]).delete(true);
                } else {
                    ((shareNode)this.children[i]).delete(true);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        map.put("recursive", new Long(this.recursive ? 1 : 0));
        try {
            map.put("file", this.root.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl manager, Map map) throws ShareException {
        try {
            File root = new File(new String((byte[])map.get("file"), "UTF8"));
            boolean recursive = (Long)map.get("recursive") == 1L;
            ShareResourceDirContentsImpl res = new ShareResourceDirContentsImpl(manager, root, recursive, map);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new ShareException("internal error", e);
        }
    }

    public String getName() {
        return this.root.toString();
    }

    public File getRoot() {
        return this.root;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public ShareResource[] getChildren() {
        return this.children;
    }

    protected class shareNode
    implements ShareResourceDirContents {
        protected ShareResourceDirContents node_parent;
        protected File node;
        protected ShareResource[] node_children;

        protected shareNode(File _node, List kids) {
            this.node = _node;
            this.node_children = new ShareResource[kids.size()];
            kids.toArray(this.node_children);
            int i = 0;
            while (i < this.node_children.length) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                } else {
                    ((shareNode)o).setParent(this);
                }
                ++i;
            }
        }

        public ShareResourceDirContents getParent() {
            return this.node_parent;
        }

        protected void setParent(ShareResourceDirContents _parent) {
            this.node_parent = _parent;
        }

        public int getType() {
            return 3;
        }

        public String getName() {
            return this.node.toString();
        }

        public void setAttribute(TorrentAttribute attribute, String value) {
        }

        public String getAttribute(TorrentAttribute attribute) {
            return null;
        }

        public TorrentAttribute[] getAttributes() {
            return new TorrentAttribute[0];
        }

        public void delete() throws ShareResourceDeletionVetoException {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }

        protected void delete(boolean force) throws ShareException, ShareResourceDeletionVetoException {
            int i = 0;
            while (i < this.node_children.length) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).delete(force);
                } else {
                    ((shareNode)o).delete(force);
                }
                ++i;
            }
        }

        public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
            int i = 0;
            while (i < this.node_children.length) {
                this.node_children[i].canBeDeleted();
                ++i;
            }
            return true;
        }

        public File getRoot() {
            return this.node;
        }

        public boolean isRecursive() {
            return ShareResourceDirContentsImpl.this.recursive;
        }

        public ShareResource[] getChildren() {
            return this.node_children;
        }

        public void addChangeListener(ShareResourceListener l) {
        }

        public void removeChangeListener(ShareResourceListener l) {
        }

        public void addDeletionListener(ShareResourceWillBeDeletedListener l) {
        }

        public void removeDeletionListener(ShareResourceWillBeDeletedListener l) {
        }
    }
}

