/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import java.util.List;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerImpl
implements Peer {
    protected PeerManager manager;
    protected PEPeer delegate;
    protected AEMonitor this_mon = new AEMonitor("Peer");

    public PeerImpl(PEPeer _delegate) {
        this.delegate = _delegate;
        this.manager = PeerManagerImpl.getPeerManager(this.delegate.getManager());
    }

    public PeerManager getManager() {
        return this.manager;
    }

    public int getState() {
        int state = this.delegate.getState();
        switch (state) {
            case 10: {
                return 10;
            }
            case 50: {
                return 40;
            }
            case 20: {
                return 20;
            }
            case 30: {
                return 30;
            }
        }
        return -1;
    }

    public byte[] getId() {
        return this.delegate.getId();
    }

    public String getIp() {
        return this.delegate.getIp();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public boolean[] getAvailable() {
        return this.delegate.getAvailable();
    }

    public boolean isChoked() {
        return this.delegate.isChokingMe();
    }

    public boolean isChoking() {
        return this.delegate.isChokedByMe();
    }

    public boolean isInterested() {
        return this.delegate.isInterestingToMe();
    }

    public boolean isInteresting() {
        return this.delegate.isInterestedInMe();
    }

    public boolean isSeed() {
        return this.delegate.isSeed();
    }

    public boolean isSnubbed() {
        return this.delegate.isSnubbed();
    }

    public void setSnubbed(boolean b) {
        this.delegate.setSnubbed(b);
    }

    public PeerStats getStats() {
        return new PeerStatsImpl(((PeerManagerImpl)this.manager).getDelegate(), this.delegate.getStats());
    }

    public boolean isIncoming() {
        return this.delegate.isIncoming();
    }

    public int getPercentDone() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    public String getClient() {
        return this.delegate.getClient();
    }

    public boolean isOptimisticUnchoke() {
        return this.delegate.isOptimisticUnchoke();
    }

    public int getNumberOfBadChunks() {
        return this.delegate.getNbBadChunks();
    }

    public void hasSentABadChunk() {
        this.delegate.hasSentABadChunk();
    }

    public void resetNbBadChunks() {
        this.delegate.resetNbBadChunks();
    }

    public void initialize() {
        throw new RuntimeException("not supported");
    }

    public List getExpiredRequests() {
        throw new RuntimeException("not supported");
    }

    public int getNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    public void cancelRequest(DiskManagerRequest request2) {
        throw new RuntimeException("not supported");
    }

    public boolean addRequest(int pieceNumber, int pieceOffset, int pieceLength) {
        throw new RuntimeException("not supported");
    }

    public void close(String reason, boolean closedOnError, boolean attemptReconnect) {
        throw new RuntimeException("not supported");
    }

    public void addListener(PeerListener l) {
    }

    public void removeListener(PeerListener l) {
    }
}

