/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.logging;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class LoggerChannelImpl
implements LoggerChannel {
    protected String name;
    protected List listeners = new ArrayList();

    protected LoggerChannelImpl(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    public void log(int log_type, String data) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(log_type, data);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        data = "[".concat(this.name).concat("] ").concat(data);
        if (log_type == 1) {
            LGLogger.log(0, data);
        } else if (log_type == 2) {
            LGLogger.log(1, data);
        } else if (log_type == 3) {
            LGLogger.log(3, data);
        }
    }

    public void log(String data) {
        this.log(1, data);
    }

    public void log(Throwable error) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged("", error);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        LGLogger.log("[".concat(this.name).concat("]"), error);
    }

    public void log(String str, Throwable error) {
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                ((LoggerChannelListener)this.listeners.get(i)).messageLogged(str, error);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        LGLogger.log("[".concat(this.name).concat("] ").concat(str), error);
    }

    protected void logAlert(int alert_type, String message, boolean repeatable) {
        int at;
        switch (alert_type) {
            case 1: {
                at = 0;
                break;
            }
            case 2: {
                at = 1;
                break;
            }
            default: {
                at = 3;
            }
        }
        if (repeatable) {
            LGLogger.logRepeatableAlert(at, message);
        } else {
            LGLogger.logUnrepeatableAlert(at, message);
        }
    }

    public void logAlert(int alert_type, String message) {
        this.logAlert(alert_type, message, false);
    }

    public void logAlertRepeatable(int alert_type, String message) {
        this.logAlert(alert_type, message, true);
    }

    public void logAlert(String message, Throwable e) {
        LGLogger.logUnrepeatableAlert(message, e);
    }

    public void logAlertRepeatable(String message, Throwable e) {
        LGLogger.logRepeatableAlert(message, e);
    }

    public void addListener(LoggerChannelListener l) {
        this.listeners.add(l);
    }

    public void removeListener(LoggerChannelListener l) {
        this.listeners.remove(l);
    }
}

