/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerRequestImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;

public class DiskManagerImpl
implements DiskManager {
    protected PeerManagerImpl peer_manager;
    protected Map map = new WeakHashMap();

    public DiskManagerImpl(PeerManagerImpl _peer_manager) {
        this.peer_manager = _peer_manager;
    }

    public DiskManagerRequest createRequest(int pieceNumber, int offset, int length) {
        DiskManagerRequestImpl res = new DiskManagerRequestImpl(this.peer_manager.getDelegate(), pieceNumber, offset, length);
        this.map.put(res.getDelegate(), res);
        return res;
    }

    public DiskManagerRequest lookupRequest(DiskManagerReadRequest r) {
        return (DiskManagerRequest)this.map.get(r);
    }

    public boolean checkBlock(int pieceNumber, int offset, ByteBuffer data) {
        return this.peer_manager.getDelegate().checkBlock(pieceNumber, offset, new DirectByteBuffer(data));
    }

    public void writeBlock(int pieceNumber, int offset, ByteBuffer data, Peer sender) {
        this.peer_manager.getDelegate().writeBlock(pieceNumber, offset, new DirectByteBuffer(data), this.peer_manager.mapForeignPeer(sender));
    }
}

