/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DirectByteBufferPool {
    protected static final boolean DEBUG_TRACK_HANDEDOUT = false;
    protected static final boolean DEBUG_PRINT_MEM = false;
    protected static final int DEBUG_PRINT_TIME = 300000;
    private static final int START_POWER = 12;
    private static final int END_POWER = 25;
    private static final int[] EXTRA_BUCKETS = new int[]{128, 16512};
    public static final int MAX_SIZE = BigInteger.valueOf(2L).pow(25).intValue();
    private static final DirectByteBufferPool pool = new DirectByteBufferPool();
    private final Map buffersMap = new LinkedHashMap(14);
    private final Object poolsLock = new Object();
    private final Timer compactionTimer;
    private final Map handed_out = new IdentityHashMap();
    private static final long COMPACTION_CHECK_PERIOD = 600000L;
    private static final long MAX_FREE_BYTES = 0xA00000L;
    private long bytesIn = 0L;
    private long bytesOut = 0L;

    private DirectByteBufferPool() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int p = 12;
        while (p <= 25) {
            list.add(new Integer(BigInteger.valueOf(2L).pow(p).intValue()));
            ++p;
        }
        int i = 0;
        while (i < EXTRA_BUCKETS.length) {
            list.add(new Integer(EXTRA_BUCKETS[i]));
            ++i;
        }
        Object[] sizes = new Integer[list.size()];
        list.toArray(sizes);
        Arrays.sort(sizes);
        int i2 = 0;
        while (i2 < sizes.length) {
            ArrayList bufferPool = new ArrayList();
            this.buffersMap.put(sizes[i2], bufferPool);
            ++i2;
        }
        this.compactionTimer = new Timer("BufferPool Checker");
        this.compactionTimer.addPeriodicEvent(600000L, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                DirectByteBufferPool.this.checkMemoryUsage();
            }
        });
    }

    private ByteBuffer allocateNewBuffer(int _size) {
        try {
            return ByteBuffer.allocateDirect(_size);
        }
        catch (OutOfMemoryError e) {
            this.clearBufferPools();
            this.runGarbageCollection();
            try {
                return ByteBuffer.allocateDirect(_size);
            }
            catch (OutOfMemoryError ex) {
                String msg = "Memory allocation failed: Out of direct memory space.\nTo fix: Use the -XX:MaxDirectMemorySize=512m command line option,\nor upgrade your Java JRE to version 1.4.2_05 or 1.5 series or newer.";
                Debug.out(msg);
                LGLogger.logUnrepeatableAlert(3, msg);
                this.printInUse(true);
                throw ex;
            }
        }
    }

    public static DirectByteBuffer getBuffer(byte _allocator, int _length) {
        if (_length < 1) {
            Debug.out("requested length [" + _length + "] < 1");
            return null;
        }
        if (_length > MAX_SIZE) {
            Debug.out("requested length [" + _length + "] > MAX_SIZE [" + MAX_SIZE + "]");
            return null;
        }
        return pool.getBufferHelper(_allocator, _length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectByteBuffer getBufferHelper(byte _allocator, int _length) {
        Integer reqVal = new Integer(_length);
        Iterator it = this.buffersMap.keySet().iterator();
        while (it.hasNext()) {
            ByteBuffer buff;
            Integer keyVal = (Integer)it.next();
            if (reqVal.compareTo(keyVal) > 0) continue;
            ArrayList bufferPool = (ArrayList)this.buffersMap.get(keyVal);
            Object object = this.poolsLock;
            synchronized (object) {
                if (bufferPool.isEmpty()) {
                    buff = this.allocateNewBuffer(keyVal);
                } else {
                    ArrayList arrayList = bufferPool;
                    synchronized (arrayList) {
                        buff = (ByteBuffer)bufferPool.remove(bufferPool.size() - 1);
                    }
                }
            }
            buff.clear();
            buff.limit(_length);
            this.bytesOut += (long)buff.capacity();
            DirectByteBuffer dbb = new DirectByteBuffer(_allocator, buff, this);
            return dbb;
        }
        Debug.out("Unable to find an appropriate buffer pool");
        throw new RuntimeException("Unable to find an appropriate buffer pool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free(ByteBuffer _buffer) {
        Integer buffSize = new Integer(_buffer.capacity());
        ArrayList bufferPool = (ArrayList)this.buffersMap.get(buffSize);
        if (bufferPool != null) {
            ArrayList arrayList = bufferPool;
            synchronized (arrayList) {
                bufferPool.add(_buffer);
            }
        } else {
            Debug.out("Invalid buffer given; could not find proper buffer pool");
        }
    }

    private void clearBufferPools() {
        Iterator it = this.buffersMap.values().iterator();
        while (it.hasNext()) {
            ArrayList bufferPool = (ArrayList)it.next();
            bufferPool.clear();
        }
    }

    private void runGarbageCollection() {
        System.runFinalization();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMemoryUsage() {
        long bytesUsed = 0L;
        Object object = this.poolsLock;
        synchronized (object) {
            Iterator it = this.buffersMap.keySet().iterator();
            while (it.hasNext()) {
                Integer keyVal = (Integer)it.next();
                ArrayList bufferPool = (ArrayList)this.buffersMap.get(keyVal);
                bytesUsed += (long)(keyVal * bufferPool.size());
            }
            if (bytesUsed > 0xA00000L) {
                this.compactFreeBuffers(bytesUsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactFreeBuffers(long bytes_used) {
        int numPools = this.buffersMap.size();
        long bytesToFree = 0L;
        int maxPoolSize = 0;
        int[] buffSizes = new int[numPools];
        int[] poolSizes = new int[numPools];
        int[] numToFree = new int[numPools];
        int pos = 0;
        Iterator<Object> it = this.buffersMap.keySet().iterator();
        while (it.hasNext()) {
            Integer keyVal = (Integer)it.next();
            ArrayList bufferPool = (ArrayList)this.buffersMap.get(keyVal);
            buffSizes[pos] = keyVal;
            poolSizes[pos] = bufferPool.size();
            numToFree[pos] = 0;
            if (poolSizes[pos] > maxPoolSize) {
                maxPoolSize = poolSizes[pos];
            }
            ++pos;
        }
        while (bytesToFree < bytes_used - 0xA00000L) {
            int i = 0;
            while (i < numPools) {
                if (poolSizes[i] == maxPoolSize) {
                    int n = i;
                    numToFree[n] = numToFree[n] + 1;
                    int n2 = i;
                    poolSizes[n2] = poolSizes[n2] - 1;
                    bytesToFree += (long)buffSizes[i];
                }
                ++i;
            }
            --maxPoolSize;
        }
        pos = 0;
        it = this.buffersMap.values().iterator();
        while (it.hasNext()) {
            ArrayList bufferPool;
            ArrayList arrayList = bufferPool = (ArrayList)it.next();
            synchronized (arrayList) {
                int size = bufferPool.size();
                int i = size - 1;
                while (i >= size - numToFree[pos]) {
                    bufferPool.remove(i);
                    --i;
                }
            }
            ++pos;
        }
        this.runGarbageCollection();
    }

    protected void returnBuffer(ByteBuffer buffer) {
        this.bytesIn += (long)buffer.capacity();
        this.free(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long bytesFree() {
        long bytesUsed = 0L;
        Object object = this.poolsLock;
        synchronized (object) {
            Iterator it = this.buffersMap.keySet().iterator();
            while (it.hasNext()) {
                Integer keyVal = (Integer)it.next();
                ArrayList bufferPool = (ArrayList)this.buffersMap.get(keyVal);
                bytesUsed += (long)(keyVal * bufferPool.size());
            }
        }
        return bytesUsed;
    }

    private void printInUse(boolean verbose) {
    }

    protected static class myInteger {
        int value;

        protected myInteger() {
        }
    }
}

