/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class BDecoder {
    Charset byte_charset;
    Charset default_charset;

    private BDecoder() {
        try {
            this.byte_charset = Charset.forName("ISO-8859-1");
            this.default_charset = Charset.forName("UTF8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static Map decode(byte[] data) throws IOException {
        return new BDecoder().decode(new ByteArrayInputStream(data));
    }

    public static Map decode(BufferedInputStream data) throws IOException {
        return (Map)new BDecoder().decodeInputStream(data, 0);
    }

    private Map decode(ByteArrayInputStream data) throws IOException {
        return (Map)this.decodeInputStream(data, 0);
    }

    private Object decodeInputStream(InputStream bais, int nesting) throws IOException {
        if (!bais.markSupported()) {
            throw new IOException("InputStream must support the mark() method");
        }
        bais.mark(Integer.MAX_VALUE);
        int tempByte = bais.read();
        switch (tempByte) {
            case 100: {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                byte[] tempByteArray = null;
                while ((tempByteArray = (byte[])this.decodeInputStream(bais, nesting + 1)) != null) {
                    Object value = this.decodeInputStream(bais, nesting + 1);
                    CharBuffer cb = this.byte_charset.decode(ByteBuffer.wrap(tempByteArray));
                    String key = new String(cb.array(), 0, cb.limit());
                    tempMap.put(key, value);
                }
                if (bais.available() < nesting) {
                    throw new IOException("BDecoder: invalid input data, 'e' missing from end of dictionary");
                }
                return tempMap;
            }
            case 108: {
                ArrayList<Object> tempList = new ArrayList<Object>();
                Object tempElement = null;
                while ((tempElement = this.decodeInputStream(bais, nesting + 1)) != null) {
                    tempList.add(tempElement);
                }
                if (bais.available() < nesting) {
                    throw new IOException("BDecoder: invalid input data, 'e' missing from end of list");
                }
                return tempList;
            }
            case -1: 
            case 101: {
                return null;
            }
            case 105: {
                return new Long(this.getNumberFromStream(bais, 'e'));
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                bais.reset();
                return this.getByteArrayFromStream(bais);
            }
        }
        throw new IOException("UNKNOWN COMMAND");
    }

    private long getNumberFromStream(InputStream bais, char parseChar) throws IOException {
        int length = 0;
        bais.mark(Integer.MAX_VALUE);
        int tempByte = bais.read();
        while (tempByte != parseChar && tempByte >= 0) {
            tempByte = bais.read();
            ++length;
        }
        if (tempByte < 0) {
            return -1L;
        }
        bais.reset();
        byte[] tempArray = new byte[length];
        int count = 0;
        int len = 0;
        while (count != length && (len = bais.read(tempArray, count, length - count)) > 0) {
            count += len;
        }
        bais.skip(1L);
        CharBuffer cb = this.default_charset.decode(ByteBuffer.wrap(tempArray));
        String str_value = new String(cb.array(), 0, cb.limit());
        return Long.parseLong(str_value);
    }

    private byte[] getByteArrayFromStream(InputStream bais) throws IOException {
        int length = (int)this.getNumberFromStream(bais, ':');
        if (length < 0) {
            return null;
        }
        byte[] tempArray = new byte[length];
        int count = 0;
        int len = 0;
        while (count != length && (len = bais.read(tempArray, count, length - count)) > 0) {
            count += len;
        }
        if (count != tempArray.length) {
            throw new IOException("BDecoder::getByteArrayFromStream: truncated");
        }
        return tempArray;
    }
}

