/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacket;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;

public abstract class PRUDPPacketRequest
extends PRUDPPacket {
    protected long connection_id;

    public PRUDPPacketRequest(int _action, long _con_id) {
        super(_action);
        this.connection_id = _con_id;
    }

    protected PRUDPPacketRequest(int _action, long _con_id, int _trans_id) {
        super(_action, _trans_id);
        this.connection_id = _con_id;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    public void serialise(DataOutputStream os) throws IOException {
        os.writeLong(this.connection_id);
        os.writeInt(this.type);
        os.writeInt(this.transaction_id);
    }

    public static PRUDPPacketRequest deserialiseRequest(DataInputStream is) throws IOException {
        long connection_id = is.readLong();
        int action = is.readInt();
        int transaction_id = is.readInt();
        switch (action) {
            case 0: {
                return new PRUDPPacketRequestConnect(is, connection_id, transaction_id);
            }
            case 1: {
                if (PRUDPPacket.VERSION == 1) {
                    return new PRUDPPacketRequestAnnounce(is, connection_id, transaction_id);
                }
                return new PRUDPPacketRequestAnnounce2(is, connection_id, transaction_id);
            }
            case 2: {
                return new PRUDPPacketRequestScrape(is, connection_id, transaction_id);
            }
        }
        throw new IOException("unsupported request type");
    }

    public String getString() {
        return super.getString().concat(":request[con=").concat(String.valueOf(this.connection_id)).concat(",trans=").concat(String.valueOf(this.transaction_id)).concat("]");
    }
}

