/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.classic;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.PEPeerServer;
import org.gudy.azureus2.core3.peer.PEPeerServerListener;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClientListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.TrackerClientAnnounceDataProvider;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerClientFactoryImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.classic.TRTrackerResponsePeerImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacket;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandler;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandlerException;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketHandlerFactory;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReply;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequest;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.util.impl.TRTrackerUtilsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TRTrackerClientClassicImpl
implements TRTrackerClient,
PEPeerServerListener,
ParameterListener {
    private static final int OVERRIDE_PERIOD = 10000;
    private static Timer tracker_timer = new Timer("Tracker Timer", 32);
    public static String UDP_REALM = "UDP Tracker";
    private TOTorrent torrent;
    private PEPeerServer peer_server;
    private TimerEvent current_timer_event;
    private TimerEventPerformer timer_event_action;
    private int tracker_state = 1;
    private String tracker_status_str = "";
    private TRTrackerResponse last_response = null;
    private long last_update_time_secs;
    private long current_time_to_wait_secs;
    private int failure_added_time = 0;
    private long failure_time_last_updated = 0L;
    private boolean stopped;
    private boolean completed;
    private boolean complete_reported = false;
    private boolean update_in_progress = false;
    private long rd_last_override = 0L;
    private int rd_override_percentage = 100;
    private List trackerUrlLists;
    private URL lastUsedUrl;
    private String trackerUrlListString;
    private byte[] torrent_hash;
    private PeerIdentityDataID peer_data_id;
    private String info_hash = "info_hash=";
    private byte[] tracker_peer_id;
    private String tracker_peer_id_str = "&peer_id=";
    private byte[] data_peer_id;
    private String key_id = "";
    private static final int key_id_length = 8;
    private int key_udp;
    private String port;
    private String ip_override;
    private String last_warning_message = "";
    private TrackerClientAnnounceDataProvider announce_data_provider;
    private Map tracker_peer_cache = new LinkedHashMap();
    private AEMonitor tracker_peer_cache_mon = new AEMonitor("TRTrackerClientClassic:PC");
    protected AEMonitor this_mon = new AEMonitor("TRTrackerClientClassic");
    private static final boolean socks_peer_inform = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable", false) && COConfigurationManager.getBooleanParameter("Proxy.Data.SOCKS.inform", true);
    private boolean destroyed;
    public static final int componentID = 2;
    public static final int evtLifeCycle = 0;
    public static final int evtFullTrace = 1;
    public static final int evtErrors = 2;
    private static final int LDT_TRACKER_RESPONSE = 1;
    private static final int LDT_URL_CHANGED = 2;
    private static final int LDT_URL_REFRESH = 3;
    private ListenerManager listeners = ListenerManager.createManager("TrackerClient:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            TRTrackerClientListener listener = (TRTrackerClientListener)_listener;
            if (type == 1) {
                listener.receivedTrackerResponse((TRTrackerResponse)value);
            } else if (type == 2) {
                Object[] x = (Object[])value;
                String url = (String)x[0];
                boolean explicit = (Boolean)x[1];
                listener.urlChanged(url, explicit);
            } else {
                listener.urlRefresh();
            }
        }
    });
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static byte[] createPeerID() {
        byte[] peerId = new byte[20];
        byte[] version = Constants.VERSION_ID;
        int i = 0;
        while (i < 8) {
            peerId[i] = version[i];
            ++i;
        }
        i = 8;
        while (i < 20) {
            int pos = (int)(Math.random() * (double)chars.length());
            peerId[i] = (byte)chars.charAt(pos);
            ++i;
        }
        return peerId;
    }

    public static String createKeyID() {
        String key_id = "";
        int i = 0;
        while (i < 8) {
            int pos = (int)(Math.random() * (double)chars.length());
            key_id = String.valueOf(key_id) + chars.charAt(pos);
            ++i;
        }
        return key_id;
    }

    public TRTrackerClientClassicImpl(TOTorrent _torrent, PEPeerServer _peer_server) throws TRTrackerClientException {
        this.torrent = _torrent;
        this.peer_server = _peer_server;
        this.constructTrackerUrlLists(true);
        this.tracker_peer_id = TRTrackerClientClassicImpl.createPeerID();
        this.data_peer_id = COConfigurationManager.getBooleanParameter("Tracker Separate Peer IDs", false) ? TRTrackerClientClassicImpl.createPeerID() : this.tracker_peer_id;
        this.key_id = TRTrackerClientClassicImpl.createKeyID();
        this.key_udp = (int)(Math.random() * 4.294967295E9);
        try {
            this.torrent_hash = _torrent.getHash();
            this.peer_data_id = PeerIdentityManager.createDataID(this.torrent_hash);
            this.info_hash = String.valueOf(this.info_hash) + URLEncoder.encode(new String(this.torrent_hash, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.tracker_peer_id_str = String.valueOf(this.tracker_peer_id_str) + URLEncoder.encode(new String(this.tracker_peer_id, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LGLogger.log(2, 0, "URL encode fails", e);
            throw new TRTrackerClientException("TRTrackerClient: URL encode fails");
        }
        catch (TOTorrentException e) {
            LGLogger.log(2, 0, "Torrent hash retrieval fails", e);
            throw new TRTrackerClientException("TRTrackerClient: URL encode fails");
        }
        this.peer_server.addListener(this);
        COConfigurationManager.addParameterListener("TCP.Announce.Port", this);
        this.setPort();
        this.timer_event_action = new TimerEventPerformer(){

            public void perform(TimerEvent this_event) {
                long secs_to_wait = TRTrackerClientClassicImpl.this.getErrorRetryInterval();
                try {
                    secs_to_wait = TRTrackerClientClassicImpl.this.requestUpdateSupport();
                }
                finally {
                    TRTrackerClientClassicImpl.this.current_time_to_wait_secs = secs_to_wait;
                    if (TRTrackerClientClassicImpl.this.tracker_state != 4) {
                        try {
                            TRTrackerClientClassicImpl.this.this_mon.enter();
                            if (!this_event.isCancelled()) {
                                secs_to_wait = TRTrackerClientClassicImpl.this.getAdjustedSecsToWait();
                                long target_time = SystemTime.getCurrentTime() + secs_to_wait * 1000L;
                                if (TRTrackerClientClassicImpl.this.current_timer_event != null && !TRTrackerClientClassicImpl.this.current_timer_event.isCancelled()) {
                                    if (TRTrackerClientClassicImpl.this.current_timer_event != this_event && TRTrackerClientClassicImpl.this.current_timer_event.getWhen() < target_time) {
                                        TRTrackerClientClassicImpl.this.this_mon.exit();
                                        return;
                                    }
                                    TRTrackerClientClassicImpl.this.current_timer_event.cancel();
                                }
                                if (!TRTrackerClientClassicImpl.this.destroyed) {
                                    TRTrackerClientClassicImpl.this.current_timer_event = tracker_timer.addEvent(target_time, this);
                                }
                            }
                        }
                        finally {
                            TRTrackerClientClassicImpl.this.this_mon.exit();
                        }
                    }
                }
            }
        };
        LGLogger.log(2, 0, 0, "Tracker Client Created using url : " + this.trackerUrlListString);
    }

    public void portChanged(int new_port) {
        this.setPort();
        this.update(true);
    }

    protected void setPort() {
        int port_num = socks_peer_inform ? 0 : this.peer_server.getPort();
        String portOverride = COConfigurationManager.getStringParameter("TCP.Announce.Port", "");
        if (!portOverride.equals("")) {
            this.port = "&port=" + portOverride;
        } else {
            this.port = "&port=" + port_num;
            if (port_num == 0) {
                this.port = String.valueOf(this.port) + "&hide=1";
            }
        }
    }

    protected long getAdjustedSecsToWait() {
        long secs_to_wait = this.current_time_to_wait_secs;
        if (this.last_response != null && this.last_response.getStatus() != 2) {
            secs_to_wait = this.getErrorRetryInterval();
        } else {
            if (this.rd_override_percentage == 0) {
                return 60L;
            }
            if ((secs_to_wait = secs_to_wait * (long)this.rd_override_percentage / 100L) < 60L) {
                secs_to_wait = 60L;
            }
        }
        return secs_to_wait;
    }

    public int getStatus() {
        return this.tracker_state;
    }

    public String getStatusString() {
        return this.tracker_status_str;
    }

    public void setRefreshDelayOverrides(int percentage) {
        boolean override_allowed;
        if (percentage > 100) {
            percentage = 100;
        } else if (percentage < 0) {
            percentage = 0;
        }
        long now = SystemTime.getCurrentTime();
        boolean bl = override_allowed = this.rd_last_override > 0L && now - this.rd_last_override > 10000L;
        if ((SystemTime.isErrorLast10sec() || override_allowed) && this.rd_override_percentage != percentage) {
            try {
                this.this_mon.enter();
                this.rd_last_override = now;
                this.rd_override_percentage = percentage;
                if (this.current_timer_event != null && !this.current_timer_event.isCancelled()) {
                    long start = this.current_timer_event.getCreatedTime();
                    long expiry = this.current_timer_event.getWhen();
                    long secs_to_wait = this.getAdjustedSecsToWait();
                    long target_time = start + secs_to_wait * 1000L;
                    if (target_time != expiry) {
                        this.current_timer_event.cancel();
                        if (!this.destroyed) {
                            this.current_timer_event = tracker_timer.addEvent(start, target_time, this.timer_event_action);
                        }
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    public int getTimeUntilNextUpdate() {
        int rem;
        block3: {
            try {
                this.this_mon.enter();
                if (this.current_timer_event != null) break block3;
                int n = this.getErrorRetryInterval();
                this.this_mon.exit();
                return n;
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
        }
        int n = rem = (int)((this.current_timer_event.getWhen() - SystemTime.getCurrentTime()) / 1000L);
        this.this_mon.exit();
        return n;
    }

    public int getLastUpdateTime() {
        return (int)this.last_update_time_secs;
    }

    public void update(boolean force) {
        long time = SystemTime.getCurrentTime() / 1000L;
        if (SystemTime.isErrorLast1min() || force || time - this.last_update_time_secs >= 60L) {
            this.requestUpdate();
        }
    }

    public void complete(boolean already_reported) {
        this.complete_reported = this.complete_reported || already_reported;
        this.completed = true;
        this.requestUpdate();
    }

    public void stop() {
        this.stopped = true;
        this.requestUpdate();
    }

    protected void requestUpdate() {
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null) {
                this.current_timer_event.cancel();
            }
            this.rd_last_override = SystemTime.getCurrentTime();
            if (!this.destroyed) {
                this.current_timer_event = tracker_timer.addEvent(SystemTime.getCurrentTime(), this.timer_event_action);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long requestUpdateSupport() {
        boolean clear_progress = true;
        try {
            try {
                TRTrackerResponse response;
                block40: {
                    block42: {
                        block41: {
                            block39: {
                                block37: {
                                    this.this_mon.enter();
                                    if (!this.update_in_progress) break block37;
                                    clear_progress = false;
                                    long l = this.getErrorRetryInterval();
                                    this.this_mon.exit();
                                    try {
                                        this.this_mon.enter();
                                        if (!clear_progress) return l;
                                        this.update_in_progress = false;
                                        return l;
                                    }
                                    finally {
                                        this.this_mon.exit();
                                    }
                                }
                                try {
                                    this.update_in_progress = true;
                                }
                                finally {
                                    this.this_mon.exit();
                                }
                                this.last_update_time_secs = SystemTime.getCurrentTime() / 1000L;
                                this.tracker_status_str = String.valueOf(MessageText.getString("PeerManager.status.checking")) + "...";
                                response = null;
                                if (!this.stopped) break block39;
                                if (this.tracker_state == 1) {
                                    this.tracker_state = 4;
                                    break block40;
                                } else if (this.tracker_state != 4) {
                                    response = this.stopSupport();
                                    this.tracker_state = response.getStatus() == 2 ? 4 : 4;
                                }
                                break block40;
                            }
                            if (this.tracker_state != 1) break block41;
                            response = this.startSupport();
                            if (response.getStatus() == 2) {
                                this.tracker_state = 2;
                            }
                            break block40;
                        }
                        if (!this.completed) break block42;
                        if (!this.complete_reported) {
                            response = this.completeSupport();
                            if (response.getStatus() == 2) {
                                this.complete_reported = true;
                                this.tracker_state = 3;
                            }
                            break block40;
                        } else {
                            this.tracker_state = 3;
                            response = this.updateSupport();
                        }
                        break block40;
                    }
                    response = this.updateSupport();
                }
                if (response != null) {
                    int rs = response.getStatus();
                    if (rs == 0) {
                        this.tracker_status_str = MessageText.getString("PeerManager.status.offline");
                        String reason = response.getFailureReason();
                        if (reason != null) {
                            this.tracker_status_str = String.valueOf(this.tracker_status_str) + " (" + reason + ")";
                        }
                    } else if (rs == 1) {
                        this.tracker_status_str = MessageText.getString("PeerManager.status.error");
                        String reason = response.getFailureReason();
                        if (reason != null) {
                            this.tracker_status_str = String.valueOf(this.tracker_status_str) + " (" + reason + ")";
                        }
                        this.tracker_state = 1;
                    } else {
                        this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
                    }
                    this.last_response = response;
                    this.listeners.dispatch(1, response);
                    long l = response.getTimeToWait();
                    try {
                        this.this_mon.enter();
                        if (!clear_progress) return l;
                        this.update_in_progress = false;
                        return l;
                    }
                    finally {
                        this.this_mon.exit();
                    }
                }
                this.tracker_status_str = "";
                long l = this.getErrorRetryInterval();
                try {
                    this.this_mon.enter();
                    if (!clear_progress) return l;
                    this.update_in_progress = false;
                    return l;
                }
                finally {
                    this.this_mon.exit();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                long l = this.getErrorRetryInterval();
                try {
                    this.this_mon.enter();
                    if (!clear_progress) return l;
                    this.update_in_progress = false;
                    return l;
                }
                finally {
                    this.this_mon.exit();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.this_mon.enter();
                if (!clear_progress) throw throwable;
                this.update_in_progress = false;
                throw throwable;
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected TRTrackerResponse startSupport() {
        LGLogger.log(2, 0, 2, "Tracker Client is sending a start Request");
        return this.update("started");
    }

    protected TRTrackerResponse completeSupport() {
        LGLogger.log(2, 0, 2, "Tracker Client is sending a completed Request");
        return this.update("completed");
    }

    protected TRTrackerResponse stopSupport() {
        LGLogger.log(2, 0, 2, "Tracker Client is sending a stopped Request");
        return this.update("stopped");
    }

    protected TRTrackerResponse updateSupport() {
        LGLogger.log(2, 0, 2, "Tracker Client is sending an update Request");
        return this.update("");
    }

    private TRTrackerResponse update(String evt) {
        TRTrackerResponsePeer[] cached_peers;
        TRTrackerResponseImpl last_failure_resp = null;
        int i = 0;
        block3: while (i < this.trackerUrlLists.size()) {
            List urls = (List)this.trackerUrlLists.get(i);
            int j = 0;
            while (j < urls.size()) {
                URL url;
                this.lastUsedUrl = url = (URL)urls.get(j);
                URL request_url = null;
                try {
                    request_url = this.constructUrl(evt, url);
                    TRTrackerResponseImpl resp = this.decodeTrackerResponse(this.updateOld(request_url));
                    if (resp.getStatus() == 2) {
                        urls.remove(j);
                        urls.add(0, url);
                        this.trackerUrlLists.remove(i);
                        this.trackerUrlLists.add(0, urls);
                        this.informURLChange(url, false);
                        return resp;
                    }
                    last_failure_resp = resp;
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                    last_failure_resp = new TRTrackerResponseImpl(0, (long)this.getErrorRetryInterval(), "malformed URL '" + (request_url == null ? "<null>" : request_url.toString()) + "'");
                }
                catch (Exception e) {
                    last_failure_resp = new TRTrackerResponseImpl(0, (long)this.getErrorRetryInterval(), e.getMessage());
                }
                if (this.destroyed) break block3;
                ++j;
            }
            ++i;
        }
        if (last_failure_resp == null) {
            last_failure_resp = new TRTrackerResponseImpl(0, (long)this.getErrorRetryInterval(), "Reason Unknown");
        }
        if ((cached_peers = this.getPeersFromCache()).length > 0) {
            last_failure_resp.setPeers(cached_peers);
        }
        return last_failure_resp;
    }

    private byte[] updateOld(URL reqUrl) throws Exception {
        TorrentUtils.setTLSTorrentHash(this.torrent_hash);
        int i = 0;
        while (i < 2) {
            block8: {
                String failure_reason;
                block7: {
                    failure_reason = null;
                    try {
                        String protocol = reqUrl.getProtocol();
                        LGLogger.log(2, 1, 0, "Tracker Client is Requesting : " + reqUrl);
                        ByteArrayOutputStream message = new ByteArrayOutputStream();
                        failure_reason = protocol.equalsIgnoreCase("udp") ? this.announceUDP(reqUrl, message) : this.announceHTTP(reqUrl, message);
                        if (message.size() > 0) {
                            return message.toByteArray();
                        }
                        if (failure_reason == null) {
                            failure_reason = "No data received from tracker";
                        }
                    }
                    catch (SSLHandshakeException e) {
                        if (i != 0 || e.getMessage().indexOf("No trusted certificate found") == -1) break block7;
                        if (SESecurityManager.installServerCertificates(reqUrl)) break block8;
                        failure_reason = this.exceptionToString(e);
                    }
                    catch (Exception e) {
                        failure_reason = this.exceptionToString(e);
                    }
                }
                if (failure_reason.indexOf("401") != -1) {
                    failure_reason = "Tracker authentication failed";
                }
                LGLogger.log(2, 2, 3, "Exception while processing the Tracker Request : " + failure_reason);
                throw new Exception(failure_reason);
            }
            ++i;
        }
        throw new Exception("Internal Error: should never get here");
    }

    protected String announceHTTP(URL reqUrl, ByteArrayOutputStream message) throws IOException {
        HttpURLConnection con;
        TRTrackerUtilsImpl.checkForBlacklistedURLs(reqUrl);
        reqUrl = TRTrackerUtilsImpl.adjustURLForHosting(reqUrl);
        reqUrl = AEProxyFactory.getAddressMapper().internalise(reqUrl);
        String failure_reason = null;
        if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
            HttpsURLConnection ssl_con = (HttpsURLConnection)reqUrl.openConnection();
            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String host, SSLSession session) {
                    return true;
                }
            });
            con = ssl_con;
        } else {
            con = (HttpURLConnection)reqUrl.openConnection();
        }
        con.setRequestProperty("User-Agent", "Azureus 2.2.0.2");
        con.setRequestProperty("Connection", "close");
        con.addRequestProperty("Accept-Encoding", "gzip");
        try {
            con.connect();
            InputStream is = null;
            try {
                try {
                    boolean gzip;
                    is = con.getInputStream();
                    String encoding = con.getHeaderField("content-encoding");
                    boolean bl = gzip = encoding != null && encoding.equalsIgnoreCase("gzip");
                    if (gzip) {
                        is = new GZIPInputStream(is);
                    }
                    int content_length = -1;
                    byte[] data = new byte[1024];
                    int num_read = 0;
                    while (content_length <= 0 || num_read < content_length) {
                        try {
                            int len = is.read(data);
                            if (len > 0) {
                                message.write(data, 0, len);
                                num_read += len;
                                continue;
                            }
                            if (len != 0) break;
                            Thread.sleep(20L);
                        }
                        catch (Exception e) {
                            LGLogger.log(2, 2, 3, "Exception while Requesting Tracker : " + e);
                            LGLogger.log(2, 1, 3, "Message Received was : " + message);
                            failure_reason = this.exceptionToString(e);
                            break;
                        }
                    }
                    LGLogger.log(2, 1, 1, "Tracker Client [" + this.lastUsedUrl + "] has received : " + message);
                }
                catch (Exception e) {
                    failure_reason = this.exceptionToString(e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    is = null;
                }
            }
        }
        finally {
            con.disconnect();
        }
        return failure_reason;
    }

    protected String announceUDP(URL reqUrl, ByteArrayOutputStream message) throws IOException {
        reqUrl = TRTrackerUtilsImpl.adjustURLForHosting(reqUrl);
        String failure_reason = null;
        PasswordAuthentication auth = null;
        try {
            if (reqUrl.getQuery().toLowerCase().indexOf("auth") != -1) {
                auth = SESecurityManager.getPasswordAuthentication(UDP_REALM, reqUrl);
            }
            PRUDPPacketHandler handler = PRUDPPacketHandlerFactory.getHandler(this.peer_server.getPort());
            InetSocketAddress destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
            int retry_loop = 0;
            while (retry_loop < 1) {
                block30: {
                    try {
                        PRUDPPacketRequestConnect connect_request = new PRUDPPacketRequestConnect();
                        PRUDPPacket reply = handler.sendAndReceive(auth, connect_request, destination);
                        if (reply.getAction() == 0) {
                            int ip;
                            String ip_str;
                            int event;
                            String event_str;
                            int p_pos;
                            String url_str;
                            PRUDPPacketRequest request2;
                            PRUDPPacketRequest announce_request;
                            PRUDPPacketReplyConnect connect_reply = (PRUDPPacketReplyConnect)reply;
                            long my_connection = connect_reply.getConnectionId();
                            if (PRUDPPacket.VERSION == 1) {
                                request2 = announce_request = new PRUDPPacketRequestAnnounce(my_connection);
                                url_str = reqUrl.toString();
                                p_pos = url_str.indexOf("?");
                                url_str = url_str.substring(p_pos + 1);
                                event_str = this.getURLParam(url_str, "event");
                                event = 0;
                                if (event_str != null) {
                                    if (event_str.equals("started")) {
                                        event = 2;
                                    } else if (event_str.equals("stopped")) {
                                        event = 3;
                                    } else if (event_str.equals("completed")) {
                                        event = 1;
                                    }
                                }
                                ip_str = this.getURLParam(url_str, "ip");
                                ip = 0;
                                if (ip_str != null) {
                                    ip = PRHelpers.addressToInt(ip_str);
                                }
                                ((PRUDPPacketRequestAnnounce)announce_request).setDetails(this.torrent_hash, this.tracker_peer_id, this.getLongURLParam(url_str, "downloaded"), event, ip, (int)this.getLongURLParam(url_str, "numwant"), this.getLongURLParam(url_str, "left"), (short)this.getLongURLParam(url_str, "port"), this.getLongURLParam(url_str, "uploaded"));
                            } else {
                                request2 = announce_request = new PRUDPPacketRequestAnnounce2(my_connection);
                                url_str = reqUrl.toString();
                                p_pos = url_str.indexOf("?");
                                url_str = url_str.substring(p_pos + 1);
                                event_str = this.getURLParam(url_str, "event");
                                event = 0;
                                if (event_str != null) {
                                    if (event_str.equals("started")) {
                                        event = 2;
                                    } else if (event_str.equals("stopped")) {
                                        event = 3;
                                    } else if (event_str.equals("completed")) {
                                        event = 1;
                                    }
                                }
                                ip_str = this.getURLParam(url_str, "ip");
                                ip = 0;
                                if (ip_str != null) {
                                    ip = PRHelpers.addressToInt(ip_str);
                                }
                                ((PRUDPPacketRequestAnnounce2)announce_request).setDetails(this.torrent_hash, this.tracker_peer_id, this.getLongURLParam(url_str, "downloaded"), event, ip, this.key_udp, (int)this.getLongURLParam(url_str, "numwant"), this.getLongURLParam(url_str, "left"), (short)this.getLongURLParam(url_str, "port"), this.getLongURLParam(url_str, "uploaded"));
                            }
                            reply = handler.sendAndReceive(auth, request2, destination);
                            if (reply.getAction() == 1) {
                                short[] ports;
                                HashMap<String, Serializable> map;
                                PRUDPPacketReply announce_reply;
                                if (auth != null) {
                                    SESecurityManager.setPasswordAuthenticationOutcome(UDP_REALM, reqUrl, true);
                                }
                                if (PRUDPPacket.VERSION == 1) {
                                    announce_reply = (PRUDPPacketReplyAnnounce)reply;
                                    map = new HashMap<String, Serializable>();
                                    map.put("interval", new Long(((PRUDPPacketReplyAnnounce)announce_reply).getInterval()));
                                    int[] addresses = ((PRUDPPacketReplyAnnounce)announce_reply).getAddresses();
                                    ports = ((PRUDPPacketReplyAnnounce)announce_reply).getPorts();
                                    ArrayList peers = new ArrayList();
                                    map.put("peers", peers);
                                    int i = 0;
                                    while (i < addresses.length) {
                                        HashMap<String, Object> peer = new HashMap<String, Object>();
                                        peers.add(peer);
                                        peer.put("ip", PRHelpers.intToAddress(addresses[i]).getBytes());
                                        peer.put("port", new Long(ports[i]));
                                        ++i;
                                    }
                                    byte[] data = BEncoder.encode(map);
                                    message.write(data);
                                    return null;
                                }
                                announce_reply = (PRUDPPacketReplyAnnounce2)reply;
                                map = new HashMap();
                                map.put("interval", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getInterval()));
                                int[] addresses = ((PRUDPPacketReplyAnnounce2)announce_reply).getAddresses();
                                ports = ((PRUDPPacketReplyAnnounce2)announce_reply).getPorts();
                                map.put("complete", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getSeeders()));
                                map.put("incomplete", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getLeechers()));
                                ArrayList peers = new ArrayList();
                                map.put("peers", peers);
                                int i = 0;
                                while (i < addresses.length) {
                                    HashMap<String, Object> peer = new HashMap<String, Object>();
                                    peers.add(peer);
                                    peer.put("ip", PRHelpers.intToAddress(addresses[i]).getBytes());
                                    peer.put("port", new Long(ports[i]));
                                    ++i;
                                }
                                byte[] data = BEncoder.encode(map);
                                message.write(data);
                                return null;
                            }
                            failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                        } else {
                            failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                        }
                    }
                    catch (PRUDPPacketHandlerException e) {
                        if (e.getMessage() != null && e.getMessage().indexOf("timed out") != -1) break block30;
                        throw e;
                    }
                }
                ++retry_loop;
            }
        }
        catch (Throwable e) {
            failure_reason = this.exceptionToString(e);
        }
        if (auth != null) {
            SESecurityManager.setPasswordAuthenticationOutcome(UDP_REALM, reqUrl, false);
        }
        return failure_reason;
    }

    protected long getLongURLParam(String url, String param) {
        String val = this.getURLParam(url, param);
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(String.valueOf(param) + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected String exceptionToString(Throwable e) {
        String str;
        String class_name = e.getClass().getName();
        int pos = class_name.lastIndexOf(46);
        if (pos != -1) {
            class_name = class_name.substring(pos + 1);
        }
        if ((str = String.valueOf(class_name) + ":" + e.getMessage()).indexOf("timed out") != -1) {
            str = "timeout";
        }
        return str;
    }

    public URL constructUrl(String evt, URL _url) throws MalformedURLException {
        String ip;
        String url = _url.toString();
        StringBuffer request2 = new StringBuffer(url);
        if (url.indexOf(63) != -1) {
            request2.append('&');
        } else {
            request2.append('?');
        }
        request2.append(this.info_hash);
        request2.append(this.tracker_peer_id_str);
        request2.append(this.port);
        request2.append("&uploaded=").append(this.announce_data_provider.getTotalSent());
        request2.append("&downloaded=").append(this.announce_data_provider.getTotalReceived());
        request2.append("&left=").append(this.announce_data_provider.getRemaining());
        if (evt.length() != 0) {
            request2.append("&event=").append(evt);
        }
        if (evt.equals("stopped")) {
            request2.append("&numwant=0");
        } else {
            int numwant = this.calculateNumWant() * 2;
            request2.append("&numwant=" + numwant);
            request2.append("&compact=1");
        }
        String explicit_ip = COConfigurationManager.getStringParameter("Override Ip", "");
        String string = explicit_ip.length() > 0 ? explicit_ip : (ip = this.ip_override == null ? "" : this.ip_override);
        if (ip.length() != 0) {
            String ip2;
            try {
                ip2 = PRHelpers.DNSToIPAddress(ip);
            }
            catch (UnknownHostException e) {
                LGLogger.log(3, "IP Override host resolution of '" + ip + "' fails, using unresolved address");
                ip2 = ip;
            }
            request2.append("&ip=").append(ip2);
        }
        if (COConfigurationManager.getBooleanParameter("Tracker Key Enable Client", true)) {
            request2.append("&key=" + this.key_id);
        }
        return new URL(request2.toString());
    }

    protected int calculateNumWant() {
        int MAX_PEERS = 100;
        int maxAllowed = PeerUtils.numNewConnectionsAllowed(this.peer_data_id);
        if (maxAllowed < 0 || maxAllowed > MAX_PEERS) {
            maxAllowed = MAX_PEERS;
        }
        return maxAllowed;
    }

    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    public void setAnnounceDataProvider(TrackerClientAnnounceDataProvider _provider) {
        this.announce_data_provider = _provider;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public URL getTrackerUrl() {
        return this.lastUsedUrl;
    }

    public void setTrackerUrl(URL new_url) {
        try {
            new_url = new URL(new_url.toString().replaceAll(" ", ""));
            ArrayList<URL> list = new ArrayList<URL>(1);
            list.add(new_url);
            this.trackerUrlLists.clear();
            this.trackerUrlLists.add(list);
            this.informURLChange(new_url, true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void resetTrackerUrl(boolean shuffle) {
        this.constructTrackerUrlLists(shuffle);
        if (this.trackerUrlLists.size() == 0) {
            return;
        }
        URL first_url = (URL)((List)this.trackerUrlLists.get(0)).get(0);
        this.informURLChange(first_url, true);
    }

    public void refreshListeners() {
        this.informURLRefresh();
    }

    public void setIPOverride(String override) {
        this.ip_override = override;
    }

    public void clearIPOverride() {
        this.ip_override = null;
    }

    private void constructTrackerUrlLists(boolean shuffle) {
        try {
            this.trackerUrlLists = new ArrayList();
            TOTorrentAnnounceURLSet[] announce_sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (announce_sets.length == 0) {
                URL url = this.torrent.getAnnounceURL();
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(url);
                this.trackerUrlLists.add(list);
            } else {
                int i = 0;
                while (i < announce_sets.length) {
                    URL[] urls = announce_sets[i].getAnnounceURLs();
                    ArrayList<URL> random_urls = new ArrayList<URL>();
                    int j = 0;
                    while (j < urls.length) {
                        URL url = urls[j];
                        int pos = shuffle ? (int)(Math.random() * (double)(random_urls.size() + 1)) : j;
                        random_urls.add(pos, url);
                        ++j;
                    }
                    this.trackerUrlLists.add(random_urls);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        this.trackerUrlListString = "[";
        int i = 0;
        while (i < this.trackerUrlLists.size()) {
            List group = (List)this.trackerUrlLists.get(i);
            this.trackerUrlListString = String.valueOf(this.trackerUrlListString) + (i == 0 ? "" : ",") + "[";
            int j = 0;
            while (j < group.size()) {
                URL u = (URL)group.get(j);
                this.trackerUrlListString = String.valueOf(this.trackerUrlListString) + (j == 0 ? "" : ",") + u.toString();
                ++j;
            }
            this.trackerUrlListString = String.valueOf(this.trackerUrlListString) + "]";
            ++i;
        }
        this.trackerUrlListString = String.valueOf(this.trackerUrlListString) + "]";
    }

    protected TRTrackerResponseImpl decodeTrackerResponse(byte[] data) {
        String failure_reason;
        if (data == null) {
            failure_reason = "no response";
        } else {
            try {
                try {
                    Object meta_peers;
                    long time_to_wait;
                    Map metaData = BDecoder.decode(data);
                    try {
                        String warning_message;
                        byte[] b_warning_message = (byte[])metaData.get("warning message");
                        if (b_warning_message != null && !(warning_message = new String(b_warning_message)).equals(this.last_warning_message)) {
                            this.last_warning_message = warning_message;
                            String expanded_message = MessageText.getString("TrackerClient.announce.warningmessage", new String[]{this.announce_data_provider.getName(), warning_message});
                            LGLogger.logUnrepeatableAlert(1, expanded_message);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    try {
                        time_to_wait = this.announce_data_provider.getRemaining() == 0L ? (Long)metaData.get("interval") : (long)(6 * ((Long)metaData.get("interval")).intValue() / 7);
                        if (time_to_wait < 0L || time_to_wait > 0xFFFFFFFFL) {
                            time_to_wait = 0xFFFFFFFFL;
                        }
                    }
                    catch (Exception e) {
                        byte[] failure_reason_bytes = (byte[])metaData.get("failure reason");
                        if (failure_reason_bytes == null) {
                            System.out.println("Problems with Tracker, will retry in 1 minute");
                            return new TRTrackerResponseImpl(0, this.getErrorRetryInterval());
                        }
                        String failure_reason2 = new String(failure_reason_bytes, "UTF8");
                        return new TRTrackerResponseImpl(1, (long)this.getErrorRetryInterval(), failure_reason2);
                    }
                    Long incomplete_l = (Long)metaData.get("incomplete");
                    Long complete_l = (Long)metaData.get("complete");
                    if (incomplete_l != null || complete_l != null) {
                        LGLogger.log(2, 1, 0, "ANNOUNCE SCRAPE1: seeds=" + complete_l + " peers=" + incomplete_l);
                    }
                    ArrayList<TRTrackerResponsePeerImpl> valid_meta_peers = new ArrayList<TRTrackerResponsePeerImpl>();
                    Object meta_peers_peek = metaData.get("peers");
                    if (meta_peers_peek instanceof List) {
                        meta_peers = (List)meta_peers_peek;
                        int peers_length = meta_peers.size();
                        int i = 0;
                        while (i < peers_length) {
                            Map peer = (Map)meta_peers.get(i);
                            Object s_peerid = peer.get("peer id");
                            Object s_ip = peer.get("ip");
                            Object s_port = peer.get("port");
                            if (s_ip != null && s_port != null) {
                                String ip = new String((byte[])s_ip, "UTF8");
                                int peer_port = ((Long)s_port).intValue();
                                if (peer_port < 0 || peer_port > 65535) {
                                    LGLogger.log(3, "Invalid peer port given: " + ip + ": " + peer_port);
                                } else {
                                    byte[] peer_peer_id = s_peerid == null ? this.getAnonymousPeerId(ip, peer_port) : (byte[])s_peerid;
                                    if (PeerUtils.ignorePeerPort(peer_port)) {
                                        LGLogger.log(2, 1, 0, "Ignoring " + ip + ":" + peer_port + " as peer port is in ignore list");
                                    } else {
                                        valid_meta_peers.add(new TRTrackerResponsePeerImpl(peer_peer_id, ip, peer_port));
                                    }
                                }
                            }
                            ++i;
                        }
                    } else {
                        meta_peers = (byte[])meta_peers_peek;
                        int i = 0;
                        while (i < ((Object)meta_peers).length) {
                            int ip1 = 0xFF & meta_peers[i];
                            int ip2 = 0xFF & meta_peers[i + 1];
                            int ip3 = 0xFF & meta_peers[i + 2];
                            int ip4 = 0xFF & meta_peers[i + 3];
                            int po1 = 0xFF & meta_peers[i + 4];
                            int po2 = 0xFF & meta_peers[i + 5];
                            String ip = ip1 + "." + ip2 + "." + ip3 + "." + ip4;
                            int peer_port = po1 * 256 + po2;
                            if (peer_port < 0 || peer_port > 65535) {
                                LGLogger.log(3, "Invalid compact peer port given: " + ip + ": " + peer_port);
                            } else {
                                byte[] peer_peer_id = this.getAnonymousPeerId(ip, peer_port);
                                LGLogger.log(2, 1, 0, "COMPACT PEER: ip=" + ip + " port=" + peer_port);
                                if (PeerUtils.ignorePeerPort(peer_port)) {
                                    LGLogger.log(2, 1, 0, "    Ignoring as peer port is in ignore list");
                                } else {
                                    valid_meta_peers.add(new TRTrackerResponsePeerImpl(peer_peer_id, ip, peer_port));
                                }
                            }
                            i += 6;
                        }
                    }
                    TRTrackerResponsePeer[] peers = new TRTrackerResponsePeer[valid_meta_peers.size()];
                    valid_meta_peers.toArray(peers);
                    this.addToTrackerCache(peers);
                    TRTrackerResponseImpl resp = new TRTrackerResponseImpl(2, time_to_wait, peers);
                    this.failure_added_time = 0;
                    Map extensions = (Map)metaData.get("extensions");
                    resp.setExtensions(extensions);
                    if (extensions != null) {
                        if (complete_l == null) {
                            complete_l = (Long)extensions.get("complete");
                        }
                        if (incomplete_l == null) {
                            incomplete_l = (Long)extensions.get("incomplete");
                        }
                        LGLogger.log(2, 1, 0, "ANNOUNCE SCRAPE2: seeds=" + complete_l + " peers=" + incomplete_l);
                    }
                    if (complete_l != null || incomplete_l != null) {
                        TRTrackerScraperResponse scrapeResponse;
                        int complete = complete_l == null ? 0 : complete_l.intValue();
                        int incomplete = incomplete_l == null ? 0 : incomplete_l.intValue();
                        TRTrackerScraper scraper = TRTrackerScraperFactory.getSingleton();
                        if (scraper != null && (scrapeResponse = scraper.scrape(this)) != null) {
                            long lNextScrapeTime = scrapeResponse.getNextScrapeStartTime();
                            long now = SystemTime.getCurrentTime();
                            long lNewNextScrapeTime = now + 600000L;
                            scrapeResponse.setScrapeStartTime(now);
                            if (lNextScrapeTime < lNewNextScrapeTime) {
                                scrapeResponse.setNextScrapeStartTime(lNewNextScrapeTime);
                            }
                            scrapeResponse.setSeedsPeers(complete, incomplete);
                        }
                    }
                    return resp;
                }
                catch (IOException e) {
                    String trace_data = new String(data);
                    LGLogger.log("TRTrackerClient::invalid reply: " + trace_data);
                    if (trace_data.length() > 150) {
                        trace_data = String.valueOf(trace_data.substring(0, 150)) + "...";
                    }
                    failure_reason = "invalid reply: " + trace_data;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                failure_reason = "error: " + e.getMessage();
            }
        }
        return new TRTrackerResponseImpl(0, (long)this.getErrorRetryInterval(), failure_reason);
    }

    protected void informURLChange(URL url, boolean explicit) {
        this.listeners.dispatch(2, new Object[]{url.toString(), new Boolean(explicit)});
    }

    protected void informURLRefresh() {
        this.listeners.dispatch(3, null);
    }

    public TRTrackerResponse getLastResponse() {
        if (this.last_response == null) {
            return new TRTrackerResponseImpl(0, 60L);
        }
        return this.last_response;
    }

    public void addListener(TRTrackerClientListener l) {
        this.listeners.addListener(l);
    }

    public void removeListener(TRTrackerClientListener l) {
        this.listeners.removeListener(l);
    }

    public void destroy() {
        this.destroyed = true;
        this.peer_server.removeListener(this);
        COConfigurationManager.removeParameterListener("TCP.Announce.Port", this);
        TRTrackerClientFactoryImpl.destroy(this);
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null && this.current_timer_event.getWhen() - SystemTime.getCurrentTime() > 10000L) {
                this.current_timer_event.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private int getErrorRetryInterval() {
        boolean is_seed;
        long currentTime = SystemTime.getCurrentTime() / 1000L;
        if (!SystemTime.isErrorLast1min() && currentTime - this.failure_time_last_updated < (long)this.failure_added_time) {
            return this.failure_added_time;
        }
        this.failure_time_last_updated = currentTime;
        this.failure_added_time = this.failure_added_time == 0 ? 10 : (this.failure_added_time < 30 ? (this.failure_added_time += 10) : (this.failure_added_time < 60 ? (this.failure_added_time += 15) : (this.failure_added_time < 120 ? (this.failure_added_time += 30) : (this.failure_added_time < 600 ? (this.failure_added_time += 60) : (this.failure_added_time += 120 + new Random().nextInt(60))))));
        boolean bl = this.announce_data_provider == null ? false : (is_seed = this.announce_data_provider.getRemaining() == 0L);
        if (is_seed) {
            this.failure_added_time *= 2;
        }
        if (!is_seed && this.failure_added_time > 1200) {
            this.failure_added_time = 1200;
        } else if (is_seed && this.failure_added_time > 3600) {
            this.failure_added_time = 3600;
        }
        return this.failure_added_time;
    }

    protected byte[] getAnonymousPeerId(String my_ip, int my_port) {
        byte[] anon_peer_id = new byte[20];
        anon_peer_id[0] = 91;
        anon_peer_id[1] = 93;
        try {
            byte[] ip_bytes = my_ip.getBytes("UTF8");
            int ip_len = ip_bytes.length;
            if (ip_len > 18) {
                ip_len = 18;
            }
            System.arraycopy(ip_bytes, 0, anon_peer_id, 2, ip_len);
            int port_copy = my_port;
            int j = 2 + ip_len;
            while (j < 20) {
                anon_peer_id[j] = (byte)(port_copy & 0xFF);
                port_copy >>= 8;
                ++j;
            }
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
        return anon_peer_id;
    }

    public Map getTrackerResponseCache() {
        return this.exportTrackerCache();
    }

    public void setTrackerResponseCache(Map map) {
        int num = this.importTrackerCache(map);
        LGLogger.log(2, 1, 0, "TRTrackerClient: imported " + num + " cached peers");
    }

    protected Map exportTrackerCache() {
        HashMap res = new HashMap();
        ArrayList peers = new ArrayList();
        res.put("tracker_peers", peers);
        try {
            this.tracker_peer_cache_mon.enter();
            Iterator it = this.tracker_peer_cache.values().iterator();
            while (it.hasNext()) {
                TRTrackerResponsePeer peer = (TRTrackerResponsePeer)it.next();
                HashMap<String, Object> entry2 = new HashMap<String, Object>();
                entry2.put("ip", peer.getIPAddress().getBytes());
                entry2.put("port", new Long(peer.getPort()));
                peers.add(entry2);
            }
            LGLogger.log(2, 1, 0, "TRTrackerClient: exported " + this.tracker_peer_cache.size() + " cached peers");
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
        return res;
    }

    protected int importTrackerCache(Map map) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return 0;
        }
        try {
            if (map == null) {
                return 0;
            }
            List peers = (List)map.get("tracker_peers");
            if (peers == null) {
                return 0;
            }
            try {
                this.tracker_peer_cache_mon.enter();
                int i = 0;
                while (i < peers.size()) {
                    Map peer = (Map)peers.get(i);
                    String peer_ip_address = new String((byte[])peer.get("ip"));
                    int peer_port = ((Long)peer.get("port")).intValue();
                    byte[] peer_peer_id = this.getAnonymousPeerId(peer_ip_address, peer_port);
                    if (PeerUtils.ignorePeerPort(peer_port)) {
                        LGLogger.log(2, 1, 0, "Ignoring " + peer_ip_address + ":" + peer_port + " as peer port is in ignore list");
                    } else {
                        this.tracker_peer_cache.put(peer_ip_address, new TRTrackerResponsePeerImpl(peer_peer_id, peer_ip_address, peer_port));
                    }
                    ++i;
                }
                int n = this.tracker_peer_cache.size();
                this.tracker_peer_cache_mon.exit();
                return n;
            }
            catch (Throwable throwable) {
                this.tracker_peer_cache_mon.exit();
                throw throwable;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return this.tracker_peer_cache.size();
        }
    }

    protected void addToTrackerCache(TRTrackerResponsePeer[] peers) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return;
        }
        int max = COConfigurationManager.getIntParameter("File.save.peers.max", 512);
        try {
            this.tracker_peer_cache_mon.enter();
            int i = 0;
            while (i < peers.length) {
                TRTrackerResponsePeer peer = peers[i];
                this.tracker_peer_cache.remove(peer.getIPAddress());
                this.tracker_peer_cache.put(peer.getIPAddress(), peer);
                ++i;
            }
            Iterator it = this.tracker_peer_cache.keySet().iterator();
            if (max > 0) {
                while (this.tracker_peer_cache.size() > max) {
                    it.next();
                    it.remove();
                }
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        List p2;
        if (map1 == null & map2 == null) {
            return new HashMap();
        }
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        HashMap res = new HashMap();
        ArrayList peers = (ArrayList)map1.get("tracker_peers");
        if (peers == null) {
            peers = new ArrayList();
        }
        if ((p2 = (List)map2.get("tracker_peers")) != null) {
            LGLogger.log(2, 1, 0, "TRTrackerClient: merged peer sets: p1 = " + peers.size() + ", p2 = " + p2.size());
            int i = 0;
            while (i < p2.size()) {
                peers.add(p2.get(i));
                ++i;
            }
        }
        res.put("tracker_peers", peers);
        return res;
    }

    protected TRTrackerResponsePeer[] getPeersFromCache() {
        int num_want;
        block5: {
            num_want = this.calculateNumWant() * 4;
            this.tracker_peer_cache_mon.enter();
            if (this.tracker_peer_cache.size() > num_want) break block5;
            TRTrackerResponsePeer[] res = new TRTrackerResponsePeer[this.tracker_peer_cache.size()];
            this.tracker_peer_cache.values().toArray(res);
            LGLogger.log(2, 1, 0, "TRTrackerClient: returned " + res.length + " cached peers");
            TRTrackerResponsePeer[] tRTrackerResponsePeerArray = res;
            this.tracker_peer_cache_mon.exit();
            return tRTrackerResponsePeerArray;
        }
        try {
            TRTrackerResponsePeer[] res = new TRTrackerResponsePeer[num_want];
            Iterator it = this.tracker_peer_cache.keySet().iterator();
            int i = 0;
            while (i < num_want) {
                String key = (String)it.next();
                res[i] = (TRTrackerResponsePeer)this.tracker_peer_cache.get(key);
                it.remove();
                ++i;
            }
            i = 0;
            while (i < num_want) {
                this.tracker_peer_cache.put(res[i].getIPAddress(), res[i]);
                ++i;
            }
            LGLogger.log(2, 1, 0, "TRTrackerClient: returned " + res.length + " cached peers");
            TRTrackerResponsePeer[] tRTrackerResponsePeerArray = res;
            this.tracker_peer_cache_mon.exit();
            return tRTrackerResponsePeerArray;
        }
        catch (Throwable throwable) {
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    public void parameterChanged(String parameterName) {
        if ("TCP.Announce.Port".equals(parameterName)) {
            this.setPort();
        }
    }
}

