/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport.base;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportDataReader;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class PEPeerTransportImpl
extends PEPeerTransportProtocol {
    private static final boolean TRACE = false;
    private SocketChannel socket;

    public PEPeerTransportImpl(PEPeerControl manager, String ip, int port) {
        super(manager, ip, port, false, null, null);
    }

    public PEPeerTransportImpl(PEPeerControl manager, SocketChannel sck, byte[] _leading_data) {
        super(manager, sck.socket().getInetAddress().getHostAddress(), sck.socket().getPort(), true, sck, _leading_data);
        this.socket = sck;
    }

    protected int readData(DirectByteBuffer buffer) throws IOException {
        PEPeerTransportDataReader data_reader_copy = this.getDataReader();
        SocketChannel socket_copy = this.socket;
        if (data_reader_copy == null) {
            throw new IOException("Not connected - data reader is null");
        }
        if (socket_copy == null) {
            throw new IOException("Not connected - socket is null");
        }
        return data_reader_copy.read(socket_copy, buffer);
    }

    protected void setChannel(SocketChannel channel) {
        this.socket = channel;
    }
}

