/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import com.aelitis.azureus.core.networkmanager.ConnectDisconnectManager;
import com.aelitis.azureus.core.peermanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.utils.PeerConnectInfoStorage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerManagerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerServerHelper;
import org.gudy.azureus2.core3.peer.impl.PEPeerStatsImpl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportDataReader;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.impl.PEPieceImpl;
import org.gudy.azureus2.core3.peer.impl.PEPieceWriteImpl;
import org.gudy.azureus2.core3.peer.impl.control.EndGameModeChunk;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPeer;
import org.gudy.azureus2.core3.peer.impl.control.SuperSeedPiece;
import org.gudy.azureus2.core3.peer.impl.transport.base.DataReaderOwner;
import org.gudy.azureus2.core3.peer.impl.transport.base.DataReaderSpeedLimiter;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerClient;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.TrackerClientAnnounceDataProvider;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.Md5Hasher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class PEPeerControlImpl
implements PEPeerControl,
ParameterListener,
DiskManagerWriteRequestListener,
DiskManagerCheckRequestListener {
    private static final int MIN_REQUESTS = 2;
    private static final int SLOPE_REQUESTS = 2048;
    private static final int MAX_REQUESTS = 64;
    private static final int BAD_CHUNKS_LIMIT = 3;
    private static final int WARNINGS_LIMIT = 3;
    private static boolean oldPolling = COConfigurationManager.getBooleanParameter("Old.Socket.Polling.Style", false);
    private static boolean disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed", true);
    private static IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private int peer_manager_state = 1;
    private int[] availability_cow;
    private boolean _bContinue;
    private volatile ArrayList peer_transports_cow = new ArrayList();
    private AEMonitor peer_transports_mon = new AEMonitor("PEPeerControl:PT");
    private DiskManager _diskManager;
    private DiskManagerPiece[] dm_pieces;
    private boolean[] _downloading;
    private boolean seeding_mode;
    private boolean restart_initiated;
    private boolean[] _piecesRarest;
    private PeerIdentityDataID _hash;
    private byte[] _myPeerId;
    private int _nbPieces;
    private PEPieceImpl[] _pieces;
    private PEPeerServerHelper _server;
    private PEPeerManagerStatsImpl _stats;
    private TRTrackerClient _tracker;
    private int _seeds;
    private int _peers;
    private int _remotes;
    private long _timeStarted;
    private long _timeStartedSeeding = -1L;
    private long _timeFinished;
    private Average _averageReceptionSpeed;
    private PEPeerTransport currentOptimisticUnchoke;
    private static final long END_GAME_MODE_SIZE_TRIGGER = 0x1400000L;
    private static final long END_GAME_MODE_TIMEOUT = 600000L;
    private boolean endGameMode;
    private boolean endGameModeAbandoned;
    private long timeEndGameModeEntered;
    private List endGameModeChunks;
    private AEMonitor endGameModeChunks_mon = new AEMonitor("PEPeerControl:EG");
    private DownloadManager _downloadManager;
    private PeerUpdater peerUpdater;
    private int nbHashFails;
    private static final int PEER_UPDATER_INTERVAL = 50;
    private long mainloop_loop_count;
    private static final int MAINLOOP_INTERVAL = 100;
    private static final int MAINLOOP_ONE_SECOND_INTERVAL = 10;
    private static final int MAINLOOP_FIVE_SECOND_INTERVAL = 50;
    private static final int MAINLOOP_TEN_SECOND_INTERVAL = 100;
    private static final int MAINLOOP_THIRTY_SECOND_INTERVAL = 300;
    private List peer_manager_listeners = new ArrayList();
    private List piece_check_result_list = new ArrayList();
    private AEMonitor piece_check_result_list_mon = new AEMonitor("PEPeerControl:PCRL");
    private boolean superSeedMode;
    private int superSeedModeCurrentPiece;
    private int superSeedModeNumberOfAnnounces;
    private SuperSeedPiece[] superSeedPieces;
    private final PeerConnectInfoStorage peer_info_storage = new PeerConnectInfoStorage(200);
    private final HashMap reconnect_counts = new HashMap();
    private final AEMonitor reconnect_counts_mon = new AEMonitor("PEPeerControl:RC");
    private AEMonitor this_mon = new AEMonitor("PEPeerControl");
    private long ip_filter_last_update_time;
    private Map user_data;
    private PEPeerTransportDataReader download_speed_limiter;
    private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return PEPeerControlImpl.this._downloadManager.getStats().getUploadRateLimitBytesPerSecond();
        }
    };
    private static final int FORCE_PIECE = -1;

    public PEPeerControlImpl(DownloadManager manager, PEPeerServerHelper server, TRTrackerClient tracker, DiskManager diskManager) {
        this._server = server;
        this._downloadManager = manager;
        this._tracker = tracker;
        this._diskManager = diskManager;
        COConfigurationManager.addParameterListener("Old.Socket.Polling.Style", this);
        COConfigurationManager.addParameterListener("Ip Filter Enabled", this);
        COConfigurationManager.addParameterListener("Disconnect Seed", this);
    }

    public DownloadManager getDownloadManager() {
        return this._downloadManager;
    }

    public int getState() {
        return this.peer_manager_state;
    }

    public void start() {
        this.endGameMode = false;
        try {
            this._hash = PeerIdentityManager.createDataID(this._tracker.getTorrent().getHash());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this._hash = PeerIdentityManager.createDataID(new byte[20]);
        }
        this.nbHashFails = 0;
        this._tracker.setAnnounceDataProvider(new TrackerClientAnnounceDataProvider(){

            public String getName() {
                return PEPeerControlImpl.this.getDownloadManager().getDisplayName();
            }

            public long getTotalSent() {
                return PEPeerControlImpl.this.getStats().getTotalSent();
            }

            public long getTotalReceived() {
                return PEPeerControlImpl.this.getStats().getTotalReceived();
            }

            public long getRemaining() {
                return PEPeerControlImpl.this.getRemaining();
            }
        });
        this._myPeerId = this._tracker.getPeerId();
        this.peer_transports_cow = new ArrayList();
        this._server.setServerAdapter(this);
        this.mainloop_loop_count = 0L;
        this._averageReceptionSpeed = Average.getInstance(1000, 30);
        this.download_speed_limiter = DataReaderSpeedLimiter.getSingleton().getDataReader(new DataReaderOwner(){

            public int getMaximumBytesPerSecond() {
                return PEPeerControlImpl.this._downloadManager.getStats().getMaxDownloadKBSpeed() * 1024;
            }
        });
        this.setDiskManager(this._diskManager);
        this.superSeedMode = COConfigurationManager.getBooleanParameter("Use Super Seeding") && this.getRemaining() == 0L;
        this.superSeedModeCurrentPiece = 0;
        if (this.superSeedMode) {
            this.initialiseSuperSeedMode();
        }
        this.peerUpdater = new PeerUpdater();
        this.peerUpdater.start();
        new AEThread("Peer Manager"){

            public void runSupport() {
                PEPeerControlImpl.this.mainLoop();
            }
        }.start();
    }

    private void mainLoop() {
        this._bContinue = true;
        this._downloadManager.setState(50);
        this._timeStarted = SystemTime.getCurrentTime();
        this.checkFinished(true);
        while (this._bContinue) {
            try {
                long timeStart = SystemTime.getCurrentTime();
                this.updateTrackerAnnounceInterval();
                this.doConnectionChecks();
                this.processPieceChecks();
                this.checkCompletedPieces();
                this.computeAvailability();
                this.updateStats();
                this.checkFastPieces();
                if (!this.seeding_mode) {
                    this._diskManager.computePriorityIndicator();
                    this.checkRequests();
                    this.checkDLPossible();
                }
                this.checkSeeds(false);
                this.updatePeersInSuperSeedMode();
                this.doUnchokes();
                long loop_time = SystemTime.getCurrentTime() - timeStart;
                if (loop_time < 100L && loop_time >= 0L) {
                    try {
                        Thread.sleep(100L - loop_time);
                    }
                    catch (Exception e) {}
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++this.mainloop_loop_count;
        }
    }

    public void stopAll() {
        this._tracker.stop();
        this._server.stopServer();
        this._server.clearServerAdapter();
        try {
            this.peer_transports_mon.enter();
            this._bContinue = false;
            while (this.peer_transports_cow.size() != 0) {
                this.removeFromPeerTransports((PEPeerTransport)this.peer_transports_cow.get(0), "Closing all Connections");
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        this.peerUpdater.stopIt();
        int i = 0;
        while (i < this._pieces.length) {
            if (this._pieces[i] != null) {
                this.pieceRemoved(this._pieces[i]);
            }
            ++i;
        }
        this.download_speed_limiter = null;
        COConfigurationManager.removeParameterListener("Old.Socket.Polling.Style", this);
        COConfigurationManager.removeParameterListener("Ip Filter Enabled", this);
        COConfigurationManager.removeParameterListener("Disconnect Seed", this);
    }

    private void analyseTrackerResponse(TRTrackerResponse tracker_response) {
        Map extensions;
        TRTrackerResponsePeer[] peers = tracker_response.getPeers();
        if (peers != null) {
            this.addPeersFromTracker(tracker_response.getPeers());
        }
        if ((extensions = tracker_response.getExtensions()) != null) {
            System.out.println("PEPeerControl: tracker response contained extensions");
            this.addExtendedPeersFromTracker(extensions);
        }
    }

    public void processTrackerResponse(TRTrackerResponse response) {
        if (this._bContinue) {
            this.analyseTrackerResponse(response);
        }
    }

    private void addExtendedPeersFromTracker(Map extensions) {
        Map protocols = (Map)extensions.get("protocols");
        Iterator protocol_it = protocols.keySet().iterator();
        while (protocol_it.hasNext()) {
            String protocol_name = (String)protocol_it.next();
            Map protocol = (Map)protocols.get(protocol_name);
            List transports = PEPeerTransportFactory.createExtendedTransports(this, protocol_name, protocol);
            int i = 0;
            while (i < transports.size()) {
                PEPeer transport = (PEPeer)transports.get(i);
                this.addPeer(transport);
                ++i;
            }
        }
    }

    public List getPeers() {
        return new ArrayList(this.peer_transports_cow);
    }

    public void addPeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        try {
            this.peer_transports_mon.enter();
            if (!this.peer_transports_cow.contains(transport)) {
                this.addToPeerTransports(transport);
            } else {
                transport.closeAll(String.valueOf(transport.getIp()) + ":" + transport.getPort() + ": Already Connected", false, false);
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
    }

    public void removePeer(PEPeer _transport) {
        if (!(_transport instanceof PEPeerTransport)) {
            throw new RuntimeException("invalid class");
        }
        PEPeerTransport transport = (PEPeerTransport)_transport;
        this.removeFromPeerTransports(transport, "Peer Removed");
    }

    private void addPeersFromTracker(TRTrackerResponsePeer[] peers) {
        int i = 0;
        while (i < peers.length) {
            TRTrackerResponsePeer peer = peers[i];
            ArrayList peer_transports = this.peer_transports_cow;
            boolean already_connected = false;
            int x = 0;
            while (x < peer_transports.size()) {
                boolean same_allowed;
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(x);
                if (peer.getIPAddress().equals(transport.getIp()) && (!(same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers")) || peer.getPort() == transport.getPort())) {
                    already_connected = true;
                    break;
                }
                ++x;
            }
            if (!already_connected) {
                this.peer_info_storage.addPeerInfo(new PeerConnectInfoStorage.PeerInfo(peer.getIPAddress(), peer.getPort()));
            }
            ++i;
        }
    }

    private boolean makeNewOutgoingConnection(String address, int port) {
        if (ip_filter.isInRange(address, this._downloadManager.getDisplayName())) {
            return false;
        }
        int needed = PeerUtils.numNewConnectionsAllowed(this._hash);
        if (needed == 0) {
            return false;
        }
        PEPeerTransport real = PEPeerTransportFactory.createTransport(this, address, port);
        this.addToPeerTransports(real);
        return true;
    }

    private void checkCompletedPieces() {
        int i = 0;
        while (i < this._nbPieces) {
            PEPieceImpl currentPiece = this._pieces[i];
            if (currentPiece != null && currentPiece.isComplete() && !currentPiece.isBeingChecked()) {
                currentPiece.setBeingChecked();
                this._diskManager.enqueueCheckRequest(i, this, new Boolean(false));
            }
            ++i;
        }
    }

    private void checkFastPieces() {
        long currentTime = SystemTime.getCurrentTime();
        int i = 0;
        while (i < this._nbPieces) {
            PEPieceImpl currentPiece = this._pieces[i];
            if (currentPiece != null && !currentPiece.isSlowPiece() && currentTime - currentPiece.getLastWriteTime() > 30000L) {
                currentPiece.setSlowPiece(true);
            }
            ++i;
        }
    }

    private void processPieceChecks() {
        if (this.piece_check_result_list.size() > 0) {
            ArrayList pieces;
            try {
                this.piece_check_result_list_mon.enter();
                pieces = new ArrayList(this.piece_check_result_list);
                this.piece_check_result_list.clear();
            }
            finally {
                this.piece_check_result_list_mon.exit();
            }
            Iterator it = pieces.iterator();
            while (it.hasNext()) {
                Object[] data = (Object[])it.next();
                this.processPieceCheckResult((Integer)data[0], (Boolean)data[1], data[2]);
            }
        }
    }

    private void checkDLPossible() {
        PEPeerTransport pc;
        ArrayList bestUploaders = new ArrayList();
        ArrayList peer_transports = this.peer_transports_cow;
        long[] upRates = new long[peer_transports.size()];
        Arrays.fill(upRates, -1L);
        int i = 0;
        while (i < peer_transports.size()) {
            pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.transferAvailable()) {
                long upRate = pc.getStats().getReception();
                this.updateLargestValueFirstSort(upRate, upRates, pc, bestUploaders, 0);
            }
            ++i;
        }
        this.checkEndGameMode();
        i = 0;
        while (i < bestUploaders.size()) {
            pc = (PEPeerTransport)bestUploaders.get(i);
            if (pc.transferAvailable()) {
                boolean found = true;
                int maxRequests = 2 + (int)(pc.getStats().getDownloadAverage() / 2048L);
                if (maxRequests > 64 || maxRequests < 0) {
                    maxRequests = 64;
                }
                if (this.endGameMode) {
                    maxRequests = 2;
                }
                if (pc.isSnubbed()) {
                    maxRequests = 1;
                }
                if (pc.getNbRequests() <= 3 * maxRequests / 5) {
                    while (pc.isReadyToRequest() && pc.getState() == 30 && found && pc.getNbRequests() < maxRequests) {
                        found = this.endGameMode ? this.findPieceInEndGameMode(pc) : this.findPieceToDownload(pc);
                    }
                }
            }
            ++i;
        }
    }

    private void checkFinished(boolean start_of_day) {
        this.seeding_mode = true;
        int i = 0;
        while (i < this._nbPieces) {
            boolean bl = this.seeding_mode = this.seeding_mode && this.dm_pieces[i].getDone();
            if (!this.seeding_mode) break;
            ++i;
        }
        if (this.seeding_mode) {
            if (this.endGameMode) {
                try {
                    this.endGameModeChunks_mon.enter();
                    this.endGameMode = false;
                    this.endGameModeChunks.clear();
                }
                finally {
                    this.endGameModeChunks_mon.exit();
                }
            }
            this._downloadManager.setState(55);
            this._timeFinished = SystemTime.getCurrentTime();
            ArrayList peer_transports = this.peer_transports_cow;
            int i2 = 0;
            while (i2 < peer_transports.size()) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i2);
                pc.setSnubbed(false);
                ++i2;
            }
            this.checkSeeds(true);
            boolean checkPieces = COConfigurationManager.getBooleanParameter("Check Pieces on Completion", true);
            if (checkPieces && !start_of_day) {
                this._diskManager.enqueueCompleteRecheckRequest(this, new Boolean(true));
            }
            this._diskManager.downloadEnded();
            this._timeStartedSeeding = SystemTime.getCurrentTime();
            this._downloadManager.setState(60);
            if (!start_of_day) {
                this._downloadManager.downloadEnded();
            }
            this._tracker.complete(start_of_day);
        }
    }

    private void checkRequests() {
        ArrayList peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            List expired;
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getState() == 30 && (expired = pc.getExpiredRequests()) != null && expired.size() > 0) {
                pc.setSnubbed(true);
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)expired.get(0);
                long wait_time = SystemTime.getCurrentTime() - request2.getTimeCreated();
                if (wait_time < 0L) {
                    request2.reSetTime();
                }
                if (wait_time > 120000L) {
                    int pieceNumber = request2.getPieceNumber();
                    int pieceOffset = request2.getOffset();
                    PEPieceImpl piece = this._pieces[pieceNumber];
                    if (piece != null) {
                        piece.unmarkBlock(pieceOffset / 16384);
                    }
                    this._downloading[pieceNumber] = false;
                    pc.sendCancel(request2);
                }
                int j = 1;
                while (j < expired.size()) {
                    request2 = (DiskManagerReadRequest)expired.get(j);
                    pc.sendCancel(request2);
                    int pieceNumber = request2.getPieceNumber();
                    int pieceOffset = request2.getOffset();
                    PEPieceImpl piece = this._pieces[pieceNumber];
                    if (piece != null) {
                        piece.unmarkBlock(pieceOffset / 16384);
                    }
                    this._downloading[pieceNumber] = false;
                    ++j;
                }
            }
            ++i;
        }
    }

    private void updateTrackerAnnounceInterval() {
        if (this.mainloop_loop_count % 50L != 0L) {
            return;
        }
        int percentage = 100;
        int LIMIT = 200;
        if (this._downloadManager.getState() == 50 || this._downloadManager.getState() == 60) {
            int currConnectionCount;
            int swarmSize;
            int num_pending;
            boolean has_remote;
            int num_wanted = PeerUtils.numNewConnectionsAllowed(this._hash);
            boolean bl = has_remote = this._downloadManager.getHealthStatus() == 4;
            if (has_remote) {
                num_wanted = (int)((double)num_wanted / 1.5);
            }
            if (num_wanted < 0 || num_wanted > 200) {
                num_wanted = 200;
            }
            if ((num_wanted -= (num_pending = this.peer_info_storage.getStoredCount())) < 0) {
                num_wanted = 0;
            }
            TRTrackerScraperResponse tsr = this._downloadManager.getTrackerScrapeResponse();
            int swarmPeers = -1;
            int swarmSeeds = -1;
            if (tsr != null && tsr.isValid()) {
                swarmPeers = tsr.getPeers();
                swarmSeeds = tsr.getSeeds();
            }
            int n = swarmSize = this.seeding_mode ? swarmPeers : swarmPeers + swarmSeeds;
            if (swarmSize > 0 && num_wanted > swarmSize) {
                num_wanted = swarmSize;
            }
            if ((currConnectionCount = PeerIdentityManager.getIdentityCount(this._hash)) == 0) {
                percentage = 0;
            } else if (num_wanted >= 0) {
                float currConnectionPercent = (float)currConnectionCount / (float)(currConnectionCount + num_wanted);
                percentage = (int)(currConnectionPercent * 100.0f);
            }
            this._tracker.setRefreshDelayOverrides(percentage);
        }
    }

    private void computeAvailability() {
        if (this.mainloop_loop_count % 10L != 0L) {
            return;
        }
        int[] new_availability = new int[this.availability_cow.length];
        ArrayList peer_transports = this.peer_transports_cow;
        int i = peer_transports.size() - 1;
        while (i >= 0) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            boolean[] piecesAvailable = pc.getAvailable();
            if (piecesAvailable != null) {
                int j = this._nbPieces - 1;
                while (j >= 0) {
                    if (piecesAvailable[j]) {
                        int n = j;
                        new_availability[n] = new_availability[n] + 1;
                    }
                    --j;
                }
            }
            --i;
        }
        i = this.dm_pieces.length - 1;
        while (i >= 0) {
            if (this.dm_pieces[i].getDone()) {
                int n = i;
                new_availability[n] = new_availability[n] + 1;
            }
            --i;
        }
        this.availability_cow = new_availability;
    }

    private boolean findPieceToDownload(PEPeerTransport pc) {
        boolean slowPeer = pc.getStats().getDownloadAverage() < 2048L;
        this.getRarestPieces(pc, 90, false);
        if (this._piecesRarest == null) {
            return false;
        }
        int nbPiecesRarest = 0;
        int i = 0;
        while (i < this._piecesRarest.length) {
            if (this._piecesRarest[i]) {
                ++nbPiecesRarest;
            }
            ++i;
        }
        if (nbPiecesRarest == 0) {
            return false;
        }
        int pieceNumber = -1;
        int blockNumber = -1;
        int lastCompleted = -1;
        int i2 = 0;
        while (i2 < this._nbPieces) {
            if (this._piecesRarest[i2] && this._pieces[i2] != null && !this._downloading[i2]) {
                int tempBlock = this._pieces[i2].getAndMarkBlock();
                if (tempBlock != -1) {
                    if (this._pieces[i2].getCompleted() > lastCompleted && (slowPeer == this._pieces[i2].isSlowPiece() || this._pieces[i2].isSlowPiece() && SystemTime.getCurrentTime() - this._pieces[i2].getLastWriteTime() > 120000L)) {
                        if (pieceNumber != -1) {
                            this._pieces[pieceNumber].unmarkBlock(blockNumber);
                        }
                        pieceNumber = i2;
                        blockNumber = tempBlock;
                        lastCompleted = this._pieces[i2].getCompleted();
                    } else {
                        this._pieces[i2].unmarkBlock(tempBlock);
                    }
                } else {
                    this._downloading[i2] = true;
                    this._piecesRarest[i2] = false;
                    --nbPiecesRarest;
                }
            }
            ++i2;
        }
        if (pieceNumber != -1 && blockNumber != -1) {
            this._pieces[pieceNumber].setSlowPiece(slowPeer);
            pc.request(pieceNumber, blockNumber * 16384, this._pieces[pieceNumber].getBlockSize(blockNumber));
            return true;
        }
        if (nbPiecesRarest == 0) {
            return false;
        }
        this.getRarestPieces(pc, 20, true);
        pieceNumber = this._diskManager.getPieceNumberToDownload(this._piecesRarest);
        if (pieceNumber == -1) {
            return false;
        }
        PEPieceImpl piece = null;
        piece = new PEPieceImpl(this, this.dm_pieces[pieceNumber], slowPeer, false);
        this.pieceAdded(piece);
        this._pieces[pieceNumber] = piece;
        blockNumber = piece.getAndMarkBlock();
        pc.request(pieceNumber, blockNumber * 16384, piece.getBlockSize(blockNumber));
        return true;
    }

    private void getRarestPieces(PEPeerTransport pc, int rangePercent, boolean onlyNonAllocatedPieces) {
        boolean[] piecesAvailable = pc.getAvailable();
        Arrays.fill(this._piecesRarest, false);
        int max_avail = this._peers * 2 / 3;
        int pieceMinAvailability = -1;
        int[] availability = this.availability_cow;
        int i = 0;
        while (i < this._nbPieces) {
            if (!(this.dm_pieces[i].getDone() || this._downloading[i] || !piecesAvailable[i] || pieceMinAvailability != -1 && availability[i] >= pieceMinAvailability)) {
                pieceMinAvailability = availability[i];
            }
            ++i;
        }
        if (pieceMinAvailability > 10 && pieceMinAvailability < 9999) {
            pieceMinAvailability = 9999;
        }
        pieceMinAvailability = (100 + rangePercent) * pieceMinAvailability / 100;
        if (!onlyNonAllocatedPieces && pieceMinAvailability < max_avail && !pc.isSeed()) {
            pieceMinAvailability = max_avail;
        }
        i = 0;
        while (i < this._nbPieces) {
            if (!(this.dm_pieces[i].getDone() || this._downloading[i] || !piecesAvailable[i] || availability[i] > pieceMinAvailability || onlyNonAllocatedPieces && this._pieces[i] != null)) {
                this._piecesRarest[i] = true;
            }
            ++i;
        }
    }

    private void insertPeerSocket(PEPeerTransport ps) {
        try {
            this.this_mon.enter();
            boolean addFailed = false;
            String reason = "";
            if (!ip_filter.isInRange(ps.getIp(), this._downloadManager.getDisplayName())) {
                try {
                    this.peer_transports_mon.enter();
                    if (!this.peer_transports_cow.contains(ps)) {
                        this.addToPeerTransports(ps);
                    }
                    addFailed = true;
                    reason = String.valueOf(ps.getIp()) + " : Already Connected";
                }
                finally {
                    this.peer_transports_mon.exit();
                }
            } else {
                addFailed = true;
                reason = String.valueOf(ps.getIp()) + " : Blocked IP";
            }
            if (addFailed) {
                ps.closeAll(reason, false, false);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void doUnchokes() {
        int max_to_unchoke = this._downloadManager.getStats().getMaxUploads();
        List unchoked_peers = this.getUnchokedPeers();
        if (unchoked_peers.size() < max_to_unchoke) {
            ArrayList peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc.isInterestedInMe() && pc.isChokedByMe() && !pc.isSnubbed()) {
                    pc.sendUnChoke();
                    unchoked_peers.add(pc);
                    if (unchoked_peers.size() == max_to_unchoke) break;
                }
                ++i;
            }
        }
        if (this.mainloop_loop_count % 100L == 0L) {
            PEPeerTransport pc;
            boolean refresh = this.mainloop_loop_count % 300L == 0L || this.currentOptimisticUnchoke == null;
            List best_peers = this.getBestPeersToUnchoke(max_to_unchoke, refresh);
            unchoked_peers.removeAll(best_peers);
            int i = 0;
            while (i < unchoked_peers.size()) {
                pc = (PEPeerTransport)unchoked_peers.get(i);
                pc.sendChoke();
                ++i;
            }
            i = 0;
            while (i < best_peers.size()) {
                pc = (PEPeerTransport)best_peers.get(i);
                if (pc.isChokedByMe()) {
                    pc.sendUnChoke();
                }
                ++i;
            }
        }
    }

    private List getUnchokedPeers() {
        ArrayList<PEPeerTransport> unchoked = new ArrayList<PEPeerTransport>();
        ArrayList peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (!pc.isChokedByMe()) {
                unchoked.add(pc);
            }
            ++i;
        }
        return unchoked;
    }

    private List getBestPeersToUnchoke(int max_wanted, boolean refresh_opt_unchoke) {
        int sort_start_pos;
        long[] best_rates = new long[--max_wanted];
        ArrayList<PEPeerTransport> best_peers = new ArrayList<PEPeerTransport>();
        ArrayList peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc != this.currentOptimisticUnchoke || refresh_opt_unchoke) {
                boolean interesting;
                boolean bl = interesting = this.seeding_mode ? true : pc.isInterestingToMe();
                if (interesting && pc.isInterestedInMe() && !pc.isSnubbed()) {
                    long upRate;
                    long l = upRate = this.seeding_mode ? pc.getStats().getUploadAverage() : pc.getStats().getReception();
                    if (upRate > 256L) {
                        this.updateLargestValueFirstSort(upRate, best_rates, pc, best_peers, 0);
                    }
                }
            }
            ++i;
        }
        if (!this.seeding_mode && best_peers.size() < max_wanted) {
            sort_start_pos = best_peers.size();
            int i2 = 0;
            while (i2 < peer_transports.size()) {
                long uploaded_ratio;
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i2);
                if ((pc != this.currentOptimisticUnchoke || refresh_opt_unchoke) && pc.isInterestingToMe() && pc.isInterestedInMe() && !pc.isSnubbed() && !best_peers.contains(pc) && (uploaded_ratio = pc.getStats().getTotalSent() / (pc.getStats().getTotalReceived() + 16383L)) < 10L) {
                    this.updateLargestValueFirstSort(pc.getStats().getTotalReceived(), best_rates, pc, best_peers, sort_start_pos);
                }
                ++i2;
            }
        }
        if (best_peers.size() < max_wanted) {
            sort_start_pos = best_peers.size();
            int i3 = 0;
            while (i3 < peer_transports.size()) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i3);
                if (pc != this.currentOptimisticUnchoke || refresh_opt_unchoke) {
                    boolean allowed;
                    boolean bl = this.seeding_mode ? !pc.isSnubbed() : (allowed = true);
                    if (pc.isInterestedInMe() && allowed && !best_peers.contains(pc)) {
                        long total = pc.getStats().getTotalReceived();
                        if (total == 0L) {
                            total = 1000 - pc.getPercentDoneInThousandNotation();
                        }
                        this.updateLargestValueFirstSort(total, best_rates, pc, best_peers, sort_start_pos);
                    }
                }
                ++i3;
            }
        }
        if (refresh_opt_unchoke) {
            int index = 0;
            if (this.currentOptimisticUnchoke != null) {
                index = peer_transports.indexOf(this.currentOptimisticUnchoke) + 1;
                index = index >= peer_transports.size() ? 0 : index;
            }
            this.currentOptimisticUnchoke = null;
            int i4 = index;
            while (i4 < peer_transports.size() + index) {
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i4 % peer_transports.size());
                if (!pc.isSeed() && pc.isInterestedInMe() && !pc.isSnubbed() && !best_peers.contains(pc)) {
                    this.currentOptimisticUnchoke = pc;
                    break;
                }
                ++i4;
            }
        }
        if (this.currentOptimisticUnchoke != null) {
            best_peers.add(this.currentOptimisticUnchoke);
        }
        return best_peers;
    }

    private void updateLargestValueFirstSort(long new_value, long[] values, PEPeerTransport new_item, List items, int start_pos) {
        int i = start_pos;
        while (i < values.length) {
            if (new_value >= values[i]) {
                int j = values.length - 2;
                while (j >= i) {
                    values[j + 1] = values[j];
                    --j;
                }
                values[i] = new_value;
                items.add(i, new_item);
                if (items.size() > values.length) {
                    items.remove(values.length);
                }
                return;
            }
            ++i;
        }
    }

    private void sendHave(int pieceNumber) {
        ArrayList peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            pc.sendHave(pieceNumber);
            ++i;
        }
    }

    private void checkSeeds(boolean forceDisconnect) {
        if (!forceDisconnect && this.mainloop_loop_count % 10L != 0L) {
            return;
        }
        if (!(forceDisconnect || this.seeding_mode && disconnect_seeds_when_seeding)) {
            return;
        }
        ArrayList peer_transports = this.peer_transports_cow;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc != null && pc.getState() == 30 && pc.isSeed()) {
                pc.closeAll(String.valueOf(pc.getIp()) + " : Disconnecting seeds when seed", false, false);
            }
            ++i;
        }
    }

    private void updateStats() {
        ArrayList peer_transports = this.peer_transports_cow;
        this._remotes = 0;
        this._peers = 0;
        this._seeds = 0;
        int i = 0;
        while (i < peer_transports.size()) {
            PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
            if (pc.getState() == 30) {
                if (pc.isSeed()) {
                    ++this._seeds;
                } else {
                    ++this._peers;
                }
                if (pc.isIncoming()) {
                    ++this._remotes;
                }
            }
            ++i;
        }
    }

    public void requestCanceled(DiskManagerReadRequest request2) {
        int pieceNumber = request2.getPieceNumber();
        int pieceOffset = request2.getOffset();
        PEPieceImpl piece = this._pieces[pieceNumber];
        if (piece != null) {
            piece.unmarkBlock(pieceOffset / 16384);
        }
        this._downloading[pieceNumber] = false;
    }

    public void addPeerTransport(Object param) {
        this.insertPeerSocket(this._server.createPeerTransport(param));
    }

    public PEPeerControl getControl() {
        return this;
    }

    public byte[] getHash() {
        return this._hash.getDataID();
    }

    public PeerIdentityDataID getPeerIdentityDataID() {
        return this._hash;
    }

    public byte[] getPeerId() {
        return this._myPeerId;
    }

    public int getPiecesNumber() {
        return this._nbPieces;
    }

    public long getRemaining() {
        return this._diskManager.getRemaining();
    }

    public void received(int length) {
        if (length > 0) {
            this._stats.received(length);
            this._averageReceptionSpeed.addValue(length);
        }
        this._downloadManager.getStats().received(length);
    }

    public void discarded(int length) {
        if (length > 0) {
            this._stats.discarded(length);
        }
        this._downloadManager.getStats().discarded(length);
    }

    public void sent(int length) {
        if (length > 0) {
            this._stats.sent(length);
        }
        this._downloadManager.getStats().sent(length);
    }

    public void protocol_sent(int length) {
    }

    protected void setDiskManager(DiskManager diskManager) {
        this._diskManager = diskManager;
        this.dm_pieces = this._diskManager.getPieces();
        this._nbPieces = this._diskManager.getNumberOfPieces();
        this._downloading = new boolean[this._nbPieces];
        Arrays.fill(this._downloading, false);
        this._piecesRarest = new boolean[this._nbPieces];
        this._pieces = new PEPieceImpl[this.dm_pieces.length];
        int i = 0;
        while (i < this.dm_pieces.length) {
            DiskManagerPiece dm_piece = this.dm_pieces[i];
            if (!dm_piece.getDone() && dm_piece.getCompleteCount() > 0) {
                this._pieces[i] = new PEPieceImpl(this, dm_piece, true, true);
                this.pieceAdded(this._pieces[i]);
            }
            ++i;
        }
        this.availability_cow = new int[this._nbPieces];
        this._stats = new PEPeerManagerStatsImpl();
        this._server.startServer();
    }

    public void blockWritten(int pieceNumber, int offset, Object user_data) {
        PEPieceImpl piece = this._pieces[pieceNumber];
        if (piece != null) {
            piece.setWritten((PEPeer)user_data, offset / 16384);
        }
    }

    public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender) {
        PEPieceImpl piece = this._pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (piece != null && !piece.isWritten(blockNumber)) {
            piece.setBlockWritten(blockNumber);
            this._diskManager.enqueueWriteRequest(pieceNumber, offset, data, sender, this);
            if (this.endGameMode) {
                this.removeFromEndGameModeChunks(pieceNumber, offset);
                ArrayList peer_transports = this.peer_transports_cow;
                int i = 0;
                while (i < peer_transports.size()) {
                    PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                    DiskManagerReadRequest dmr = this._diskManager.createReadRequest(pieceNumber, offset, piece.getBlockSize(blockNumber));
                    connection.sendCancel(dmr);
                    ++i;
                }
            }
        } else {
            data.returnToPool();
        }
    }

    public void writeBlockAndCancelOutstanding(int pieceNumber, int offset, DirectByteBuffer data, PEPeer sender) {
        PEPieceImpl piece = this._pieces[pieceNumber];
        int blockNumber = offset / 16384;
        if (piece != null && !piece.isWritten(blockNumber)) {
            piece.setBlockWritten(blockNumber);
            this._diskManager.enqueueWriteRequest(pieceNumber, offset, data, sender, this);
            ArrayList peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport connection = (PEPeerTransport)peer_transports.get(i);
                DiskManagerReadRequest dmr = this._diskManager.createReadRequest(pieceNumber, offset, piece.getBlockSize(blockNumber));
                connection.sendCancel(dmr);
                ++i;
            }
        } else {
            data.returnToPool();
        }
    }

    public boolean isBlockAlreadyWritten(int piece_number, int offset) {
        PEPieceImpl piece = this._pieces[piece_number];
        int block_number = offset / 16384;
        return piece != null && piece.isWritten(block_number);
    }

    public boolean checkBlock(int pieceNumber, int offset, int length) {
        return this._diskManager.checkBlockConsistency(pieceNumber, offset, length);
    }

    public boolean checkBlock(int pieceNumber, int offset, DirectByteBuffer data) {
        return this._diskManager.checkBlockConsistency(pieceNumber, offset, data);
    }

    public int getAvailability(int pieceNumber) {
        if (this.availability_cow == null) {
            return 0;
        }
        return this.availability_cow[pieceNumber];
    }

    public float getMinAvailability() {
        if (this.availability_cow == null) {
            return 0.0f;
        }
        int[] availability = this.availability_cow;
        int total = 0;
        int nbPieces = availability.length;
        if (nbPieces == 0) {
            return 0.0f;
        }
        int allMin = availability[0];
        int i = 0;
        while (i < nbPieces) {
            if (availability[i] < allMin) {
                allMin = availability[i];
            }
            ++i;
        }
        i = 0;
        while (i < nbPieces) {
            if (availability[i] > allMin) {
                ++total;
            }
            ++i;
        }
        return (float)allMin + (float)total / (float)nbPieces;
    }

    public int[] getAvailability() {
        return this.availability_cow;
    }

    public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
        int availability;
        this._stats.haveNewPiece(pieceLength);
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(pcOrigin);
            if (pieceNumber == pcOrigin.getUniqueAnnounce()) {
                pcOrigin.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
        if ((availability = this.availability_cow[pieceNumber]) < 4) {
            if (this.dm_pieces[pieceNumber].getDone()) {
                --availability;
            }
            if (availability <= 0) {
                return;
            }
            ArrayList peer_transports = this.peer_transports_cow;
            int i = peer_transports.size() - 1;
            while (i >= 0) {
                boolean[] peerAvailable;
                PEPeerTransport pc = (PEPeerTransport)peer_transports.get(i);
                if (pc != pcOrigin && pc.getState() == 30 && (peerAvailable = pc.getAvailable())[pieceNumber]) {
                    ((PEPeerStatsImpl)pc.getStats()).statisticSent(pieceLength / availability);
                }
                --i;
            }
        }
    }

    public int getPieceLength(int pieceNumber) {
        if (pieceNumber == this._nbPieces - 1) {
            return this._diskManager.getLastPieceLength();
        }
        return this._diskManager.getPieceLength();
    }

    public int getNbPeers() {
        return this._peers;
    }

    public int getNbSeeds() {
        return this._seeds;
    }

    public int getNbRemoteConnections() {
        return this._remotes;
    }

    public PEPeerManagerStats getStats() {
        return this._stats;
    }

    public long getETA() {
        long lETA;
        int writtenNotChecked = 0;
        int i = 0;
        while (i < this._pieces.length) {
            if (this._pieces[i] != null) {
                writtenNotChecked += this._pieces[i].getCompleted() * 16384;
            }
            ++i;
        }
        long dataRemaining = this._diskManager.getRemaining() - (long)writtenNotChecked;
        if (dataRemaining == 0L) {
            long timeElapsed = (this._timeFinished - this._timeStarted) / 1000L;
            if (timeElapsed > 1L) {
                return timeElapsed * -1L;
            }
            return 0L;
        }
        long averageSpeed = this._averageReceptionSpeed.getAverage();
        long l = lETA = averageSpeed == 0L ? 31536000L : dataRemaining / averageSpeed;
        if (lETA == 0L) {
            lETA = 1L;
        }
        return lETA;
    }

    private void addToPeerTransports(PEPeerTransport peer) {
        try {
            this.peer_transports_mon.enter();
            if (!this._bContinue) {
                throw new RuntimeException("PeerTransport added when manager not running");
            }
            if (this.peer_transports_cow.contains(peer)) {
                Debug.out("Transport added twice");
            } else {
                ArrayList<PEPeerTransport> new_peer_transports = new ArrayList<PEPeerTransport>(this.peer_transports_cow.size() + 1);
                new_peer_transports.addAll(this.peer_transports_cow);
                new_peer_transports.add(peer);
                this.peer_transports_cow = new_peer_transports;
                this.peerAdded(peer);
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
    }

    private void removeFromPeerTransports(PEPeerTransport peer, String reason) {
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                this.peerRemoved(peer);
                peer.closeAll(String.valueOf(peer.getIp()) + ": " + reason, false, false);
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
    }

    public void peerConnectionClosed(PEPeerTransport peer, boolean reconnect) {
        boolean connection_found = false;
        try {
            this.peer_transports_mon.enter();
            if (this.peer_transports_cow.contains(peer)) {
                connection_found = true;
                ArrayList new_peer_transports = new ArrayList(this.peer_transports_cow);
                new_peer_transports.remove(peer);
                this.peer_transports_cow = new_peer_transports;
                this.peerRemoved(peer);
            }
        }
        finally {
            this.peer_transports_mon.exit();
        }
        if (connection_found) {
            String key = String.valueOf(peer.getIp()) + ":" + peer.getPort();
            if (reconnect) {
                boolean reconnect_allowed = false;
                try {
                    this.reconnect_counts_mon.enter();
                    Integer reconnect_count = (Integer)this.reconnect_counts.get(key);
                    int count = 0;
                    if (reconnect_count != null) {
                        count = reconnect_count;
                    }
                    if (count < 3) {
                        this.reconnect_counts.put(key, new Integer(count + 1));
                        reconnect_allowed = true;
                    } else {
                        LGLogger.log(0, "Reconnect aborted: already reconnected 3 times this session.");
                        this.reconnect_counts.remove(key);
                    }
                }
                finally {
                    this.reconnect_counts_mon.exit();
                }
                if (reconnect_allowed) {
                    this.makeNewOutgoingConnection(peer.getIp(), peer.getPort());
                }
            } else {
                try {
                    this.reconnect_counts_mon.enter();
                    this.reconnect_counts.remove(key);
                }
                finally {
                    this.reconnect_counts_mon.exit();
                }
            }
        }
    }

    public void peerAdded(PEPeer pc) {
        this._downloadManager.addPeer(pc);
    }

    public void peerRemoved(PEPeer pc) {
        int piece = pc.getUniqueAnnounce();
        if (piece != -1 && this.superSeedMode) {
            --this.superSeedModeNumberOfAnnounces;
            this.superSeedPieces[piece].peerLeft();
        }
        if (pc == this.currentOptimisticUnchoke) {
            this.currentOptimisticUnchoke = null;
        }
        this._downloadManager.removePeer(pc);
    }

    public void pieceAdded(PEPiece p) {
        this._downloadManager.addPiece(p);
    }

    public void pieceRemoved(PEPiece p) {
        this._downloadManager.removePiece(p);
    }

    public String getElapsedTime() {
        return TimeFormatter.format((SystemTime.getCurrentTime() - this._timeStarted) / 1000L);
    }

    public long getTimeStarted() {
        return this._timeStarted;
    }

    public long getTimeStartedSeeding() {
        return this._timeStartedSeeding;
    }

    private byte[] computeMd5Hash(DirectByteBuffer buffer) {
        Md5Hasher md5 = new Md5Hasher();
        md5.reset();
        int position = buffer.position((byte)8);
        md5.update(buffer.getBuffer((byte)8));
        buffer.position((byte)8, position);
        ByteBuffer md5Result = ByteBuffer.allocate(16);
        md5Result.position(0);
        md5.finalDigest(md5Result);
        byte[] result = new byte[16];
        md5Result.position(0);
        int i = 0;
        while (i < result.length) {
            result[i] = md5Result.get();
            ++i;
        }
        return result;
    }

    private void MD5CheckPiece(PEPiece piece, boolean correct) {
        PEPeer[] writers = piece.getWriters();
        int offset = 0;
        int i = 0;
        while (i < writers.length) {
            DirectByteBuffer buffer;
            int length = piece.getBlockSize(i);
            PEPeer peer = writers[i];
            if (peer != null && (buffer = this._diskManager.readBlock(piece.getPieceNumber(), offset, length)) != null) {
                byte[] hash = this.computeMd5Hash(buffer);
                buffer.returnToPool();
                buffer = null;
                piece.addWrite(i, peer, hash, correct);
            }
            offset += length;
            ++i;
        }
    }

    public void pieceChecked(int pieceNumber, boolean result, Object user_data) {
        try {
            this.piece_check_result_list_mon.enter();
            this.piece_check_result_list.add(new Object[]{new Integer(pieceNumber), new Boolean(result), user_data});
        }
        finally {
            this.piece_check_result_list_mon.exit();
        }
    }

    private void processPieceCheckResult(int pieceNumber, boolean result, Object user_data) {
        block30: {
            boolean recheck_on_completion = (Boolean)user_data;
            try {
                PEPieceImpl piece = this._pieces[pieceNumber];
                if (result && piece != null) {
                    this.pieceRemoved(piece);
                }
                if (recheck_on_completion) {
                    if (!result) {
                        Debug.out("Piece #" + pieceNumber + " failed final re-check. Re-downloading...");
                        if (!this.restart_initiated) {
                            this.restart_initiated = true;
                            this._downloadManager.restartDownload(false);
                        }
                    }
                    if (!this.seeding_mode) {
                        this.checkFinished(false);
                    }
                    return;
                }
                if (result) {
                    if (piece != null) {
                        List list;
                        if (this.needsMD5CheckOnCompletion(pieceNumber)) {
                            this.MD5CheckPiece(piece, true);
                        }
                        if ((list = piece.getPieceWrites()).size() > 0) {
                            int i = 0;
                            while (i < piece.getNbBlocs()) {
                                List listPerBlock = piece.getPieceWrites(i);
                                byte[] correctHash = null;
                                Iterator iterPerBlock = listPerBlock.iterator();
                                while (iterPerBlock.hasNext()) {
                                    PEPieceWriteImpl write = (PEPieceWriteImpl)iterPerBlock.next();
                                    if (!write.isCorrect()) continue;
                                    correctHash = write.getHash();
                                }
                                if (correctHash != null) {
                                    ArrayList<PEPeer> peersToDisconnect = new ArrayList<PEPeer>();
                                    iterPerBlock = listPerBlock.iterator();
                                    while (iterPerBlock.hasNext()) {
                                        PEPieceWriteImpl write = (PEPieceWriteImpl)iterPerBlock.next();
                                        if (!Arrays.equals(write.getHash(), correctHash)) {
                                            PEPeer peer = write.getSender();
                                            peer.hasSentABadChunk();
                                            if (!peersToDisconnect.contains(peer)) {
                                                peersToDisconnect.add(peer);
                                            }
                                        }
                                        Iterator iterPeers = peersToDisconnect.iterator();
                                        while (iterPeers.hasNext()) {
                                            PEPeer peer = (PEPeer)iterPeers.next();
                                            this.badPeerDetected(peer);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                    this._pieces[pieceNumber] = null;
                    this.sendHave(pieceNumber);
                    break block30;
                }
                if (piece != null) {
                    this.MD5CheckPiece(piece, false);
                    PEPeer[] writers = piece.getWriters();
                    if (writers.length > 0 && writers[0] != null) {
                        PEPeer writer = writers[0];
                        boolean uniqueWriter = true;
                        int i = 1;
                        while (i < writers.length) {
                            uniqueWriter = uniqueWriter && writer.equals(writers[i]);
                            ++i;
                        }
                        if (uniqueWriter) {
                            i = 0;
                            while (i < writers.length) {
                                writer.hasSentABadChunk();
                                ++i;
                            }
                            this.badPeerDetected(writer);
                        }
                    }
                    piece.reset();
                }
                this._downloading[pieceNumber] = false;
                if (this.endGameMode && piece != null) {
                    try {
                        this.endGameModeChunks_mon.enter();
                        int nbChunks = piece.getNbBlocs();
                        int i = 0;
                        while (i < nbChunks) {
                            this.endGameModeChunks.add(new EndGameModeChunk(this._pieces[pieceNumber], i));
                            ++i;
                        }
                    }
                    finally {
                        this.endGameModeChunks_mon.exit();
                    }
                }
                ++this.nbHashFails;
            }
            finally {
                if (!this.seeding_mode) {
                    this.checkFinished(false);
                }
            }
        }
    }

    private void badPeerDetected(PEPeer peer) {
        IpFilterManager filter_manager;
        int nbWarnings;
        String ip = peer.getIp();
        int nbBadChunks = peer.getNbBadChunks();
        if (nbBadChunks > 3 && (nbWarnings = (filter_manager = IpFilterManagerFactory.getSingleton()).getBadIps().addWarningForIp(ip)) > 3) {
            if (COConfigurationManager.getBooleanParameter("Ip Filter Enable Banning")) {
                ip_filter.ban(ip, this._downloadManager.getDisplayName());
                ((PEPeerTransport)peer).closeAll(String.valueOf(ip) + " : has sent too many bad chunks (" + nbBadChunks + " , " + 3 + " max)", false, false);
                LGLogger.log(3, String.valueOf(ip) + " : has been banned and won't be able to connect until you restart azureus");
            } else {
                LGLogger.log(3, String.valueOf(ip) + " : has not been banned as this is disabled. Bad data count has been reset");
                peer.resetNbBadChunks();
            }
        }
    }

    public PEPiece[] getPieces() {
        return this._pieces;
    }

    public boolean isOptimisticUnchoke(PEPeer pc) {
        return pc == this.currentOptimisticUnchoke;
    }

    public int getNbHashFails() {
        return this.nbHashFails;
    }

    public void setNbHashFails(int fails) {
        this.nbHashFails = fails;
    }

    public PEPeerStats createPeerStats() {
        return new PEPeerStatsImpl();
    }

    public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
        return this._diskManager.createReadRequest(pieceNumber, offset, length);
    }

    protected void changeState(int new_state) {
        try {
            this.this_mon.enter();
            this.peer_manager_state = new_state;
            int i = 0;
            while (i < this.peer_manager_listeners.size()) {
                ((PEPeerManagerListener)this.peer_manager_listeners.get(i)).stateChanged(this.peer_manager_state);
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            this.peer_manager_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(PEPeerManagerListener l) {
        try {
            this.this_mon.enter();
            this.peer_manager_listeners.remove(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void parameterChanged(String parameterName) {
        oldPolling = COConfigurationManager.getBooleanParameter("Old.Socket.Polling.Style");
        disconnect_seeds_when_seeding = COConfigurationManager.getBooleanParameter("Disconnect Seed", true);
        if (parameterName.equals("Ip Filter Enabled")) {
            this.checkForBannedConnections();
        }
    }

    protected void checkForBannedConnections() {
        if (ip_filter.isEnabled()) {
            ArrayList peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport conn = (PEPeerTransport)peer_transports.get(i);
                if (ip_filter.isInRange(conn.getIp(), this._downloadManager.getDisplayName())) {
                    conn.closeAll("IPFilter banned IP address: " + conn.getIp(), false, false);
                }
                ++i;
            }
        }
    }

    private void checkEndGameMode() {
        if (this.endGameMode || this.endGameModeAbandoned) {
            if (!this.endGameModeAbandoned && SystemTime.getCurrentTime() - this.timeEndGameModeEntered > 600000L) {
                this.endGameMode = false;
                this.endGameModeAbandoned = true;
                LGLogger.log(0, "Abandoning end-game mode: " + this._downloadManager.getDisplayName());
                try {
                    this.endGameModeChunks_mon.enter();
                    this.endGameModeChunks.clear();
                }
                finally {
                    this.endGameModeChunks_mon.exit();
                }
            }
            return;
        }
        int active_pieces = 0;
        int i = 0;
        while (i < this._pieces.length) {
            if (!this.dm_pieces[i].getDone()) {
                if (this._downloading[i]) {
                    ++active_pieces;
                } else {
                    return;
                }
            }
            ++i;
        }
        if ((long)(active_pieces * this._diskManager.getPieceLength()) <= 0x1400000L) {
            this.timeEndGameModeEntered = SystemTime.getCurrentTime();
            this.computeEndGameModeChunks();
            this.endGameMode = true;
            LGLogger.log(0, "Entering end-game mode: " + this._downloadManager.getDisplayName());
        }
    }

    private void computeEndGameModeChunks() {
        this.endGameModeChunks = new ArrayList();
        try {
            this.endGameModeChunks_mon.enter();
            int i = 0;
            while (i < this._pieces.length) {
                PEPieceImpl piece;
                if (!this.dm_pieces[i].getDone() && (piece = this._pieces[i]) != null) {
                    int j;
                    boolean[] written = piece.getWritten();
                    if (written == null) {
                        if (!piece.isComplete()) {
                            j = 0;
                            while (j < piece.getNbBlocs()) {
                                this.endGameModeChunks.add(new EndGameModeChunk(piece, j));
                                ++j;
                            }
                        }
                    } else {
                        j = 0;
                        while (j < written.length) {
                            if (!written[j]) {
                                this.endGameModeChunks.add(new EndGameModeChunk(piece, j));
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    private void removeFromEndGameModeChunks(int pieceNumber, int offset) {
        try {
            this.endGameModeChunks_mon.enter();
            Iterator iter = this.endGameModeChunks.iterator();
            while (iter.hasNext()) {
                EndGameModeChunk chunk = (EndGameModeChunk)iter.next();
                if (!chunk.compare(pieceNumber, offset)) continue;
                iter.remove();
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
    }

    private boolean findPieceInEndGameMode(PEPeerTransport peer) {
        try {
            this.endGameModeChunks_mon.enter();
            int nbChunks = this.endGameModeChunks.size();
            if (nbChunks > 0) {
                int random = (int)(Math.random() * (double)nbChunks);
                EndGameModeChunk chunk = (EndGameModeChunk)this.endGameModeChunks.get(random);
                int pieceNumber = chunk.getPieceNumber();
                if (peer.getAvailable()[pieceNumber]) {
                    PEPieceImpl piece = this._pieces[pieceNumber];
                    if (piece != null) {
                        boolean result = peer.request(pieceNumber, chunk.getOffset(), chunk.getLength());
                        piece.markBlock(chunk.getBlockNumber());
                        boolean bl = result;
                        this.endGameModeChunks_mon.exit();
                        return bl;
                    }
                    this.endGameModeChunks.remove(chunk);
                    this.endGameModeChunks_mon.exit();
                    return false;
                }
            }
        }
        finally {
            this.endGameModeChunks_mon.exit();
        }
        return false;
    }

    public boolean needsMD5CheckOnCompletion(int pieceNumber) {
        PEPieceImpl piece = this._pieces[pieceNumber];
        if (piece == null) {
            return false;
        }
        return piece.getPieceWrites().size() > 0;
    }

    public boolean isSuperSeedMode() {
        return this.superSeedMode;
    }

    public boolean isInEndGameMode() {
        return this.endGameMode;
    }

    public void setSuperSeedMode(boolean _superSeedMode) {
        if (_superSeedMode && this.superSeedPieces == null) {
            this.initialiseSuperSeedMode();
        }
        this.superSeedMode = _superSeedMode;
    }

    private void initialiseSuperSeedMode() {
        this.superSeedPieces = new SuperSeedPiece[this._nbPieces];
        int i = 0;
        while (i < this._nbPieces) {
            this.superSeedPieces[i] = new SuperSeedPiece(this, i);
            ++i;
        }
    }

    private void updatePeersInSuperSeedMode() {
        if (!this.superSeedMode) {
            return;
        }
        int i = 0;
        while (i < this.superSeedPieces.length) {
            this.superSeedPieces[i].updateTime();
            ++i;
        }
        int nbUnchoke = this._downloadManager.getStats().getMaxUploads();
        if (this.superSeedModeNumberOfAnnounces >= 2 * nbUnchoke) {
            return;
        }
        PEPeer selectedPeer = null;
        ArrayList<SuperSeedPeer> sortedPeers = null;
        ArrayList peer_transports = this.peer_transports_cow;
        sortedPeers = new ArrayList<SuperSeedPeer>(peer_transports.size());
        Iterator iter = peer_transports.iterator();
        while (iter.hasNext()) {
            sortedPeers.add(new SuperSeedPeer((PEPeer)iter.next()));
        }
        Collections.sort(sortedPeers);
        iter = sortedPeers.iterator();
        while (iter.hasNext()) {
            PEPeer peer = ((SuperSeedPeer)iter.next()).peer;
            if (peer.getUniqueAnnounce() != -1 || peer.getState() != 30) continue;
            selectedPeer = peer;
            break;
        }
        if (selectedPeer == null) {
            return;
        }
        if (selectedPeer.getUploadHint() == 0) {
            selectedPeer.setUploadHint(31536000);
        }
        boolean found = false;
        SuperSeedPiece piece = null;
        while (!found) {
            piece = this.superSeedPieces[this.superSeedModeCurrentPiece];
            if (piece.getLevel() > 0) {
                piece = null;
                ++this.superSeedModeCurrentPiece;
                if (this.superSeedModeCurrentPiece < this._nbPieces) continue;
                this.superSeedModeCurrentPiece = 0;
                this.quitSuperSeedMode();
                return;
            }
            found = true;
        }
        if (piece == null) {
            return;
        }
        if (selectedPeer.getAvailable()[piece.getPieceNumber()]) {
            return;
        }
        selectedPeer.setUniqueAnnounce(piece.getPieceNumber());
        ++this.superSeedModeNumberOfAnnounces;
        piece.pieceRevealedToPeer();
        ((PEPeerTransport)selectedPeer).sendHave(piece.getPieceNumber());
    }

    public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
        if (this.superSeedMode) {
            this.superSeedPieces[pieceNumber].peerHasPiece(null);
            if (peer.getUniqueAnnounce() == pieceNumber) {
                peer.setUniqueAnnounce(-1);
                --this.superSeedModeNumberOfAnnounces;
            }
        }
    }

    private void quitSuperSeedMode() {
        this.superSeedMode = false;
        ArrayList peer_transports = this.peer_transports_cow;
        Iterator iter = peer_transports.iterator();
        while (iter.hasNext()) {
            PEPeerTransport peer = (PEPeerTransport)iter.next();
            peer.closeAll(String.valueOf(peer.getIp()) + " : Quiting SuperSeed Mode", false, true);
        }
    }

    public DiskManager getDiskManager() {
        return this._diskManager;
    }

    public PEPeerTransportDataReader getDataReader() {
        return this.download_speed_limiter;
    }

    public LimitedRateGroup getUploadLimitedRateGroup() {
        return this.upload_limited_rate_group;
    }

    public Object getData(String key) {
        block3: {
            try {
                this.this_mon.enter();
                if (this.user_data != null) break block3;
                Object var3_2 = null;
                this.this_mon.exit();
                return var3_2;
            }
            catch (Throwable throwable) {
                this.this_mon.exit();
                throw throwable;
            }
        }
        Object v = this.user_data.get(key);
        this.this_mon.exit();
        return v;
    }

    public void setData(String key, Object value) {
        try {
            this.this_mon.enter();
            if (this.user_data == null) {
                this.user_data = new HashMap();
            }
            if (value == null) {
                if (this.user_data.containsKey(key)) {
                    this.user_data.remove(key);
                }
            } else {
                this.user_data.put(key, value);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void doConnectionChecks() {
        long last_update;
        if (this.mainloop_loop_count % 100L == 0L && (last_update = ip_filter.getLastUpdateTime()) != this.ip_filter_last_update_time) {
            this.ip_filter_last_update_time = last_update;
            this.checkForBannedConnections();
        }
        if (this.mainloop_loop_count % 10L == 0L) {
            ArrayList peer_transports = this.peer_transports_cow;
            int num_waiting_establishments = 0;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                int state = transport.getConnectionState();
                if (state == 0 || state == 1) {
                    ++num_waiting_establishments;
                }
                ++i;
            }
            int allowed = PeerUtils.numNewConnectionsAllowed(this._hash);
            if (allowed != 0) {
                int wanted;
                if (allowed != -1 && (wanted = ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - num_waiting_establishments) > allowed) {
                    num_waiting_establishments += wanted - allowed;
                }
                while (num_waiting_establishments < ConnectDisconnectManager.MAX_SIMULTANIOUS_CONNECT_ATTEMPTS) {
                    PeerConnectInfoStorage.PeerInfo peer_info = this.peer_info_storage.getPeerInfo();
                    if (peer_info == null) break;
                    if (!this.makeNewOutgoingConnection(peer_info.getAddress(), peer_info.getPort())) continue;
                    ++num_waiting_establishments;
                }
            }
        }
        if (this.mainloop_loop_count % 50L == 0L) {
            ArrayList peer_transports = this.peer_transports_cow;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                if (!transport.doTimeoutChecks()) {
                    transport.doKeepAliveCheck();
                }
                ++i;
            }
            int allowed = PeerUtils.numNewConnectionsAllowed(this._hash);
            if (allowed == -1) {
                allowed = 100;
            }
            this.peer_info_storage.setMaxCapacity(allowed * 2);
        }
        if (this.mainloop_loop_count % 300L == 0L && PeerUtils.numNewConnectionsAllowed(this._hash) == 0) {
            ArrayList peer_transports = this.peer_transports_cow;
            PEPeer max_transport = null;
            long max_time = 0L;
            int i = 0;
            while (i < peer_transports.size()) {
                PEPeerTransport transport = (PEPeerTransport)peer_transports.get(i);
                long time = transport.getTimeSinceLastDataMessageReceived();
                if (time > max_time) {
                    max_time = time;
                    max_transport = transport;
                }
                ++i;
            }
            if (max_transport != null && max_time > 60000L) {
                max_transport.closeAll(String.valueOf(max_transport.getIp()) + ": Timed out by optimistic-connect for lack of activity", false, false);
            }
        }
    }

    private class PeerUpdater
    extends AEThread {
        private boolean bContinue;

        public PeerUpdater() {
            super("Peer Updater");
            this.bContinue = true;
            this.setPriority(4);
        }

        public void runSupport() {
            while (this.bContinue) {
                long start_time = SystemTime.getCurrentTime();
                try {
                    ArrayList peer_transports = PEPeerControlImpl.this.peer_transports_cow;
                    int i = 0;
                    while (i < peer_transports.size()) {
                        PEPeerTransport ps = (PEPeerTransport)peer_transports.get(i);
                        if (SystemTime.isErrorLast5sec() || oldPolling || SystemTime.getCurrentTime() > ps.getLastReadTime() + (long)ps.getReadSleepTime()) {
                            ps.setReadSleepTime(ps.processRead());
                            if (!oldPolling) {
                                ps.setLastReadTime(SystemTime.getCurrentTime());
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                long loop_time = SystemTime.getCurrentTime() - start_time;
                if (loop_time >= 50L || loop_time < 0L) continue;
                try {
                    Thread.sleep(50L - loop_time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

