/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class NatCheckerServer
extends AEThread {
    private String check;
    private ServerSocket server;
    private boolean valid = false;
    private boolean isAlreadyListening = false;
    private boolean bContinue = true;

    public NatCheckerServer(int _port, String _check) {
        super("Nat Checker Server");
        try {
            this.check = _check;
            String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
            this.server = bind_ip.length() < 7 ? new ServerSocket(_port) : new ServerSocket(_port, 8, InetAddress.getByName(bind_ip));
            this.valid = true;
        }
        catch (IOException ioe) {
            int confPort = COConfigurationManager.getIntParameter("TCP.Listen.Port", 6881);
            if (_port == confPort) {
                this.valid = false;
                this.isAlreadyListening = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void runSupport() {
        while (this.bContinue) {
            try {
                if (this.isAlreadyListening) {
                    Thread.sleep(20L);
                    continue;
                }
                Socket sck = this.server.accept();
                sck.getOutputStream().write(this.check.getBytes());
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                this.bContinue = false;
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isAlreadyListening() {
        return this.isAlreadyListening;
    }

    public void stopIt() {
        try {
            this.bContinue = false;
            if (this.server != null && this.server.isBound()) {
                this.server.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

