/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.SystemTime;

public class DownloadManagerStatsImpl
implements DownloadManagerStats {
    protected DownloadManagerImpl download_manager;
    protected int maxUploads = 4;
    protected int max_download_speed = 0;
    protected int completed;
    protected int downloadCompleted;
    protected long saved_downloaded;
    protected long saved_uploaded;
    protected long saved_discarded = 0L;
    protected long saved_hashfails = 0L;
    protected long saved_SecondsDownloading = 0L;
    protected long saved_SecondsOnlySeeding = 0L;
    protected int max_upload_rate_bps = 0;

    protected DownloadManagerStatsImpl(DownloadManagerImpl dm) {
        this.download_manager = dm;
    }

    public void received(int length) {
        GlobalManager gm = this.download_manager.getGlobalManager();
        if (length > 0 && gm != null) {
            gm.getStats().received(length);
        }
    }

    public void discarded(int length) {
        GlobalManager gm = this.download_manager.getGlobalManager();
        if (length > 0 && gm != null) {
            gm.getStats().discarded(length);
        }
    }

    public void sent(int length) {
        GlobalManager gm = this.download_manager.getGlobalManager();
        if (length > 0 && gm != null) {
            gm.getStats().sent(length);
        }
    }

    public long getDownloadAverage() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getDownloadAverage();
        }
        return 0L;
    }

    public long getUploadAverage() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getUploadAverage();
        }
        return 0L;
    }

    public long getETA() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getETA();
        }
        return -1L;
    }

    public int getCompleted() {
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            int state = this.download_manager.getState();
            if (state == 20 || state == 30 || state == 5) {
                return this.completed;
            }
            return this.downloadCompleted;
        }
        if (dm.getState() == 2 || dm.getState() == 3 || dm.getState() == 1) {
            return dm.getPercentDone();
        }
        long total = dm.getTotalLength();
        return total == 0L ? 0 : (int)(1000L * (total - dm.getRemaining()) / total);
    }

    public void setCompleted(int completed) {
        this.completed = completed;
    }

    public int getDownloadCompleted(boolean bLive) {
        if (!bLive) {
            return this.downloadCompleted;
        }
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            return this.downloadCompleted;
        }
        long total = dm.getTotalLength();
        int newValue = total == 0L ? 0 : (int)(1000L * (total - dm.getRemaining()) / total);
        int state = dm.getState();
        if (state != 1 && state != 2 && state != 3) {
            this.downloadCompleted = newValue;
        }
        return newValue;
    }

    public void setDownloadCompleted(int completed) {
        this.downloadCompleted = completed;
    }

    public int getMaxUploads() {
        return this.maxUploads;
    }

    public void setMaxUploads(int i) {
        this.maxUploads = i;
    }

    public String getElapsedTime() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getElapsedTime();
        }
        return "";
    }

    public long getTimeStarted() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStarted();
        }
        return -1L;
    }

    public long getTimeStartedSeeding() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getTimeStartedSeeding();
        }
        return -1L;
    }

    public long getDownloaded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_downloaded + pm.getStats().getTotalReceived();
        }
        return this.saved_downloaded;
    }

    public long getUploaded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return this.saved_uploaded + pm.getStats().getTotalSent();
        }
        return this.saved_uploaded;
    }

    public long getDiscarded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getTotalDiscarded();
        }
        return this.saved_discarded;
    }

    public void setSavedDiscarded() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            System.out.println("setDiscarded:: PeerManager null");
        } else {
            pm.getStats().setTotalDiscarded(this.saved_discarded);
        }
    }

    public void saveDiscarded(long discarded) {
        this.saved_discarded = discarded;
    }

    public long getHashFails() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getNbHashFails();
        }
        return this.saved_hashfails;
    }

    public void setSavedHashFails() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            System.out.println("setSavedHashFails:: PeerManager null");
        } else {
            pm.setNbHashFails((int)this.saved_hashfails);
        }
    }

    public void saveHashFails(long fails) {
        this.saved_hashfails = fails;
    }

    public long getTotalAverage() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            return pm.getStats().getTotalAverage();
        }
        return 0L;
    }

    public int getShareRatio() {
        long uploaded;
        long downloaded;
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm != null) {
            downloaded = this.saved_downloaded + pm.getStats().getTotalReceived();
            uploaded = this.saved_uploaded + pm.getStats().getTotalSent();
        } else {
            downloaded = this.saved_downloaded;
            uploaded = this.saved_uploaded;
        }
        if (downloaded == 0L) {
            return -1;
        }
        return (int)(1000L * uploaded / downloaded);
    }

    public void setSavedDownloadedUploaded(long downloaded, long uploaded) {
        this.saved_downloaded = downloaded;
        this.saved_uploaded = uploaded;
    }

    protected long getSavedDownloaded() {
        return this.saved_downloaded;
    }

    protected long getSavedUploaded() {
        return this.saved_uploaded;
    }

    public long getSecondsDownloading() {
        long lTimeStartedDL = this.getTimeStarted();
        if (lTimeStartedDL >= 0L) {
            long lTimeEndedDL = this.getTimeStartedSeeding();
            if (lTimeEndedDL == -1L) {
                lTimeEndedDL = SystemTime.getCurrentTime();
            }
            if (lTimeEndedDL > lTimeStartedDL) {
                return this.saved_SecondsDownloading + (lTimeEndedDL - lTimeStartedDL) / 1000L;
            }
        }
        return this.saved_SecondsDownloading;
    }

    public long getSecondsOnlySeeding() {
        long lTimeStarted = this.getTimeStartedSeeding();
        if (lTimeStarted >= 0L) {
            return this.saved_SecondsOnlySeeding + (SystemTime.getCurrentTime() - lTimeStarted) / 1000L;
        }
        return this.saved_SecondsOnlySeeding;
    }

    public void setSecondsDownloading(long seconds) {
        this.saved_SecondsDownloading = seconds;
    }

    public void setSecondsOnlySeeding(long seconds) {
        this.saved_SecondsOnlySeeding = seconds;
    }

    public float getAvailability() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return -1.0f;
        }
        return pm.getMinAvailability();
    }

    public int getMaxDownloadKBSpeed() {
        return this.max_download_speed;
    }

    public void setMaxDownloadKBSpeed(int i) {
        this.max_download_speed = i;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.max_upload_rate_bps;
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.max_upload_rate_bps = max_rate_bps;
    }
}

