/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.resume;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.PieceList;
import org.gudy.azureus2.core3.disk.impl.PieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.access.CheckPieceResultHandler;
import org.gudy.azureus2.core3.disk.impl.access.DMWriterAndChecker;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;

public class RDResumeHandler
implements ParameterListener {
    protected DiskManagerHelper disk_manager;
    protected DMWriterAndChecker writer_and_checker;
    protected DownloadManagerState download_manager_state;
    protected TOTorrent torrent;
    protected int nbPieces;
    protected int pieceLength;
    protected int lastPieceLength;
    protected boolean bOverallContinue;
    protected boolean useFastResume = COConfigurationManager.getBooleanParameter("Use Resume", true);

    public RDResumeHandler(DiskManagerHelper _disk_manager, DMWriterAndChecker _writer_and_checker) {
        this.disk_manager = _disk_manager;
        this.writer_and_checker = _writer_and_checker;
        this.download_manager_state = this.disk_manager.getDownloadManager().getDownloadState();
        this.torrent = this.disk_manager.getTorrent();
        this.nbPieces = this.disk_manager.getNumberOfPieces();
        this.pieceLength = this.disk_manager.getPieceLength();
        this.lastPieceLength = this.disk_manager.getLastPieceLength();
    }

    public void start() {
        COConfigurationManager.addParameterListener("Use Resume", this);
        this.bOverallContinue = true;
    }

    public void stop() {
        this.bOverallContinue = false;
        COConfigurationManager.removeParameterListener("Use Resume", this);
    }

    public void parameterChanged(String parameterName) {
        this.useFastResume = COConfigurationManager.getBooleanParameter("Use Resume", true);
    }

    public void checkAllPieces(boolean newfiles) {
        this.disk_manager.setState(3);
        boolean resumeEnabled = this.useFastResume;
        if (newfiles) {
            resumeEnabled = false;
        }
        boolean resume_data_complete = false;
        final AESemaphore pending_checks_sem = new AESemaphore("RD:PendingChecks");
        int pending_check_num = 0;
        DiskManagerPiece[] pieces = this.disk_manager.getPieces();
        if (resumeEnabled) {
            boolean resumeValid = false;
            byte[] resumeArray = null;
            Map partialPieces = null;
            Map resumeMap = this.download_manager_state.getResumeData();
            if (resumeMap != null) {
                String resume_key = this.torrent.isSimpleTorrent() ? this.disk_manager.getDownloadManager().getTorrentSaveDir() : this.disk_manager.getDownloadManager().getTorrentSaveDirAndFile();
                String[] resume_keys = new String[4];
                resume_keys[0] = resume_key;
                try {
                    resume_keys[1] = new String(resume_key.getBytes("UTF8"), "ISO-8859-1");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                resume_keys[2] = RDResumeHandler.getCanonicalResumeKey(resume_key);
                try {
                    resume_keys[3] = new String(resume_keys[2].getBytes("UTF8"), "ISO-8859-1");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                Map resumeDirectory = null;
                int i2 = 0;
                while (i2 < resume_keys.length) {
                    String rk = resume_keys[i2];
                    if (rk != null && (resumeDirectory = (Map)resumeMap.get(rk)) != null) break;
                    ++i2;
                }
                if (resumeDirectory != null) {
                    try {
                        resumeArray = (byte[])resumeDirectory.get("resume data");
                        if (resumeArray != null && resumeArray.length != pieces.length) {
                            Debug.out("Resume data array length mismatch: " + resumeArray.length + "/" + pieces.length);
                            resumeArray = null;
                        }
                        partialPieces = (Map)resumeDirectory.get("blocks");
                        boolean bl = resumeValid = ((Long)resumeDirectory.get("valid")).intValue() == 1;
                        if (RDResumeHandler.isTorrentResumeDataComplete(this.download_manager_state, this.disk_manager.getDownloadManager().getTorrentSaveDir(), this.disk_manager.getDownloadManager().getTorrentSaveFile())) {
                            resume_data_complete = true;
                        } else {
                            resumeDirectory.put("valid", new Long(0L));
                            this.download_manager_state.save();
                        }
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                }
            }
            if (resumeArray == null) {
                resumeValid = false;
                resumeArray = new byte[pieces.length];
            }
            DiskManagerFileInfo[] files = this.disk_manager.getFiles();
            HashMap<DiskManagerFileInfo, Long> file_sizes = new HashMap<DiskManagerFileInfo, Long>();
            int i = 0;
            while (i < files.length) {
                try {
                    Long len = new Long(((DiskManagerFileInfoImpl)files[i]).getCacheFile().getLength());
                    file_sizes.put(files[i], len);
                }
                catch (CacheFileManagerException e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
            i = 0;
            while (i < pieces.length && this.bOverallContinue) {
                boolean ok;
                DiskManagerPiece dm_piece = pieces[i];
                this.disk_manager.setPercentDone((i + 1) * 1000 / this.nbPieces);
                boolean bl = ok = resumeArray[i] == 1;
                if (ok) {
                    PieceList list = this.disk_manager.getPieceList(i);
                    int j = 0;
                    while (j < list.size()) {
                        PieceMapEntry entry2 = list.get(j);
                        Long file_size = (Long)file_sizes.get(entry2.getFile());
                        if (file_size == null) {
                            ok = false;
                            LGLogger.log(0, 0, 0, "Piece #" + i + ": file is missing, fails re-check.");
                            break;
                        }
                        long expected_size = entry2.getOffset() + (long)entry2.getLength();
                        if (file_size < expected_size) {
                            ok = false;
                            LGLogger.log(0, 0, 0, "Piece #" + i + ": file is too small, fails re-check. File size = " + file_size + ", piece needs " + expected_size);
                            break;
                        }
                        ++j;
                    }
                }
                if (ok) {
                    dm_piece.setDone(ok);
                } else if (!resumeValid) {
                    try {
                        this.writer_and_checker.checkPiece(i, new CheckPieceResultHandler(){

                            public void processResult(int piece_number, int result, Object user_data) {
                                LGLogger.log(0, 0, 0, "Piece #" + piece_number + (result == 1 ? " passed" : " failed") + " re-check.");
                                pending_checks_sem.release();
                            }
                        }, null);
                        ++pending_check_num;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                ++i;
            }
            if (partialPieces != null && resumeValid) {
                Iterator iter = partialPieces.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry key = iter.next();
                    int pieceNumber = Integer.parseInt((String)key.getKey());
                    List blocks = (List)partialPieces.get(key.getKey());
                    Iterator iterBlock = blocks.iterator();
                    while (iterBlock.hasNext()) {
                        pieces[pieceNumber].setWritten(((Long)iterBlock.next()).intValue());
                    }
                }
            }
        } else {
            int i = 0;
            while (i < pieces.length && this.bOverallContinue) {
                this.disk_manager.setPercentDone((i + 1) * 1000 / this.nbPieces);
                try {
                    this.writer_and_checker.checkPiece(i, new CheckPieceResultHandler(){

                        public void processResult(int piece_number, int result, Object user_data) {
                            LGLogger.log(0, 0, 0, "Piece #" + piece_number + (result == 1 ? " passed" : " failed") + " re-check.");
                            pending_checks_sem.release();
                        }
                    }, null);
                    ++pending_check_num;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
        }
        while (pending_check_num > 0) {
            pending_checks_sem.reserve();
            --pending_check_num;
        }
        if (this.bOverallContinue && !resume_data_complete) {
            try {
                this.dumpResumeDataToDisk(false, false);
            }
            catch (Exception e) {
                Debug.out("Failed to dump initial resume data to disk");
            }
        }
    }

    public void dumpResumeDataToDisk(boolean savePartialPieces, boolean force_recheck) throws Exception {
        int i;
        DiskManagerFileInfo[] files = this.disk_manager.getFiles();
        if (!this.useFastResume) {
            int i2 = 0;
            while (i2 < files.length) {
                files[i2].flushCache();
                ++i2;
            }
            return;
        }
        boolean was_complete = RDResumeHandler.isTorrentResumeDataComplete(this.download_manager_state, this.disk_manager.getDownloadManager().getTorrentSaveDir(), this.disk_manager.getDownloadManager().getTorrentSaveFile());
        DiskManagerPiece[] pieces = this.disk_manager.getPieces();
        byte[] resumeData = new byte[pieces.length];
        if (!force_recheck) {
            int i3 = 0;
            while (i3 < resumeData.length) {
                resumeData[i3] = pieces[i3].getDone() ? (byte)1 : 0;
                ++i3;
            }
        }
        HashMap resumeMap = new HashMap();
        HashMap<String, Object> resumeDirectory = new HashMap<String, Object>();
        String resume_key = this.torrent.isSimpleTorrent() ? this.disk_manager.getDownloadManager().getTorrentSaveDir() : this.disk_manager.getDownloadManager().getTorrentSaveDirAndFile();
        resume_key = RDResumeHandler.getCanonicalResumeKey(resume_key);
        resumeMap.put(resume_key, resumeDirectory);
        resumeDirectory.put("resume data", resumeData);
        HashMap partialPieces = new HashMap();
        if (savePartialPieces && !force_recheck) {
            i = 0;
            while (i < pieces.length) {
                DiskManagerPiece piece = pieces[i];
                boolean[] downloaded = piece.getWritten();
                if (!piece.getDone() && piece.getCompleteCount() > 0 && downloaded != null) {
                    ArrayList<Long> blocks = new ArrayList<Long>();
                    int j = 0;
                    while (j < downloaded.length) {
                        if (downloaded[j]) {
                            blocks.add(new Long(j));
                        }
                        ++j;
                    }
                    partialPieces.put("" + i, blocks);
                }
                ++i;
            }
            resumeDirectory.put("blocks", partialPieces);
        }
        resumeDirectory.put("valid", new Long(force_recheck ? 0 : (savePartialPieces ? 1 : 0)));
        i = 0;
        while (i < files.length) {
            files[i].flushCache();
            ++i;
        }
        this.download_manager_state.setResumeData(resumeMap);
        boolean is_complete = RDResumeHandler.isTorrentResumeDataComplete(this.download_manager_state, this.disk_manager.getDownloadManager().getTorrentSaveDir(), this.disk_manager.getDownloadManager().getTorrentSaveFile());
        if (!was_complete || !is_complete) {
            this.download_manager_state.save();
        }
    }

    public static void setTorrentResumeDataComplete(DownloadManagerState download_manager_state, String resume_key) {
        TOTorrent torrent = download_manager_state.getTorrent();
        resume_key = RDResumeHandler.getCanonicalResumeKey(resume_key);
        int piece_count = torrent.getNumberOfPieces();
        byte[] resumeData = new byte[piece_count];
        int i = 0;
        while (i < resumeData.length) {
            resumeData[i] = 1;
            ++i;
        }
        HashMap resumeMap = new HashMap();
        HashMap<String, Object> resumeDirectory = new HashMap<String, Object>();
        resumeMap.put(resume_key, resumeDirectory);
        resumeDirectory.put("resume data", resumeData);
        HashMap partialPieces = new HashMap();
        resumeDirectory.put("blocks", partialPieces);
        resumeDirectory.put("valid", new Long(1L));
        download_manager_state.setResumeData(resumeMap);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState download_manager_state, String torrent_save_dir, String torrent_save_file) {
        TOTorrent torrent = download_manager_state.getTorrent();
        String resume_key = torrent.isSimpleTorrent() ? torrent_save_dir : String.valueOf(torrent_save_dir) + File.separator + torrent_save_file;
        resume_key = RDResumeHandler.getCanonicalResumeKey(resume_key);
        long piece_count = torrent.getNumberOfPieces();
        byte[] resumeData = new byte[(int)piece_count];
        int i = 0;
        while (i < resumeData.length) {
            resumeData[i] = 1;
            ++i;
        }
        i = 0;
        while (i < 3) {
            int piece_num = (int)(Math.random() * (double)piece_count);
            resumeData[piece_num] = 0;
            ++i;
        }
        HashMap resumeMap = new HashMap();
        HashMap<String, Object> resumeDirectory = new HashMap<String, Object>();
        resumeMap.put(resume_key, resumeDirectory);
        resumeDirectory.put("resume data", resumeData);
        HashMap partialPieces = new HashMap();
        resumeDirectory.put("blocks", partialPieces);
        resumeDirectory.put("valid", new Long(0L));
        download_manager_state.setResumeData(resumeMap);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState download_manager_state, String torrent_save_dir, String torrent_save_file) {
        block10: {
            TOTorrent torrent = download_manager_state.getTorrent();
            String resume_key = torrent.isSimpleTorrent() ? torrent_save_dir : String.valueOf(torrent_save_dir) + File.separator + torrent_save_file;
            resume_key = RDResumeHandler.getCanonicalResumeKey(resume_key);
            try {
                String mangled_path;
                int piece_count = torrent.getNumberOfPieces();
                Map resumeMap = download_manager_state.getResumeData();
                if (resumeMap == null) break block10;
                try {
                    mangled_path = new String(resume_key.getBytes("UTF8"), "ISO-8859-1");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    mangled_path = resume_key;
                }
                Map resumeDirectory = (Map)resumeMap.get(mangled_path);
                if (resumeDirectory == null) {
                    resumeDirectory = (Map)resumeMap.get(resume_key);
                }
                if (resumeDirectory != null) {
                    boolean valid;
                    byte[] resume_data = (byte[])resumeDirectory.get("resume data");
                    Map blocks = (Map)resumeDirectory.get("blocks");
                    boolean bl = valid = ((Long)resumeDirectory.get("valid")).intValue() == 1;
                    if (blocks == null || blocks.size() > 0) {
                        return false;
                    }
                    if (valid && resume_data.length == piece_count) {
                        int i = 0;
                        while (i < resume_data.length) {
                            if (resume_data[i] == 0) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    protected static String getCanonicalResumeKey(String resume_key) {
        try {
            resume_key = new File(resume_key).getCanonicalFile().toString();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return resume_key;
    }
}

