/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public class DERVisibleString
extends DERObject
implements DERString {
    String string;

    public static DERVisibleString getInstance(Object obj) {
        if (obj == null || obj instanceof DERVisibleString) {
            return (DERVisibleString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERVisibleString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERVisibleString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERVisibleString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERVisibleString.getInstance(obj.getObject());
    }

    public DERVisibleString(byte[] string) {
        char[] cs = new char[string.length];
        int i = 0;
        while (i != cs.length) {
            cs[i] = (char)(string[i] & 0xFF);
            ++i;
        }
        this.string = new String(cs);
    }

    public DERVisibleString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        int i = 0;
        while (i != cs.length) {
            bs[i] = (byte)cs[i];
            ++i;
        }
        return bs;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(26, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERVisibleString)) {
            return false;
        }
        return this.getString().equals(((DERVisibleString)o).getString());
    }
}

