/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;

public class UPnPPluginService {
    protected UPnPWANConnection connection;
    protected BooleanParameter alert_success;
    protected BooleanParameter grab_ports;
    protected BooleanParameter alert_other_port_param;
    protected BooleanParameter release_mappings;
    protected List service_mappings = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("UPnPPluginService");

    protected UPnPPluginService(UPnPWANConnection _connection, UPnPWANConnectionPortMapping[] _ports, BooleanParameter _alert_success, BooleanParameter _grab_ports, BooleanParameter _alert_other_port_param, BooleanParameter _release_mappings) {
        this.connection = _connection;
        this.alert_success = _alert_success;
        this.grab_ports = _grab_ports;
        this.alert_other_port_param = _alert_other_port_param;
        this.release_mappings = _release_mappings;
        int i = 0;
        while (i < _ports.length) {
            this.service_mappings.add(new serviceMapping(_ports[i]));
            ++i;
        }
    }

    protected UPnPWANConnection getService() {
        return this.connection;
    }

    protected String getOldDescriptionForPort(int port) {
        return "Azureus UPnP " + port;
    }

    protected String getDescriptionForPort(boolean TCP, int port) {
        return "Azureus UPnP " + port + " " + (TCP ? "TCP" : "UDP");
    }

    protected void checkMapping(LoggerChannel log, UPnPMapping mapping) {
        block18: {
            try {
                this.this_mon.enter();
                if (mapping.isEnabled()) {
                    serviceMapping grab_in_progress;
                    block17: {
                        int i = 0;
                        while (i < this.service_mappings.size()) {
                            serviceMapping sm = (serviceMapping)this.service_mappings.get(i);
                            if (sm.getMapping() == mapping && sm.getPort() != mapping.getPort()) {
                                this.removeMapping(log, sm, false);
                            }
                            ++i;
                        }
                        grab_in_progress = null;
                        String local_address = this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
                        int i2 = 0;
                        while (i2 < this.service_mappings.size()) {
                            serviceMapping sm = (serviceMapping)this.service_mappings.get(i2);
                            if (sm.isTCP() == mapping.isTCP() && sm.getPort() == mapping.getPort()) {
                                if (sm.getInternalHost().equals(local_address)) {
                                    sm.setMapping(mapping);
                                    if (!sm.getLogged()) {
                                        sm.setLogged();
                                        log.log("Mapping " + mapping.getString() + " already established");
                                    }
                                    this.this_mon.exit();
                                    return;
                                }
                                if (!this.grab_ports.getValue()) {
                                    if (!sm.getLogged()) {
                                        sm.setLogged();
                                        String text = MessageText.getString("upnp.alert.differenthost", new String[]{mapping.getString(), sm.getInternalHost()});
                                        log.log(text);
                                        if (this.alert_other_port_param.getValue()) {
                                            log.logAlertRepeatable(2, text);
                                        }
                                    }
                                    this.this_mon.exit();
                                    return;
                                }
                                sm.setMapping(mapping);
                                grab_in_progress = sm;
                            }
                            ++i2;
                        }
                        try {
                            this.connection.addPortMapping(mapping.isTCP(), mapping.getPort(), this.getDescriptionForPort(mapping.isTCP(), mapping.getPort()));
                            String text = grab_in_progress != null ? MessageText.getString("upnp.alert.mappinggrabbed", new String[]{mapping.getString(), grab_in_progress.getInternalHost()}) : MessageText.getString("upnp.alert.mappingok", new String[]{mapping.getString()});
                            log.log(text);
                            if (this.alert_success.getValue()) {
                                log.logAlertRepeatable(1, text);
                            }
                        }
                        catch (Throwable e) {
                            String text = MessageText.getString("upnp.alert.mappingfailed", new String[]{mapping.getString()});
                            log.log(text, e);
                            if (!this.alert_other_port_param.getValue()) break block17;
                            log.logAlertRepeatable(3, text);
                        }
                    }
                    if (grab_in_progress == null) {
                        serviceMapping new_mapping = new serviceMapping(mapping);
                        this.service_mappings.add(new_mapping);
                    }
                    break block18;
                }
                this.removeMapping(log, mapping, false);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void removeMapping(LoggerChannel log, UPnPMapping mapping, boolean end_of_day) {
        try {
            this.this_mon.enter();
            String local_address = this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
            int i = 0;
            while (i < this.service_mappings.size()) {
                serviceMapping sm = (serviceMapping)this.service_mappings.get(i);
                if (sm.isTCP() == mapping.isTCP() && sm.getPort() == mapping.getPort() && sm.getMapping() != null) {
                    this.removeMapping(log, sm, end_of_day);
                    this.this_mon.exit();
                    return;
                }
                ++i;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeMapping(LoggerChannel log, serviceMapping mapping, boolean end_of_day) {
        if (mapping.isExternal()) {
            log.log("Mapping " + mapping.getString() + " not removed as not created by Azureus");
        } else if (end_of_day && !this.release_mappings.getValue()) {
            log.log("Mapping " + mapping.getString() + " not removed as 'release on closedown' not selected");
        } else {
            try {
                this.connection.deletePortMapping(mapping.isTCP(), mapping.getPort());
                log.log("Mapping " + mapping.getString() + " removed");
            }
            catch (Throwable e) {
                log.log("Mapping " + mapping.getString() + " failed to delete", e);
            }
            this.service_mappings.remove(mapping);
        }
    }

    protected class serviceMapping {
        protected UPnPMapping mapping;
        protected boolean tcp;
        protected int port;
        protected String internal_host;
        protected boolean external;
        protected boolean logged;

        protected serviceMapping(UPnPWANConnectionPortMapping device_mapping) {
            this.tcp = device_mapping.isTCP();
            this.port = device_mapping.getExternalPort();
            this.internal_host = device_mapping.getInternalHost();
            String desc = device_mapping.getDescription();
            if (desc == null || !desc.equalsIgnoreCase(UPnPPluginService.this.getOldDescriptionForPort(this.port)) && !desc.equalsIgnoreCase(UPnPPluginService.this.getDescriptionForPort(this.tcp, this.port))) {
                this.external = true;
            }
        }

        protected serviceMapping(UPnPMapping _mapping) {
            this.mapping = _mapping;
            this.tcp = this.mapping.isTCP();
            this.port = this.mapping.getPort();
            this.internal_host = UPnPPluginService.this.connection.getGenericService().getDevice().getRootDevice().getLocalAddress().getHostAddress();
        }

        protected boolean isExternal() {
            return this.external;
        }

        protected UPnPMapping getMapping() {
            return this.mapping;
        }

        protected void setMapping(UPnPMapping _mapping) {
            this.mapping = _mapping;
        }

        protected boolean getLogged() {
            return this.logged;
        }

        protected void setLogged() {
            this.logged = true;
        }

        protected boolean isTCP() {
            return this.tcp;
        }

        protected int getPort() {
            return this.port;
        }

        protected String getInternalHost() {
            return this.internal_host;
        }

        public String getString() {
            if (this.mapping == null) {
                return "<external> (" + (this.isTCP() ? "TCP" : "UDP") + "/" + this.getPort() + ")";
            }
            return this.mapping.getString(this.getPort());
        }
    }
}

