/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messages.bittorrent;

import com.aelitis.azureus.core.peermanager.messages.bittorrent.BTProtocolMessage;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTPiece
implements BTProtocolMessage {
    private final DirectByteBuffer buffer;
    private final int piece_number;
    private final int piece_offset;
    private final int length;
    private final int total_byte_size;

    public BTPiece(int piece_number, int piece_offset, DirectByteBuffer data) {
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.length = data.remaining((byte)6);
        this.buffer = DirectByteBufferPool.getBuffer((byte)9, this.length + 13);
        this.buffer.putInt((byte)6, this.length + 9);
        this.buffer.put((byte)6, (byte)7);
        this.buffer.putInt((byte)6, piece_number);
        this.buffer.putInt((byte)6, piece_offset);
        this.buffer.put((byte)6, data);
        this.buffer.position((byte)6, 0);
        this.buffer.limit((byte)6, this.length + 13);
        this.total_byte_size = this.buffer.limit((byte)6);
        data.returnToPool();
    }

    public int getType() {
        return 7;
    }

    public DirectByteBuffer getPayload() {
        return this.buffer;
    }

    public int getTotalMessageByteSize() {
        return this.total_byte_size;
    }

    public String getDescription() {
        return "Piece data for #" + this.piece_number + ": " + this.piece_offset + "->" + (this.piece_offset + this.length - 1);
    }

    public int getPriority() {
        return 0;
    }

    public boolean isNoDelay() {
        return false;
    }

    public boolean isDataMessage() {
        return true;
    }

    public void destroy() {
        this.buffer.returnToPool();
    }

    public int[] typesToRemove() {
        return null;
    }
}

