/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.Connection;
import com.aelitis.azureus.core.networkmanager.ConnectionOwner;
import com.aelitis.azureus.core.networkmanager.RateControlledWriteEntity;
import com.aelitis.azureus.core.networkmanager.WriteController;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkManager {
    private static final NetworkManager instance = new NetworkManager();
    private int tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
    private final ConnectDisconnectManager connect_disconnect_manager = new ConnectDisconnectManager();
    private final WriteController write_controller = new WriteController();

    private NetworkManager() {
        COConfigurationManager.addParameterListener("network.tcp.mtu.size", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                NetworkManager.this.tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
            }
        });
    }

    public static NetworkManager getSingleton() {
        return instance;
    }

    public Connection createNewConnection(ConnectionOwner owner, String remote_address, int remote_port) {
        if (remote_port < 0 || remote_port > 65535) {
            Debug.out("remove_port invalid: " + remote_port);
            remote_port = 0;
        }
        Connection conn = new Connection(owner, new InetSocketAddress(remote_address, remote_port));
        return conn;
    }

    public Connection createNewInboundConnection(ConnectionOwner owner, SocketChannel channel) {
        Connection conn = new Connection(owner, channel);
        return conn;
    }

    public void addWriteEntity(RateControlledWriteEntity entity) {
        this.write_controller.addWriteEntity(entity);
    }

    public void removeWriteEntity(RateControlledWriteEntity entity) {
        this.write_controller.removeWriteEntity(entity);
    }

    protected ConnectDisconnectManager getConnectDisconnectManager() {
        return this.connect_disconnect_manager;
    }

    protected WriteController getWriteController() {
        return this.write_controller;
    }

    public int getTcpMssSize() {
        return this.tcp_mss_size;
    }
}

