/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class ConnectDisconnectManager {
    private static int MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 3;
    public static int MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = 5;
    private static final int CONNECT_ATTEMPT_TIMEOUT = 30000;
    private static final int CONNECT_ATTEMPT_STALL_TIME = 3000;
    private static final boolean SHOW_CONNECT_STATS = false;
    private final VirtualChannelSelector connect_selector = new VirtualChannelSelector(8);
    private final LinkedList new_requests = new LinkedList();
    private final ArrayList canceled_requests = new ArrayList();
    private final AEMonitor new_canceled_mon = new AEMonitor("ConnectDisconnectManager:NCM");
    private final HashMap pending_attempts = new HashMap();
    private final LinkedList pending_closes = new LinkedList();
    private final AEMonitor pending_closes_mon = new AEMonitor("ConnectDisconnectManager:PC");
    private final Random random = new Random();

    static {
        MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
        MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2;
        if (MIN_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
            MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS == 0 ? 0 : 1;
        }
        COConfigurationManager.addParameterListener("network.max.simultaneous.connect.attempts", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
                MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2;
                if (MIN_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
                    MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS == 0 ? 0 : 1;
                }
            }
        });
    }

    protected ConnectDisconnectManager() {
        AEThread loop = new AEThread("ConnectDisconnectManager"){

            public void runSupport() {
                ConnectDisconnectManager.this.mainLoop();
            }
        };
        loop.setDaemon(true);
        loop.start();
    }

    private void mainLoop() {
        while (true) {
            this.addNewOutboundRequests();
            this.runSelect();
            this.doClosings();
        }
    }

    private void addNewOutboundRequests() {
        while (this.pending_attempts.size() < MIN_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            try {
                this.new_canceled_mon.enter();
                if (this.new_requests.isEmpty()) {
                    this.new_canceled_mon.exit();
                    break;
                }
                ConnectionRequest cr = (ConnectionRequest)this.new_requests.removeFirst();
                this.addNewRequest(cr);
            }
            finally {
                this.new_canceled_mon.exit();
            }
        }
    }

    private void addNewRequest(final ConnectionRequest request2) {
        request2.listener.connectAttemptStarted();
        try {
            request2.channel = SocketChannel.open();
            try {
                String bindIP;
                String ip_tos;
                int snd_size;
                int rcv_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                if (rcv_size > 0) {
                    LGLogger.log("Setting socket receive buffer size for outgoing connection [" + request2.address + "] to: " + rcv_size);
                    request2.channel.socket().setReceiveBufferSize(rcv_size);
                }
                if ((snd_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF")) > 0) {
                    LGLogger.log("Setting socket send buffer size for outgoing connection [" + request2.address + "] to: " + snd_size);
                    request2.channel.socket().setSendBufferSize(snd_size);
                }
                if ((ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPTOS")).length() > 0) {
                    LGLogger.log("Setting socket TOS field for outgoing connection [" + request2.address + "] to: " + ip_tos);
                    request2.channel.socket().setTrafficClass(Integer.decode(ip_tos));
                }
                if ((bindIP = COConfigurationManager.getStringParameter("Bind IP", "")).length() > 6) {
                    LGLogger.log("Binding outgoing connection [" + request2.address + "] to local IP address: " + bindIP);
                    request2.channel.socket().bind(new InetSocketAddress(InetAddress.getByName(bindIP), 0));
                }
            }
            catch (Throwable t) {
                String msg = "Error while processing advanced socket options.";
                Debug.out(msg, t);
                LGLogger.logUnrepeatableAlert(msg, t);
            }
            request2.channel.configureBlocking(false);
            request2.channel.connect(request2.address);
            this.connect_selector.register(request2.channel, new VirtualChannelSelector.VirtualSelectorListener(){

                public void selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    block9: {
                        try {
                            if (request2.channel.finishConnect()) {
                                request2.listener.connectSuccess(request2.channel);
                                break block9;
                            }
                            Debug.out("finishConnect() failed");
                            request2.listener.connectFailure(new Throwable("finishConnect() failed"));
                            try {
                                ConnectDisconnectManager.this.pending_closes_mon.enter();
                                ConnectDisconnectManager.this.pending_closes.addLast(request2.channel);
                            }
                            finally {
                                ConnectDisconnectManager.this.pending_closes_mon.exit();
                            }
                        }
                        catch (Throwable t) {
                            request2.listener.connectFailure(t);
                            try {
                                ConnectDisconnectManager.this.pending_closes_mon.enter();
                                ConnectDisconnectManager.this.pending_closes.addLast(request2.channel);
                            }
                            finally {
                                ConnectDisconnectManager.this.pending_closes_mon.exit();
                            }
                        }
                    }
                    ConnectDisconnectManager.this.pending_attempts.remove(request2);
                }

                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    Debug.out("selectFailure");
                    try {
                        ConnectDisconnectManager.this.pending_closes_mon.enter();
                        ConnectDisconnectManager.this.pending_closes.addLast(request2.channel);
                    }
                    finally {
                        ConnectDisconnectManager.this.pending_closes_mon.exit();
                    }
                    request2.listener.connectFailure(msg);
                    ConnectDisconnectManager.this.pending_attempts.remove(request2);
                }
            }, null);
            request2.connect_start_time = SystemTime.getCurrentTime();
            this.pending_attempts.put(request2, null);
        }
        catch (Throwable t) {
            String full = request2.address.toString();
            String hostname = request2.address.getHostName();
            int port = request2.address.getPort();
            boolean unresolved = request2.address.isUnresolved();
            InetAddress inet_address = request2.address.getAddress();
            String full_sub = inet_address == null ? request2.address.toString() : inet_address.toString();
            String host_address = inet_address == null ? request2.address.toString() : inet_address.getHostAddress();
            String msg = "ConnectDisconnectManager::address exception: full=" + full + ", hostname=" + hostname + ", port=" + port + ", unresolved=" + unresolved + ", full_sub=" + full_sub + ", host_address=" + host_address;
            if (request2.channel != null) {
                String channel = request2.channel.toString();
                String socket = request2.channel.socket().toString();
                String local_address = request2.channel.socket().getLocalAddress().toString();
                int local_port = request2.channel.socket().getLocalPort();
                SocketAddress ra = request2.channel.socket().getRemoteSocketAddress();
                String remote_address = ra != null ? ra.toString() : "<null>";
                int remote_port = request2.channel.socket().getPort();
                msg = String.valueOf(msg) + "\n channel=" + channel + ", socket=" + socket + ", local_address=" + local_address + ", local_port=" + local_port + ", remote_address=" + remote_address + ", remote_port=" + remote_port;
            }
            LGLogger.log(msg, t);
            if (request2.channel != null) {
                try {
                    this.pending_closes_mon.enter();
                    this.pending_closes.addLast(request2.channel);
                }
                finally {
                    this.pending_closes_mon.exit();
                }
            }
            request2.listener.connectFailure(t);
        }
    }

    private void runSelect() {
        try {
            this.new_canceled_mon.enter();
            Iterator can_it = this.canceled_requests.iterator();
            block12: while (can_it.hasNext()) {
                ConnectListener key = (ConnectListener)can_it.next();
                Iterator pen_it = this.pending_attempts.keySet().iterator();
                while (pen_it.hasNext()) {
                    ConnectionRequest request2 = (ConnectionRequest)pen_it.next();
                    if (request2.listener != key) continue;
                    this.connect_selector.cancel(request2.channel);
                    try {
                        this.pending_closes_mon.enter();
                        this.pending_closes.addLast(request2.channel);
                    }
                    finally {
                        this.pending_closes_mon.exit();
                    }
                    pen_it.remove();
                    continue block12;
                }
            }
            this.canceled_requests.clear();
        }
        finally {
            this.new_canceled_mon.exit();
        }
        this.connect_selector.select(100L);
        int num_stalled_requests = 0;
        Iterator i = this.pending_attempts.keySet().iterator();
        while (i.hasNext()) {
            ConnectionRequest request3 = (ConnectionRequest)i.next();
            long waiting_time = SystemTime.getCurrentTime() - request3.connect_start_time;
            if (waiting_time > 30000L) {
                i.remove();
                this.connect_selector.cancel(request3.channel);
                try {
                    this.pending_closes_mon.enter();
                    this.pending_closes.addLast(request3.channel);
                }
                finally {
                    this.pending_closes_mon.exit();
                }
                request3.listener.connectFailure(new Throwable("Connection attempt aborted: timed out after 30sec"));
                continue;
            }
            if (waiting_time >= 3000L) {
                ++num_stalled_requests;
                continue;
            }
            if (waiting_time >= 0L) continue;
            request3.connect_start_time = SystemTime.getCurrentTime();
        }
        if (num_stalled_requests == this.pending_attempts.size() && this.pending_attempts.size() < MAX_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            try {
                this.new_canceled_mon.enter();
                if (!this.new_requests.isEmpty()) {
                    ConnectionRequest cr = (ConnectionRequest)this.new_requests.removeFirst();
                    this.addNewRequest(cr);
                }
            }
            finally {
                this.new_canceled_mon.exit();
            }
        }
    }

    private void doClosings() {
        try {
            this.pending_closes_mon.enter();
            while (!this.pending_closes.isEmpty()) {
                SocketChannel channel = (SocketChannel)this.pending_closes.removeFirst();
                if (channel == null) continue;
                try {
                    channel.close();
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                }
            }
        }
        finally {
            this.pending_closes_mon.exit();
        }
    }

    protected void requestNewConnection(InetSocketAddress address, ConnectListener listener) {
        if (MAX_SIMULTANIOUS_CONNECT_ATTEMPTS == 0) {
            LGLogger.log("Aborting connect attempt to [" + address + "]: Outbound connects disabled in config.");
            listener.connectFailure(new Throwable("Outbound connects disabled in config: MAX_SIMULTANIOUS_CONNECT_ATTEMPTS == 0"));
            return;
        }
        ConnectionRequest cr = new ConnectionRequest(address, listener);
        try {
            this.new_canceled_mon.enter();
            int insert_pos = 0;
            if (this.new_requests.size() > 0) {
                insert_pos = this.random.nextInt(this.new_requests.size());
            }
            this.new_requests.add(insert_pos, cr);
        }
        finally {
            this.new_canceled_mon.exit();
        }
    }

    protected void closeConnection(SocketChannel channel) {
        try {
            this.pending_closes_mon.enter();
            this.pending_closes.addLast(channel);
        }
        finally {
            this.pending_closes_mon.exit();
        }
    }

    protected void cancelRequest(ConnectListener listener_key) {
        try {
            this.new_canceled_mon.enter();
            Iterator i = this.new_requests.iterator();
            while (i.hasNext()) {
                ConnectionRequest request2 = (ConnectionRequest)i.next();
                if (request2.listener != listener_key) continue;
                i.remove();
                this.new_canceled_mon.exit();
                return;
            }
            this.canceled_requests.add(listener_key);
        }
        finally {
            this.new_canceled_mon.exit();
        }
    }

    private static class ConnectionRequest {
        private final InetSocketAddress address;
        private final ConnectListener listener;
        private final long request_start_time;
        private long connect_start_time;
        private SocketChannel channel;

        ConnectionRequest(InetSocketAddress _address, ConnectListener _listener) {
            this.address = _address;
            this.listener = _listener;
            this.request_start_time = SystemTime.getCurrentTime();
        }
    }

    protected interface ConnectListener {
        public void connectAttemptStarted();

        public void connectSuccess(SocketChannel var1);

        public void connectFailure(Throwable var1);
    }
}

