/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileManagerImpl;
import java.io.File;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class FMFileLimited
extends FMFileImpl {
    protected FMFileManagerImpl manager;

    protected FMFileLimited(FMFileOwner _owner, FMFileManagerImpl _manager, File _file) throws FMFileManagerException {
        super(_owner, _file);
        this.manager = _manager;
    }

    public void ensureOpen() throws FMFileManagerException {
        block8: {
            try {
                this.this_mon.enter();
                if (this.raf != null) {
                    this.usedSlot();
                    break block8;
                }
                this.getSlot();
                try {
                    super.ensureOpen();
                }
                finally {
                    if (this.raf == null) {
                        this.releaseSlot();
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void getSlot() {
        this.manager.getSlot(this);
    }

    protected void releaseSlot() {
        this.manager.releaseSlot(this);
    }

    protected void usedSlot() {
        this.manager.usedSlot(this);
    }

    public void setAccessMode(int mode) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (mode != this.access_mode) {
                this.close(false);
            }
            this.access_mode = mode;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public long getSize() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            long l = this.getSizeSupport();
            this.this_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public long getLength() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            long l = this.getLengthSupport();
            this.this_mon.exit();
            return l;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void setLength(long length) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.setLengthSupport(length);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void read(DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.readSupport(buffer, offset);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void write(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.writeSupport(buffer, position);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void write(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen();
            this.writeSupport(buffers, position);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void close() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.close(true);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void close(boolean explicit) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            boolean was_open = this.raf != null;
            try {
                this.closeSupport(explicit);
            }
            finally {
                if (was_open) {
                    this.releaseSlot();
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected boolean isOpen() {
        try {
            this.this_mon.enter();
            boolean bl = this.raf != null;
            this.this_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }
}

