/* Copyright 1993-95 by Carl Harris, Jr. Copyright 1996 by Eric S. Raymond
 * All rights reserved.
 * For license terms, see the file COPYING in this directory.
 */

/***********************************************************************
  module:       socket.h
  project:      popclient
  programmer:   Carl Harris, ceharris@mal.com
  description:  declarations for socket library functions

 ***********************************************************************/

#ifndef SOCKET__
#define SOCKET__

#ifndef  INADDR_NONE
#ifdef   INADDR_BROADCAST
#define  INADDR_NONE	INADDR_BROADCAST
#else
#define	 INADDR_NONE	-1
#endif
#endif

#if defined(HAVE_PROTOTYPES)
/*
Create a new client socket 
returns < 0 on error 
*/
int Socket(char *host, int clientPort);

/* 
Get a string terminated by an '\n', delete any '\r' and the '\n'.
Pass it a valid socket, a buffer for the string, and
the length of the buffer (including the trailing \0)
returns 0 for success. 
*/
int SockGets(int socket, char *buf, int len);

/*
Send a nul terminated string to the socket, followed by 
a CR-LF.  Returns 0 for success.
*/
int SockPuts(int socket, char *buf);

/*
Write a chunk of bytes to the socket.
Returns 0 for success.
*/
int SockWrite(int socket, char *buf, int len);

/*
Read a chunk of bytes from the socket.
Returns 0 for success.
*/
int SockRead(int socket, char *buf, int len);

/* 
Send formatted output to the socket, followed
by a CR-LF.
Returns 0 for success.
*/
int SockPrintf();

/*
Check socket for readability.  return 0 for not readable,
>0 for readable.
*/
int SockStatus(int socket, int seconds);
 
#endif /* defined(HAVE_PROTOTYPES) */

#endif /* SOCKET__ */
